
; Operators

(setq *OPERATORS* '(


(MAKE-CONFIGURATION
 (params (<x1><x2><x3><x4><x5><x6><x7><x8><y8><x9><x10><x11><cost>))
 (preconds
   (and
     (has-case <x1>)
     (has-powersupply <x2>)
     (has-motherboard <x3>)
     (has-memory <x4>)
     (has-controller <x5>)
     (has-harddrive <x6>)
     (has-floppydisk <x7>)
     (has-videoboard <x8> <y8>)
     (has-monitor <x9>)
     (has-ioboard <x10>)
     (has-keyboard <x11>)
     (current-budget-total <cost>)))
 (effects ((add (configuration-complete <cost>)))))




(CHECK-WITHIN-BUDGET
  (params (<max> <running-total>))
  (preconds
      (and
      (budget <max>)
      (Equal-or-less-than <running-total> <max>)
      (configuration-complete <running-total>)))
  (effects ((add (within-budget)))))





(SELECT-CASE
 (params (<obj> <price>))
 (preconds
   (and
   (is-case <obj> <price>)
   (~(has-case <x>))
   (current-budget-total <current-total>)
   (budget <max>)
   (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-case <obj>)))))




(SELECT-POWERSUPPLY
   (params (<type> <mprice>))
  (preconds
    (and 
   (is-motherboard <type> <mprice>)
   (has-motherboard <type>)
   (is-power-supply <type> <size> <price>)
   (~(has-powersupply <x>))
   (current-budget-total <current-total>)
   (budget <max>)
   (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-powersupply <size>)))))





(SELECT-MOTHERBOARD
 (params ( <obj> <price>))
 (preconds 
   (and
   (is-motherboard <obj> <price>)
   (~(has-motherboard <x>))
   (current-budget-total <current-total>)
   (budget <max>)
   (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
	   (if (equal-p <obj> xt)(add (has-buss-size 8-bit)))
	   (if (equal-p <obj> at)(add (has-buss-size 16-bit)))
	   (if (equal-p <obj> 386)(add (has-buss-size 16-bit)))	   
           (add (has-motherboard <obj>)))))

(SELECT-MEMORY
 (params (<obj> <mprice>))
 (preconds
   (and (is-motherboard <obj> <mprice>)
        (has-motherboard <obj>)
        (mem <obj> <size> <price>)
        (~ (has-memory <x>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-memory <size>)))))

(SELECT-CONTROLLER
 (params ( <buss-size> <price>))
 (preconds
   (and
     (has-buss-size <buss-size>)
     (is-controller <buss-size> <price>)
     (~ (has-controller <x>))
     (current-budget-total <current-total>)
     (budget <max>)
     (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-controller <buss-size>)))))

(SELECT-HARD-DISK
 (params (<size> <price>))
 (preconds
    (and
        (is-controller <buss-size> <aprice>)
        (has-controller <buss-size>)
        (is-harddrive <size> <price>)
        (~(has-harddrive <x>))

        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-harddrive <size>)))))

(SELECT-FLOPPY-DISK
 (params (<obj> <price>))
 (preconds
   (and
        (is-floppydisk <obj> <price>)
        (~(has-floppydisk <x>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-floppydisk <obj>)))))

(SELECT-VIDEO-BOARD
 (params (<type> <price> ))
 (preconds
   (and
        (has-buss-size <buss-size>)
        (is-video-board <type> <buss-size> <price>)
        (~(has-videoboard <x> <y>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-videoboard <type> <buss-size>)))))

(SELECT-VIDEO-MONITOR
 (params (<type> <price>))
 (preconds
   (and
        (has-videoboard <type> <size>)
        (is-monitor <type> <price>)
        (~(has-monitor <x>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-monitor <type>)))))

(SELECT-IO
 (params ( <obj> <price>))
 (preconds
    (and
        (is-ioboard <obj> <price>)
        (~(has-ioboard <x>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-ioboard <obj>)))))

(SELECT-KEYBOARD
 (params (<obj> <price> ))
 (preconds
   (and
        (is-keyboard <obj> <price>)
        (~(has-keyboard <x>))
        (current-budget-total <current-total>)
        (budget <max>)
        (Compute-cost <max> <current-total> <new-total> <price>)))
 (effects ((del (current-budget-total <current-total>))
           (add (current-budget-total <new-total>))
           (add (has-keyboard <obj>)))))))
















