;;; ~/my-domains/jobsite/functions.lisp
;;;
;;; AUTHOR : Bruce LeSourd
;;;          c473ak
;;;
;;; DATE   : 5/12/91
;;;
;;; PROJECT - function definitions

(defun resource-type (resource-dsc type)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (list (list (list type (first resource-dsc)))))
	(NIL
	 (equal (first resource-dsc) type))))
	      
(defun material-type (material-dsc type)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (list (list (list type (first material-dsc)))))
	(NIL
	 (equal (first material-dsc) type))))
	      
(defun material-use-loc (material-dsc use-loc)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (list (list (list use-loc (second material-dsc)))))
	(NIL
	 (equal (second material-dsc) use-loc))))
	      
(defun is-sub (type)
  (let ((subcontractors '(excavation
			  steel
			  concrete)))
    (cond (T
	   (mapcar #'(lambda (sub)
		       (list (list type (list 'subcontractor sub))))
		   subcontractors))
	  (NIL
	   (eq (first type) 'subcontractor)))))
	
(defun in-range (arg start end)
  (cond (NIL
	 'no-match-attempted)
	(NIL
	 (let ((list-of-bindings NIL))
	   (dotimes (val (1+ (- end start)))
	     (setf list-of-bindings (append list-of-bindings
					    (list (list (list arg
							      (+ val start)))))))
	   list-of-bindings))
	(T
	 (and (<= start arg)
	      (>= end arg)))))
	 
(defun location (coords space-dsc)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (let* ((x-grids (first space-dsc))
		(y-grids (second space-dsc))
		(bottom-floor (- 0 (third space-dsc)))
		(top-floor (1- (fourth space-dsc)))
		(total-floors (1+ (- top-floor bottom-floor)))
		(list-of-bindings NIL))
	   (dotimes (floor-count total-floors)
	     (dotimes (x-grid x-grids)
	       (dotimes (y-grid y-grids)
		 (setf list-of-bindings (append list-of-bindings
						(list (list (list coords
								  (list x-grid
									y-grid
									(+ floor-count bottom-floor))))))))))
	   list-of-bindings))
	(NIL
	 (let ((x-grids (first space-dsc))
	       (y-grids (second space-dsc))
	       (bottom-floor (- 0 (third space-dsc)))
	       (top-floor (1- (fourth space-dsc))))
	   (and (<= 0 (first coords))
		(<= 0 (second coords))
		(<= bottom-floor (third coords))
		(>= x-grids (first coords))
		(>= y-grids (second coords))
		(>= top-floor (third coords)))))))
	 
(defun staging-location (coords space-dsc)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (let ((x-grids (first space-dsc))
	       (y-grids (second space-dsc))
	       (zero-var-y-side NIL)
	       (max-x-var-y-side NIL)
	       (var-x-zero-side NIL)
	       (var-x-max-y-side NIL))
	   (dotimes (y-grid (1- y-grids))
	     (setf zero-var-y-side (append zero-var-y-side
					   (list (list (list coords
							     (list 0
								   y-grid
								   0))))))
	     (setf max-x-var-y-side (append max-x-var-y-side
					    (list (list (list coords
							      (list (1- x-grids)
								    (1+ y-grid)
								    0)))))))
	   (setf var-y-sides (append zero-var-y-side
				     max-x-var-y-side))
	   (dotimes (x-grid (1- x-grids))
	     (setf var-x-zero-side (append var-x-zero-side
					   (list (list (list coords
							     (list (1+ x-grid)
								   0
								   0))))))
	     (setf var-x-max-y-side (append var-x-max-y-side
					    (list (list (list coords
							      (list x-grid
								    (1- y-grids)
								    0)))))))
	   (setf var-x-sides (append var-x-zero-side
				     var-x-max-y-side))
	   (setf list-of-bindings (append var-y-sides var-x-sides))))
	(NIL
	 (let ((x-grids (first space-dsc))
	       (y-grids (second space-dsc)))
	   (and (= 0 (third coords))
		(or (= 0 (first coords))
		    (= (1- x-grids) (first coords)))
		(or (= 0 (second coords))
		    (= (1- y-grids) (second coords))))))))

(defun add (arg1 arg2 result)
  (cond (NIL
	 'no-match-attempted)
	(T
	 (list (list (list result (+ arg1 arg2)))))
	(NIL
	 (= (+ arg1 arg2) result))))

(defun below (below-coord above-coord)
  (cond ((and (is-variable below-coord)
	      (is-variable above-coord))
	 'no-match-attempted)
	((is-variable below-coord)
	 (list (list (list below-coord (list (first above-coord)
					      (second above-coord)
					      (1- (third above-coord)))))))
	((is-variable above-coord)
	 (list (list (list above-coord (list (first below-coord)
					      (second above-coord)
					      (1+ (third above-coord)))))))
	(T
	 (and (= (first below-coord)
		 (first above-coord))
	      (= (second below-coord)
		 (second above-coord))
	      (= 1 (abs (- (third below-coord)
			   (third above-coord))))))))

(defun can-share-space (type1 type2)
  (cond ((or (is-variable type1)
	     (is-variable type2))
	 'no-match-attempted)		;NYI
	(T
	 (let ((super-type1 (first type1))
	       (sub-type1 (second type1))
	       (super-type2 (first type2))
	       (sub-type2 (second type2)))
	   (or (eq super-type1 'subcontractor)
	       (eq super-type2 'subcontractor)
	       (and (eq sub-type1 bucket-excavator)
		    (eq sub-type2 dump-truck))
	       (and (eq sub-type2 bucket-excavator)
		    (eq sub-type1 dump-truck))
	       (and (eq sub-type1 concrete-mixer)
		    (eq sub-type2 concrete-pumper))
	       (and (eq sub-type2 concrete-mixer)
		    (eq sub-type1 concrete-pumper)))))))

(defun adjacent (coord1 coord2)
  (cond ((or (is-variable coord1)
	     (is-variable coord2))
	 'no-match-attempted)		;NYI
	(T
	 (and (= (third coord1) (third coord2))
	      (= 1 (abs (- (first coord1) (first coord2))))
	      (= 1 (abs (- (second coord1) (second coord2))))))))
	      
(defun is-at-ground-level (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (= 0 (third coord)))))

(defun is-above-ground (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (< 0 (third coord)))))

(defun is-below-ground (coord)
  (cond ((is-variable coord)
	 'no-match-attempted)
	(T
	 (> 0 (third coord)))))




