;;; ~/my-domains/jobsite/domain.lisp
;;;
;;; AUTHOR : Bruce LeSourd
;;;          c473ak
;;;
;;; DATE   : 5/12/91
;;;
;;; PROJECT - domain definition

;;; ******************************************
;;; OPERATORS
;;; ******************************************

(setq *OPERATORS*
  '(
    (MOVE
     (PARAMS (<r-id> <from> <to> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <r-id> <r-dsc>)
       (resource-type <r-dsc> <r-type>)
       (not-equal <r-type> (equipment crane))
       (not-equal <r-type> (equipment concrete-pumper))

       ;;TIME
       (scheduled-from <r-id> <r-available-before-time>)
       (schedule-operation 1 0 <start> <end> <r-available-before-time>)

       ;;SPACE
       (at-loc <from> <r-id> <start>)
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (adjacent <from> <to>)
       (or (ground <to>)
	   (slab <to>))))

     (EFFECTS
      ((DEL (scheduled-from <r-id> <r-available-before-time>))
       (ADD (scheduled-from <r-id> <start>))	    
       ;;(if (between <idle-time> <prev> <start>)
       ;;    (ADD (at-loc <from> <r-id> <idle-time>)))
       (if (between-include-high <start> <move-time> <end>)
	   (ADD (at-loc <to> <r-id> <move-time>))))))

    (HOIST
     (PARAMS (<m-id> <from> <to> <crane-id> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (material <m-id> <m-dsc>)
       (resource <crane-id> <crane-dsc>)
       (resource-type <crane-dsc> (equipment crane))

       ;;TIME
       (scheduled-from <m-id> <m-available-to-time>)
       (scheduled-from <crane-id> <crane-available-to-time>)
       (earliest <available-to-time> <m-available-to-time> <crane-available-to-time> <deadline>) ;prodigy considers two &rest params a syntax error
       (schedule-operation 1 0 <start> <end> <available-to-time>)

       ;;SPACE
       (at-loc <from> <m-id> <start>)
       (at-loc <crane-coords> <crane-id> <start>)
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (below <from> <above-from>)
       (below <to>   <above-to>)
       (air <above-from>)
       (air <above-to>)))
     
     (EFFECTS
      ((DEL (scheduled-from <m-id> <m-available-to-time>))
       (DEL (scheduled-from <crane-id> <crane-available-to-time>))
       (ADD (scheduled-from <m-id> <start>))
       (ADD (scheudled-from <crane-id> <start>))
       ;;(if (between <m-idle-time> <prev1> <start>)
       ;;    (ADD (at-loc <from> <m-id> <m-idle-time>)))
       ;;(if (between <crane-idle-time> <prev2> <start>)
       ;;    (ADD (at-loc <crane-coords> <crane-id> <crane-idle-time>)))
       (if (between-include-high <start> <hoist-time> <end>)
	   (ADD (at-loc <crane-coords> <crane-id> <hoist-time>))
	   (ADD (at-loc <to>           <m-id>     <hoist-time>))))))
	    

    (MOVE-SUBCONTRACTOR
     (PARAMS (<sub-id> <from> <to> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <sub-id> <sub-dsc>)
       (resource-type <sub-dsc> <sub-type>)
       (is-sub <sub-type>)

       ;;TIME
       (scheduled-from <sub-id> <available-to-time>)
       (schedule-operation 1 0 <start> <end> <available-to-time>)

       ;;SPACE
       (at-loc <from> <sub-id> <start>)
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (~ (solid <to>))))

     (EFFECTS
      ((DEL (scheduled-from <sub-id> <available-to-time>))
       (ADD (scheduled-from <sub-id> <start>))
       ;;(if (between <idle-time> <prev> <start>)
       ;;    (ADD (at-loc <from> <sub-id> <idle-time>)))
       (if (between-include-high <start> <move-time> <end>)
	   (ADD (at-loc <to> <sub-id> <move-time>))))))


    (MOVE-ONSITE
     (PARAMS (<id> <coords> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (or (and (resource <id> <dsc>)
		(resource-type <dsc> <type>))
	   (and (material <id> <dsc>)
		(material-type <dsc> <type>))
	   (concrete-batch <id> <dsc>))

       ;;TIME
       (scheduled-from <id> <available-to-time>)
       (schedule-operation 1 0 <start> <end> <available-to-time>)

       ;;SPACE
       (at-loc offsite <id> <start>)
       (staging-location <coords> <space-dsc>)))
       
     (EFFECTS
      ((DEL (scheduled-from <id> <available-to-time>))
       (ADD (scheduled-from <id> <start>))
       ;;(if (between <idle-time> <prev> <start>)
       ;;    (ADD (at-loc offsite <id> <idle-time>)))
       (if (between-include-high <start> <move-time> <end>)
	   (ADD (at-loc <coords> <id> <move-time>))))))

    
    (MOVE-OFFSITE
     (PARAMS (<id> <coords> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (or (and (resource <id> <dsc>)
		(resource-type <dsc> <type>))
	   (and (material <id> <dsc>)
		(material-type <dsc> <type>)))

       ;;TIME
       (scheduled-from <id> <available-to-time>)
       (schedule-operation 1 0 <start> <end> <available-to-time>)

       ;;SPACE
       (at-loc <coords> <id> <start>)
       (staging-location <coords> <space-dsc>)))

     (EFFECTS
      ((DEL (scheduled-from <id> <available-to-time>))
       (ADD (scheduled-from <id> <start>))
       (if (and (is-equal <type> (equipment dump-truck))
		(loaded <id> <load-time>))
	   (DEL (loaded <id> <load-time>)))
       ;;(if (between <idle-time> <prev> <start>)
       ;;    (ADD (at-loc <coords> <id> <idle-time>)))
       (if (between-include-high <start> <move-time> <end>)
	   (ADD (at-loc offsite <id> <move-time>))))))


    (FRAME
     (PARAMS (<coords> <start> <end> <framer-id> <steel-id> <crane-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget <budget>)
       (project-space <space-dsc>)
       
       ;;MATERIEL       
       (resource <framer-id> <framer-dsc>)
       (resource-type <framer-dsc> (subcontractor steel))
       (resource <crane-id> <crane-dsc>)
       (resource-type <crane-dsc> (equipment crane))
       (material <steel-id> <steel-dsc>)
       (material-type <steel-dsc> steel)

       ;;TIME
       (scheduled-from <framer-id> <framer-available-to-time>)
       (scheduled-from <steel-id> <steel-available-to-time>)
       (scheduled-from <crane-id> <crane-available-to-time>)
       (earliest <available-to-time> <framer-available-to-time> <steel-available-to-time> <crane-available-to-time>)
       (schedule-operation 5 0 <start> <end> <available-to-time>) 

       ;;SPACE
       (material-use-loc <steel-dsc>     <coords>)
       (at-loc <coords>       <framer-id> <start>)
       (at-loc <coords>       <steel-id>  <start>)
       (at-loc <crane-coords> <crane-id>  <start>)
       (building-location <coords>       <space-dsc>)
       (or
	(and
	 (below <base-coords> <coords>)
	 (framed <base-coords>))
	(slab <coords>))
       (~ (framed <coords>))))

     (EFFECTS
      ((DEL (scheduled-from <framer-id> <framer-available-to-time>))
       (DEL (scheduled-from <steel-id> <steel-available-to-time>))
       (DEL (scheduled-from <crane-id> <crane-available-to-time>))
       (ADD (scheduled-from <framer-id> <start>))
       (ADD (scheduled-from <steel-id> <start>))
       (ADD (scheduled-from <crane-id> <start>))
       (IF (air <coords>)
	   (DEL (air <coords>)))
       ;;(if (between <framer-idle-time> <prev1> <start>)
       ;;    (ADD (at-loc <coords> <framer-id> <framer-idle-time>)))
       ;;(if (between <steel-idle-time> <prev2> <start>)
       ;;    (ADD (at-loc <coords> <steel-id> <steel-idle-time>)))
       ;;(if (between <crane-idle-time> <prev3> <start>)
       ;;    (ADD (at-loc <crane-coords> <crane-id> <crane-idle-time>)))
       (IF (between-include-high <start> <frame-time> <end>)
	   (ADD (at-loc <coords> <framer-id> <frame-time>))
	   (ADD (at-loc <crane-coords> <crane-id> <frame-time>)))
       (ADD (framed <coords>)))))

    (POUR
     (PARAMS (<coords> <start> <end> <conc-sub-id> <concrete-id> <pumper-id> <mixer-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)
       
       ;;MATERIEL
       (resource <conc-sub-id> <conc-sub-dsc>)
       (resource-type <conc-sub-dsc> (subcontractor concrete))
       (resource <pumper-id> <pumper-dsc>)
       (resource-type <pumper-dsc> (equipment concrete-pumper))
       ;;simulate concrete/mixer combination - concrete must be pumped directly from a mixer
       (concrete-batch <concrete-id> <concrete-dsc>)

       ;;TIME
       (scheduled-from <conc-sub-id> <conc-sub-available-to-time>)
       (scheduled-from <pumper-id> <pumper-available-to-time>)
       (scheduled-from <concrete-id> <concrete-available-to-time>)
       (earliest <available-to-time> <conc-sub-available-to-time> <pumper-available-to-time> <concrete-available-to-time>)
       (schedule-operation 5 0 <start> <end> <available-to-time>)

       ;;SPACE
       (material-use-loc <concrete-dsc> <coords>)
       (at-loc <coords> <conc-sub-id> <start>)
       (at-loc <pumping-coords> <pumper-id> <start>)
       (at-loc <pumping-coords> <concrete-id> <start>)
       (building-location <coords> <space-dsc>)
       (or
	(ground <coords>)
	(and
	 (below <below-coords> <coords>)
	 (framed <below-coords>)))))
     
     (EFFECTS
      ((DEL (scheduled-from <conc-sub-id> <conc-sub-available-to-time>))
       (DEL (scheduled-from <pumper-id> <pumper-available-to-time>))
       (DEL (scheduled-from <concrete-id> <concrete-available-to-time>))
       (ADD (scheduled-from <conc-sub-id> <start>))
       (ADD (scheduled-from <pumper-id> <start>))
       (ADD (scheduled-from <concrete-id> <start>))
       (IF (ground <coords>)
	   (DEL (ground <coords>)))
       ;;(if (between <concrete-idle-time> <prev1> <start>)
       ;;    (ADD (at-loc <pumping-coords> <concrete-id> <concrete-idle-time>)))
       ;;(if (between <pumper-idle-time> <prev2> <start>)
       ;;    (ADD (at-loc <pumping-coords> <pumper-id> <pumper-idle-time>)))
       ;;(if (between <conc-sub-idle-time> <prev3> <start>)
       ;;    (ADD (at-loc <coords> <conc-sub-id> <conc-sub-idle-time>)))
       (IF (between-include-high <start> <pour-time> <end>)
	   (ADD (at-loc <coords>         <concrete-id> <pour-time>))
	   (ADD (at-loc <pumping-coords> <pumper-id>   <pour-time>))
	   (ADD (at-loc <coords>         <conc-sub-id> <pour-time>)))
       (ADD (slab <coords>)))))

    (BUCKET-EXCAVATE
     (PARAMS (<coords> <start> <end> <excavator-id> <bucket-id> <truck-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <excavator-id> <excavator-dsc>)
       (resource-type <excavator-dsc> (subcontractor excavation))
       (resource <bucket-id> <bucket-dsc>)
       (resource-type <bucket-dsc> (equipment bucket-excavator))
       (resource <truck-id> <truck-dsc>)
       (resource-type <truck-dsc> (equipment dump-truck))

       ;;TIME
       (scheduled-from <excavator-id> <excavator-available-to-time>)
       (scheduled-from <bucket-id> <bucket-available-to-time>)
       (scheduled-from <truck-id> <truck-available-to-time>)
       (earliest <available-to-time> <excavator-available-to-time> <bucket-available-to-time> <truck-available-to-time>)
       (schedule-operation 5 0 <start> <end> <available-to-time>)
       (~ (loaded <truck-id> <start>))
       
       ;;SPACE
       (at-loc <excavator-coords> <excavator-id> <start>)
       (at-loc <excavator-coords> <bucket-id>    <start>)
       (at-loc <excavator-coords> <truck-id>     <start>)
       (building-location <coords> <space-dsc>)
       (location <excavator-coords> <space-dsc>)
       (solid <coords>)
       (below <coords> <above-coords>)
       (ground <above-coords>)
       (is-at-ground-level <excavator-coords>)
       (adjacent <excavator-coords> <coords>)))

     (EFFECTS
      ((DEL (scheduled-from <excavator-id> <excavator-available-to-time>))
       (DEL (scheduled-from <bucket-id> <bucket-available-to-time>))
       (DEL (scheduled-from <truck-id> <truck-available-to-time>))
       (ADD (scheduled-from <excavator-id> <start>))
       (ADD (scheduled-from <bucket-id> <start>))
       (ADD (scheduled-from <truck-id> <start>))
       (DEL (solid <coords>))
       (DEL (ground <above-coords>))
       ;;(if (between <excavator-idle-time> <prev1> <start>)
       ;;    (ADD (at-loc <excavator-coords> <excavator-id> <excavator-idle-time>)))
       ;;(if (between <bucket-idle-time> <prev2> <start>)
       ;;    (ADD (at-loc <excavator-coords> <bucket-id> <bucket-idle-time>)))
       ;;(if (between <truck-idle-time> <prev3> <start>)
       ;;    (ADD (at-loc <excavator-coords> <truck-id> <truck-idle-time>)))
       (IF (between-include-high <start> <ex-time> <end>)
	   (ADD (at-loc <excavator-coords> <excavator-id> <ex-time>))
	   (ADD (at-loc <excavator-coords> <bucket-id>    <ex-time>))
	   (ADD (at-loc <excavator-coords> <truck-id>     <ex-time>)))
       (ADD (ground <coords>))
       (ADD (air <above-coords>))
       (ADD (loaded <truck-id> <end>)))))

     ))


      
     
;;; ******************************************
;;; INFERENCE RULES
;;; ******************************************
(setq *INFERENCE-RULES*
  '(
    (INFER-LOCATED-OFFSITE-AT-DEADLINE
     (PARAMS (<id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (or (resource <id> <dsc>)
	   (material <id> <dsc>)
	   (concrete-batch <id> <dsc>))))
     (EFFECTS
      ((ADD (at-loc offsite <id> <deadline>)))))

    (INFER-SCHEDULED-FROM-DEADLINE
     (PARAMS (<id>))
     (PRECONDS
      (and
       (or (resource <id> <dsc>)
	   (material <id> <dsc>)
	   (concrete-batch <id> <dsc>))
       (project-deadline <deadline>)
       (forall (<time>) (in-range <time> 0 <deadline>)
	       (~ (scheduled-from <id> <time>)))))
     (EFFECTS
      ((ADD (scheduled-from <id> <deadline>)))))

    (INFER-SOLID
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-below-ground <coords>)
       (~ (ground <coords>))
       (~ (framed <coords>))
       (~ (air <coords>))
       (~ (slab <coords>))))
      (EFFECTS
       ((ADD (solid <coords>)))))

    (INFER-GROUND
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-at-ground-level <coords>)
       (~ (air <coords>))
       (~ (slab <coords>))
       (~ (framed <coords>))))
     (EFFECTS
      ((ADD (ground <coords>)))))
      
    (INFER-AIR
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-above-ground <coords>)
       (~ (ground <coords>))
       (~ (framed <coords>))
       (~ (slab <coords>))))
      (EFFECTS
       ((ADD (air <coords>)))))
    ))
