;;; ~/my-domains/jobsite/domain.lisp
;;;
;;; AUTHOR : Bruce LeSourd
;;;          c473ak
;;;
;;; DATE   : 5/12/91
;;;
;;; PROJECT - domain definition

;;; ******************************************
;;; OPERATORS
;;; ******************************************

(setq *OPERATORS*
  '(
    (MOVE
     (PARAMS (<r-id> <from> <to> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <r-id> <r-dsc>)
       (resource-type <r-dsc> <r-type>)

       ;;TIME/SPACE
       (last-scheduled <r-id> <from> <prev>)
       (schedule-operation 1 <prev> <start> <end> <deadline>)

       ;;SPACE
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (adjacent <from> <to> <space-dsc>)
       (or (ground <to>)
	   (slab <to>))))

     (EFFECTS
      ((DEL (last-scheduled <r-id> <from> <prev>))
       (ADD (last-scheduled <r-id> <to> <end>)))))

    (HOIST
     (PARAMS (<m-id> <from> <to> <crane-id> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (material <m-id> <m-dsc>)
       (resource <crane-id> <crane-dsc>)
       (resource-type <crane-dsc> (equipment crane))

       ;;TIME/SPACE
       (last-scheduled <m-id> <from> <prev1>)
       (last-scheduled <crane-id> <crane-coords> <prev2>)
       (latest <prev> <prev1> <prev2> 0) ;prodigy considers two &rest params a syntax error
       (schedule-operation 1 <prev> <start> <end> <deadline>)

       ;;SPACE
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (staging-location <crane-coords> <space-dsc>)
       (below <from> <above-from>)
       (below <to>   <above-to>)
       (air <above-from>)
       (air <above-to>)))
     
     (EFFECTS
      ((DEL (last-scheduled <m-id>     <from>         <prev1>))
       (DEL (last-scheduled <crane-id> <crane-coords> <prev2>))
       (ADD (last-scheduled <m-id>     <to>           <end>))
       (ADD (last-scheduled <crane-id> <crane-coords> <end>)))))
	    

    (MOVE-SUBCONTRACTOR
     (PARAMS (<sub-id> <from> <to> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <sub-id> <sub-dsc>)
       (resource-type <sub-dsc> <sub-type>)
       (is-sub <sub-type>)

       ;;TIME/SPACE
       (last-scheduled <sub-id> <from> <prev>)
       (schedule-operation 1 <prev> <start> <end> <deadline>)

       ;;SPACE
       (location <from> <space-dsc>)
       (location <to>   <space-dsc>)
       (or (ground <to>)
	   (slab <to>)
	   (air <to>))))

     (EFFECTS
      ((DEL (last-scheduled <sub-id> <from> <prev>))
       (ADD (last-scheduled <sub-id> <to> <end>)))))

    (MOVE-ONSITE
     (PARAMS (<id> <coords> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (or (and (resource <id> <dsc>)
		(resource-type <dsc> <type>))
	   (and (material <id> <dsc>)
		(material-type <dsc> <type>))
	   (concrete-batch <id> <dsc>))

       ;;TIME/SPACE
       (last-scheduled <id> offsite <prev>)
       (schedule-operation 1 <prev> <start> <end> <deadline>)

       ;;SPACE
       (staging-location <coords> <space-dsc>)))
       
     (EFFECTS
      ((DEL (last-scheduled <id> offsite <prev>))
       (ADD (last-scheduled <id> <coords> <end>)))))

    
    (MOVE-OFFSITE
     (PARAMS (<id> <coords> <start> <end>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (or (and (resource <id> <dsc>)
		(resource-type <dsc> <type>))
	   (and (material <id> <dsc>)
		(material-type <dsc> <type>)))

       ;;TIME/SPACE
       (last-scheduled <id> <coords> <prev>)
       (schedule-operation 1 <prev> <start> <end> <deadline>)

       ;;SPACE
       (staging-location <coords> <space-dsc>)))

     
     (EFFECTS
      ((DEL (last-scheduled <id> <coords> <prev>))
       (IF (and (is-equal <type> (equipment dump-truck))
		(loaded <id> <load-time>))
	   (DEL (loaded <id> <load-time>)))
       (ADD (last-scheduled <id> offsite <end>)))))



    (FRAME
     (PARAMS (<coords> <start> <end> <framer-id> <steel-id> <crane-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget <budget>)
       (project-space <space-dsc>)
       
       ;;MATERIEL       
       (resource <framer-id> <framer-dsc>)
       (resource-type <framer-dsc> (subcontractor steel))
       (resource <crane-id> <crane-dsc>)
       (resource-type <crane-dsc> (equipment crane))
       (material <steel-id> <steel-dsc>)
       (material-type <steel-dsc> steel)
       (material-use-loc <steel-dsc>     <coords>)

       ;;TIME/SPACE
       (last-scheduled <framer-id> <coords> <prev1>)
       (last-scheduled <steel-id>  <coords> <prev2>)
       (last-scheduled <crane-id>  <crane-coords> <prev3>)
       (latest <prev> <prev1> <prev2> <prev3>)
       (schedule-operation 5 <prev> <start> <end> <deadline>) 

       ;;SPACE
       (building-location <coords>       <space-dsc>)
       (staging-location  <crane-coords> <space-dsc>)
       (or
	(and
	 (below <base-coords> <coords>)
	 (framed <base-coords>))
	(slab <coords>))))

     (EFFECTS
      ((DEL (last-scheduled <framer-id> <coords> <prev1>))
       (DEL (last-scheduled <steel-id>  <coords> <prev2>))
       (DEL (last-scheduled <crane-id>  <crane-coords> <prev3>))
       (IF (air <coords>)
	   (DEL (air <coords>)))
       (ADD (last-scheduled <framer-id> <coords> <end>))
       (ADD (last-scheduled <steel-id>  <coords> <deadline>))      ;steel is consumed
       (ADD (last-scheduled <crane-id>  <crane-coords> <end>))
       (ADD (framed <coords>)))))

    (POUR
     (PARAMS (<coords> <start> <end> <conc-sub-id> <concrete-id> <pumper-id> <mixer-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)
       
       ;;MATERIEL
       (resource <conc-sub-id> <conc-sub-dsc>)
       (resource-type <conc-sub-dsc> (subcontractor concrete))
       (resource <pumper-id> <pumper-dsc>)
       (resource-type <pumper-dsc> (equipment concrete-pumper))
       ;;simulate concrete/mixer combination - concrete must be pumped directly from a mixer
       (concrete-batch <concrete-id> <concrete-dsc>)
       (material-use-loc <concrete-dsc> <coords>)

       ;;TIME/SPACE
       (last-scheduled <concrete-id> <pumping-coords> <prev1>)
       (last-scheduled <pumper-id>   <pumping-coords> <prev2>)
       (last-scheduled <conc-sub-id> <coords>         <prev3>)
       (latest <prev> <prev1> <prev2> <prev3>)
       (schedule-operation 5 <prev> <start> <end> <deadline>)

       ;;SPACE
       (building-location <coords>         <space-dsc>)
       (staging-location  <pumping-coords> <space-dsc>)
       (or
	(ground <coords>)
	(and
	 (below <below-coords> <coords>)
	 (framed <below-coords>)))))
     
     (EFFECTS
      ((DEL (last-scheduled <concrete-id> <pumping-coords> <prev1>))
       (DEL (last-scheduled <pumper-id>   <pumping-coords> <prev2>))
       (DEL (last-scheduled <conc-sub-id> <coords> <prev3>))
       (IF (ground <coords>)
	   (DEL (ground <coords>)))
       (ADD (last-scheduled <concrete-id> offsite <deadline>))       ;concrete is consumed
       (ADD (last-scheduled <pumper-id>   <pumping-coords> <end>))
       (ADD (last-scheduled <conc-sub-id> <coords> <end>))
       (ADD (slab <coords>)))))

    (BUCKET-EXCAVATE
     (PARAMS (<coords> <start> <end> <excavator-id> <bucket-id> <truck-id>))
     (PRECONDS
      (and
       (project-deadline <deadline>)
       (project-budget   <budget>)
       (project-space    <space-dsc>)

       ;;MATERIEL
       (resource <excavator-id> <excavator-dsc>)
       (resource-type <excavator-dsc> (subcontractor excavation))
       (resource <bucket-id> <bucket-dsc>)
       (resource-type <bucket-dsc> (equipment bucket-excavator))
       (resource <truck-id> <truck-dsc>)
       (resource-type <truck-dsc> (equipment dump-truck))

       ;;TIME/SPACE
       (last-scheduled <excavator-id> <excavator-coords> <prev1>)
       (last-scheduled <bucket-id>    <excavator-coords> <prev2>)
       (last-scheduled <truck-id>     <excavator-coords> <prev3>)
       (~ (loaded <truck-id> <prev3>))
       (latest <prev> <prev1> <prev2> <prev3>)
       (schedule-operation 5 <prev> <start> <end> <deadline>)
       
       ;;SPACE
       (building-location <coords> <space-dsc>)
       (location <excavator-coords> <space-dsc>)
       (solid <coords>)
       (below <coords> <above-coords>)
       (ground <above-coords>)
       (is-at-ground-level <excavator-coords>)
       (adjacent <excavator-coords> <coords> <space-dsc>)))

     (EFFECTS
      ((DEL (last-scheduled <excavator-id> <excavator-coords> <prev1>))
       (DEL (last-scheduled <bucket-id>    <excavator-coords> <prev2>))
       (DEL (last-scheduled <truck-id>     <excavator-coords> <prev3>))
       (DEL (solid <coords>))
       (DEL (ground <above-coords>))
       (ADD (ground <coords>))
       (ADD (air <above-coords>))
       (ADD (loaded <truck-id> <end>))
       (ADD (last-scheduled <sub-ex-id> <excavator-coords> <end>))
       (ADD (last-scheduled <bucket-id> <excavator-coords> <end>))
       (ADD (last-scheduled <truck-id>  <excavator-coords> <end>)))))

     ))


      
     
;;; ******************************************
;;; INFERENCE RULES
;;; ******************************************
(setq *INFERENCE-RULES*
  '(
    (INFER-SCEDULED-AT-ZERO
     (PARAMS (<id>))
     (PRECONDS
      (and
       (or (resource <id> <dsc>)
	   (material <id> <dsc>)
	   (concrete-batch <id> <dsc>))
       (project-deadline <deadline>)
       (project-budget <budget>)
       (project-space  <space-dsc>)
       (forall (<time>) (in-range <time> 0 <deadline>)
	       (forall (<coords>) (location <coords> <space-dsc>)
		       (~ (last-scheduled <id> <coords> <time>))))))
     (EFFECTS
      ((ADD (last-scheduled <id> offsite 0)))))


    (INFER-SOLID
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-below-ground <coords>)
       (~ (ground <coords>))
       (~ (framed <coords>))
       (~ (air <coords>))
       (~ (slab <coords>))))
      (EFFECTS
       ((ADD (solid <coords>)))))

    (INFER-GROUND
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-at-ground-level <coords>)
       (~ (air <coords>))
       (~ (slab <coords>))
       (~ (framed <coords>))))
     (EFFECTS
      ((ADD (ground <coords>)))))
      
    (INFER-AIR
     (PARAMS (<coords>))
     (PRECONDS
      (and
       (project-space <space-dsc>)
       (location <coords> <space-dsc>)
       (is-above-ground <coords>)
       (~ (ground <coords>))
       (~ (framed <coords>))
       (~ (slab <coords>))))
      (EFFECTS
       ((ADD (air <coords>)))))
    ))
