(defun doprint (var)
  (print var)
  (cond (T T)))



; INTERNAL
; BINDING-LIST from the Prodigy manual page 59
(defun binding-list (var val-list)
  (cond ((null val-list) nil)
	((null (car val-list)) (binding-list var (cdr val-list)))
	(t (append (list (list (list var (car val-list))))
		   (binding-list var (cdr val-list))))))
	
;PRODIGY
; Invert the value, so the second parameter generates the inverse of the first
(defun invert-state (old-state new-state)
  (cond
    ( (and (not (is-variable old-state))
	   (is-variable new-state)) 
     (binding-list new-state (list (opposite old-state))))
    ( (and (not (is-variable new-state))
	   (is-variable old-state))
     (binding-list old-state (list (opposite new-state))))
    ( (and (not (is-variable new-state))
	   (not (is-variable old-state)))
     (not (equals old-state new-state)))
    (T 'no-match-attempted)))

;INTERNAL the opposite of H is L and visa-versa
(defun opposite (hlvalue)
  (cond
    ( (equal hlvalue 'H) 'L)
    ( (equal hlvalue 'L) 'H)
    ( T 'Z)))

;PRODIGY CALL
(defun equals (one two)
  (cond
    ((or (is-variable one) (is-variable two)) 'no-match-attempted)
    (T (equal one two))))

;PRODIGY CALL
(defun not-equals (one two)
  (cond
    ((or (is-variable one) (is-variable two)) 'no-match-attempted)
    ((equal one two) NIL)
    (T T)))



