; Operators

(setq *OPERATORS* '(


(WATER
 (params  (<crop1> <x> <y> <time> <amount-to-water>))
 (preconds 
  (and
;; Static generation is impossible for unbounded water amouns 
   (stored-water <total-water-amount>)
   (valid-water <amount-to-water>)
   (valid-water <old-water-amount>)
   (has-water <x> <y> <time> <old-water-amount>)
   (greater-than-or-equal <total-water-amount> <amount-to-water>)
   (sub <total-water-amount> <amount-to-water> <new-total-water>)
   (addto <old-water-amount> <amount-to-water> <new-water-amount>)))


 (effects (
	   (del (stored-water <total-water-amount>))
	   (del (has-water <x> <y> <time> <old-wateramount>))
	   (add (stored-water <new-total-water>))
	   (if
	    (greater-than-or-equal <new-water-amount> 10)
	    (add (has-water <x> <y> <time> 10)))
	   (if
	    (less-than <new-water-amount> 10)
	    (add (has-water <x> <y> <time> <new-water-amount>))))))



(PLANT
  (params (<crop1> <x> <y> <time>))
  (preconds (plantable <crop1> <x> <y> <time>))

  
 (effects (
	   (del (current-growth <crop1> <x> <y> <time> 0))
	   (add (current-growth <crop1> <x> <y> <time> 1))))) ;; starts out at 1


(GROW       ;; attempt to increase the growth of the crop at x,y
            ;; make sure the place/time we're growing into isn't
            ;; used.
 (params (<crop1> <X> <Y> <TIME> <growth> <growth-amount>))
 (preconds (and (crop <crop1>)                   ;; statically generate crop1
	        (in-xrange <x>)                  ;; bind the spatial location
	        (in-yrange <y>)                  ;; and time that we're 
	        (valid-growth <crop-growth>)
        	(valid-time <time>)
	        (valid-time <new-time>)          ;; bounds check
	        (one-greater <new-time> <time>)  ;; generate the time
	        (growth <crop1> <max-growth>)   ;; generate the max growth

;;	        (valid-growth-amount <growth-amount>)
;;	        (amount-will-grow <crop1> <x> <y> <time> <growth-amount>)
	        (addto <crop-growth> 1 <new-crop-growth>)
;;	        (addto <crop-growth> <growth-amount> <new-crop-growth>)
	        (current-growth <crop1> <x> <y> <time> <crop-growth>)
	        (current-growth <crop1> <x> <y> <new-time> 0) ; avoid "growing into" a used location.  not really crop1
	        (less-than <crop-growth> <max-growth>)
))
(effects (
	  (del (current-growth <crop1> <x> <y> <new-time> 0))
	  
;; make sure it's non-0 , which means it's plantable.  if we didn't do
;; this, it would take on both 0 and whatever growth it grows to.
  (add (current-growth <crop1> <x> <y> <new-time> <new-crop-growth>)))))

	
(HARVEST
 (params (<crop1> <X> <Y> <time> ))
 (preconds      (and
		(crop <crop1>)
		(in-xrange <x>)
		(in-yrange <y>)
;; rearrange next 2 preconds, it's interesting.
		(one-greater <new-amount> <amount>)
		(has-product <crop1> <amount>)
		(valid-time <new-time>)
		(one-greater <new-time> <time>)
		(valid-time <time>)
	      	(growth <crop1> <max-growth>)
		(valid-growth <max-growth>)
		(current-growth <crop1> <x> <y> <time> <max-growth>)
   	        (~ (harvested <crop1> <x> <y> <time>))))
 (effects (
	    (del (has-product <crop1> <amount>))
	    (add (harvested <crop1> <x> <y> <time>))
	    (add (has-product <crop1> <new-amount>))
	    (if (valid-time <newtime>)
		(add (current-growth <crop1> <x> <y> <new-time> 0))))))
))


(setq *INFERENCE-RULES* '(

      			  
			  
  (INFER-NO-HIGHER-NEIGHBORS
   (params (<crop1> <x> <y> <time>))
   (preconds 
    (and 
;; NONSTATIC, DEBUG.  reverse args
     (current-growth <crop1> <x> <y> <time> <crop-growth>)  ;; my growth
     (height-based-on-growth <crop1> <crop-growth> <crop-height>) ;; my height
     (valid-growth <crop-growth>)                           ;; bind me and
     (forall (<adj-x>)     (adjacent-x <x> <adj-x>)
      (forall (<adj-y>)     (adjacent-y <y> <adj-y>)
       (and
	(crop <neighbor>)                  ;; bind each neighbor
;; DEBUG nonstatic generators
	(current-growth <crop1> <adj-x> <adj-y> <time> <n-growth>)
	(height-based-on-growth <crop1> <n-growth> <n-height>) ;; bind n-ht
	(greater-than-or-equal <crop-height> <n-height>))))))

   (effects (
	     (add (no-higher-neighbor <crop1> <x> <y> <time> )))))
			 
(INFER-TOTAL-GROWTH
 (params (<crop1> <x> <y> <time>))
 (preconds
  (and
   (light-growth <crop1> <x> <y> <time> <growth-by-light>)
   (water-growth <crop1> <x> <y> <time> <growth-by-water>)))
 (effects (
;;; FUCKED!
	   (add (amount-will-grow <crop1> <x> <y> <time> <will-grow>)))))

(INFER-GROWTH-DUE-TO-GOOD-LIGHT
 (params (<crop1> <x> <y> <time>))
 (preconds
  (no-higher-neighbor <crop1> <x> <y> <time>))

 (effects (
	   (add (light-growth <crop1> <x> <y> <time> 1)))))



(INFER-GROWTH-DUE-TO-BAD-LIGHT                 ;; this operator handles the
 (params (<crop1> <x> <y> <time> <will-grow>)) ;; case of a plant being blocked
 (preconds                                     ;; by other neighboring plants
  (and                
   (needs-light <crop1> <light-needed>)         ;; value of optimal light
   (growth-bad-light <light-needed> <will-grow>);; willgrow=1/lightneeded
                                               ;; amount to grow with bad light
    (~ (no-higher-neighbor <crop1> <x> <y> <time>))))
 
(effects (
	  (add (light-growth <crop1> <x> <y> <time> <will-grow>)))))
    
(INFER-GROWTH-DUE-TO-WATER 
;;  assigns "good" (1) or "bad" (1/2)
;; by whether the actual water is +/- 2 from the required water
;; in the case of water tolerance is 0, or +/- 5 from the
;; required water amount in the case of a water tolerant plant

 (params (<crop1> <x> <y> <time>))
 (preconds
  (and
;; nonstatic
   (has-water <x> <y> <time> <c-water-has>)
   (valid-water <c-water-has>)
   (water-tolerance <crop1> <c-water-tol>)
   (needs-water     <crop1> <c-water-need>)
   (calc-water-growth <c-water-has> <c-water-need> <c-water-tol> <will-grow>)))
(effects (
	  (add (water-growth <crop1> <x> <y> <time> <will-grow>)))))
 
(INFER-PLANTABLE
(params (<crop1> <x> <y> <time>))
  
(preconds 
     (and
      (current-growth <crop1> <x> <y> <time> 0)
      (plant-time-max <crop1> <max-planting-time>)
      (plant-time-min <crop1> <min-planting-time>)
      (between-numbers <time> <min-planting-time> <max-planting-time>)))
(effects (
	  (add (plantable <crop1> <x> <y> <time>)))))

))
			  






