(setq *SCR-OP-REJECT-RULES*  nil)
(setq *SCR-NODE-SELECT-RULES* nil)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; don't reorder the non-top-level preconditions
;;
;;
(setq *SCR-GOAL-SELECT-RULES* 
      '(
	(SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;
;;; DONT-PLANT-BEFORE-POSSIBLE 
;;;
;;; this prevents the planter from planting before it's possible by
;;; cutting it off at the harvest.  It checks when harvesting that
;;; if you subtracted off the length of time that it takes a plant
;;; to grow that you wouldn't be off the lower bounds of the valid
;;; time sections within the domain.
;;;

(setq *SCR-BINDINGS-REJECT-RULES* 
      '(
	(DONT-PLANT-BEFORE-POSSIBLE

	 (lhs (and 
	       (current-node <node>)
	       (current-op <node> HARVEST)
	       (candidate-bindings <node> (<crop1> <x> <y> <time>))
	       (known <node> (growth <crop1> <growth>))
	       (known <node> (earlier <time> <growth>))))
	 (rhs (reject bindings (<crop1> <x> <y> <time>))))
	
	
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; DONT-PLANT-IF-USED
;;;
;;; This prevents the planter from planting in a square that is already
;;; used.  IT does this by checking the harvest time, subtracting
;;; the growth time to get the effective planting time, and checking
;;; to make sure that this is either 0 (if the precondition PLANT has
;;; not been achieved ) or 1 (the precondition PLANT has been achieved)
;;; this saves some wasted time trying to harvest in squares where
;;; is-plantable is clearly going to be false.
	       

	(DONT-PLANT-IF-USED
	 (lhs
	  (and
	   (current-node <node>)
	   (current-op <node> HARVEST)
	   (current-goal <node> (has-product <crop1> <goal-amt>))
	   (candidate-bindings <node> (<crop1> <x> <y> <harvest-time> ))
	   (known <node> (growth <crop1> <crop-growth>))
	   (known <node> (addto <plant-time> <crop-growth> <harvest-time>))
	   (known <node> (addto <plant-time> 1 <actual-plant-time>))
	   (known <node> 
	    (current-growth <crop1> <x> <y> <actual-plant-time> <g-amt>))
	   (not-equal <g-amt> 1)
	   (not-equal <g-amt> 0)))
	 (RHS (reject bindings (<crop1> <x> <y> <harvest-time>))))



))
(setq *SCR-GOAL-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES nil)

(setq *SCR-GOAL-REJECT-RULES* 
      '(

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  PRUNE-FERT
;;;
;;; One of the problems with this problem solver is that it spends inordinate
;;; amounts of time trying to solve has-fert for various parameters.  This
;;; is an attempt to prune the search tree by disallowing the goal if
;;; there are two goals of has-fert in a row.  It helps, but doesn't completely
;;; prune the tree in the most optimal way.



	(PRUNE-FERT
	 (lhs
	  (and
	   (current-node <node>)
	   (primary-candidate-goal <node> 
	    (HAS-FERT <c-x> <c-y> <c-time> <c-amt>))))
	 (rhs (reject goal (has-fert <c-x> <c-y> <c-time> <c-amt>))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; 
;;; PRUNE-WATER
;;;
;;; THis is a lot like prune-fert, it is an attempt to prune the search
;;; tree that is generated when has-fert is subgoaled on, since has-fert
;;; is a precondition to itself.   This doesn't completely work to prune
;;; the search tree, but it helps a lot.

	(PRUNE-WATER
	 (lhs
	  (and
	   (current-node <node>)
	   (primary-candidate-goal <node> 
	    (HAS-WATER <c-x> <c-y> <c-time> <c-amt>))))
	 (rhs (reject goal (has-fert <c-x> <c-y> <c-time> <c-amt>))))

))
	   
	   
(setq *SCR-BINDINGS-PREFERENCE-RULES* 
      '(
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; SPREAD-OUT-IN-2d-SPACE
;;;
;;; this helps the spreading out of crops in 2-d space rather than
;;; in time by preferring the planting of a crop at time 1, or
;;; the harvesting of a crop at time growth-time to the harvest at
;;; any other time.  This greatly helps the search for a place to put
;;; things, and does not disallow the placing of two things on
;;; the same square.


(SPREAD-OUT-IN-2D-SPACE
      (lhs
       (and
	(current-node <node>)
	(current-op <node> HARVEST)
	(known <node> (growth <crop1> <crop-growth>))
	(candidate-bindings <node> (<crop1> <x1> <y1> <crop-growth>))
	(candidate-bindings <node> (<crop1> <x2> <y2> <time2>))))
 (rhs (prefer bindings (<crop1> <x1> <y1> <crop-growth>)
       (<crop1> <x2> <y2> <time2>))))))
	

	 
(setq *SCR-BINDINGS-SELECT-RULES* nil)
	   

	   
(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)

