;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; PRODIGY domain: distrib-software-config
;;;
;;; This problem spec exemplifies a small-scale
;;; configuration where entities have only peripheral needs.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(load-goal '(configured))


(load-start-state '(
		    ;; The static predicates - used as generators.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;;; Declare the problem's software constituents.
		    ;;;; The number represents load requirements.
		    ;;;; PRODIGY forall cycles though bindings in
		    ;;;; alphabetic order, thus, i order entities'
		    ;;;; names in decreasing order of load requirements.
		    ;;;; frequency (in + out).

		    (is-entity transducer 3)   
		    (is-entity renderer 6)     
		    (is-entity participant 5)

		    ;;;; Declare the problem's computer constituents.
		    ;;;; The number represents load capability.

		    (is-dist-site thumper 10)
		    (is-dist-site brillig 5)
		    (is-dist-site slithy 2)


		    ;;;; Declare the problem's external device constituents.
		    ;;;; Further linkage constraints.

		    (is-periph eyephone1)
		    (is-periph dataglove1)
		    (is-periph polhemus1)

		    (drives-periph renderer eyephone1)
		    (drives-periph transducer polhemus1)
		    (drives-periph participant dataglove1)

		    (supports-periph thumper eyephone1)
		    (supports-periph thumper polhemus1)
		    (supports-periph brillig dataglove1)
		    (supports-periph brillig polhemus1)
		    (supports-periph slithy dataglove1)
		    (supports-periph slithy polhemus1)


		    ;; The non-static predicates - represent dynamic state.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;
		    ;; Initialize state variables (maintained during solving).
		    ;;

		    (dist-site-load brillig 0)
		    (dist-site-load slithy 0)
		    (dist-site-load thumper 0)

		    ))


