;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; PRODIGY domain: distrib-software-config
;;;
;;; This problem spec exemplifies a small-scale
;;; configuration where entities have only message-passing needs.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(load-goal '(configured))


(load-start-state '(
		    ;; The static predicates - used as generators.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;;; Declare the problem's software constituents.
		    ;;;; The number represents load requirements.
		    ;;;; PRODIGY forall cycles though bindings in
		    ;;;; alphabetic order, thus, i order entities'
		    ;;;; names in decreasing order of message passing
		    ;;;; frequency (in + out).

		    (is-entity aa-participant1 3)      ; 9 = 3out + 6in
		    (is-entity ab-transducer1 4)       ; 6 = 6out + 0in
		    (is-entity ac-renderer1 5)         ; 1 = 0out + 1in
		    (is-entity ad-terrain1 1)          ; 1 = 1out + 0in


		    ;;;;
		    ;;;; Represent paths of inter-entity communication.

		    (is-sense visible)
		    (is-sense movegen)

		    ;; The number represents message frequency.

		    (has-out-sense ad-terrain1 visible 1)
		    (has-out-sense aa-participant1 visible 3)
		    (has-out-sense ab-transducer1 movegen 6)

		    (has-in-sense ac-renderer1 visible)
		    (has-in-sense aa-participant1 movegen)



		    ;;;; Declare the problem's computer constituents.
		    ;;;; The number represents load capability.

		    (is-dist-site thumper 8)
		    (is-dist-site brillig 5)
		    (is-dist-site slithy 3)


		    ;; The non-static predicates - represent dynamic state.
		    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


		    ;;
		    ;; Initialize state variables (maintained during solving).
		    ;;

		    (dist-site-load brillig 3)
		    (dist-site-load slithy 0)
		    (dist-site-load thumper 0)

		    ))


