	;; Don't bother mounting an entity to site when
	;; some or all the entity's required peripherals
	;; are attached to another site.

	(REJECT-ENTITY-WHOSE-PERIPHS-ATTACHED-ELSEWHERE
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> mount-site)
	       (candidate-bindings <n> (<entity> <site>))
	       (known <n> (exists (<periph>) (is-periph <periph>)
			   (and
			    (drives-periph <entity> <periph>)
			    (exists (<site-other> <max>)
				    (is-dist-site <site-other> <max>)
				    (and
				     (diff <site> <site-other>)
				     (periph-attached <periph>
						      <site-other>))))))))
	 (rhs (reject bindings (<entity> <site>))))



	;; Don't bother attaching peripheral to a site when
	;; the entity that requires it is mounted on another site.
	;; The counterpart to reject-entity-whose-periphs-attached-elsewhere.

	(REJECT-PERIPH-WHOSE-ENTITY-MOUNTED-ELSEWHERE
	 (lhs (and
	       (current-node <n>)
	       (current-op <n> attach-periph)
	       (candidate-bindings <n> (<periph> <site>))
	       (known <n> (exists (<entity> <req>)
			   (is-entity <entity> <req>)
			   (and (drives-periph <entity> <periph>)
				(exists (<site-other> <max>)
					(is-dist-site <site-other> <max>)
					(and (diff <site> <site-other>)
					     (mounted <entity>
						      <site-other>))))))))
	 (rhs (reject bindings (<periph> <site>))))





;;;
;;; msg-path
;;;
;;; Determine whether two entities have been linked
;;; for inter-object message passing.  two ways.

(INFER-MSG-PATH
 (params (<entity1> <entity2>))
 (preconds (and
	    (is-entity <entity1> <req1>)
	    (is-entity <entity2> <req2>)
	    (diff <entity1> <entity2>)
	    (or

	     ;; Entities can pass messages over network or
	     ;; across shared-memory.
	     ;; Future control rule will prefer these goals
	     ;; based on message frequencies.

	     (net-connected <entity1> <entity2>)
	     (mem-connected <entity1> <entity2>)))
  )
 (effects ((add (msg-path <entity1> <entity2>)))
  )
 )




	;; The idea is that inside the msg-path inference rule,
	;; two entities will have been chosen (by previous sc-rules)
	;; such that they exchange msgs at high frequencies.
	;; Thus, we always try to share memory first, connect
	;; by network link second.

	(MAKE-TALKERS-SHARE-MEM
	 (lhs (and
	       (current-node <n>)
	       (current-goal <n> (msg-path <e1> <e2>))
	       (known <n> (msg-flow <e1> <e2> <f>))
	       (candidate-op <n> net-connect)
	       (candidate-op <n> mem-connect)))
	 (rhs (prefer operator mem-connect net-connect)))

