


(defun calc_whole_ingr (amount_ingr amount_prod)
    (cond ((and (is-variable amount_ingr) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_ingr)
	   (binding-list amount_ingr (list (* 5 amount_prod))))))


(defun calc_skim_ingr (amount_ingr amount_prod)
    (cond ((and (is-variable amount_ingr) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_ingr)
	   (binding-list amount_ingr (list (* 7 amount_prod))))))



(defun calc_twice_ingr (amount_ingr amount_prod)
    (cond ((and (is-variable amount_ingr) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_ingr)
	   (binding-list amount_ingr (list (* 2 amount_prod))))))



(defun calc_same_ingr (amount_ingr amount_prod)
    (cond ((and (is-variable amount_ingr) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_ingr)
	   (binding-list amount_ingr (list (* 1 amount_prod))))))



(defun calc_quad_ingr (amount_ingr amount_prod)
    (cond ((and (is-variable amount_ingr) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_ingr)
	   (binding-list amount_ingr (list (* 4 amount_prod))))))



(defun calc_additive (amount_add amount_prod)
    (cond ((and (is-variable amount_add) 
		(is-variable amount_prod))
	   'no-match-attempted)
	  ((is-variable amount_add)
	   (binding-list amount_add (list (/ amount_prod 1))))
          ((< amount_add amount_prod))))
       


(defun update_avail (amount_needed amount_avail amount_to_get amount_left)
    (cond ((and (is-variable amount_needed) 
		(is-variable amount_avail)
		(is-variable amount_to_get)
                (is-variable amount_left))
	   'no-match-attempted)

	  ( (and (is-variable amount_to_get)
                 (is-variable amount_left))

           (cond ((> amount_avail amount_needed)
                   (binding-list amount_to_get (list 0))
	           (binding-list amount_left
                                 (list (- amount_avail amount_needed)))
                 )
                 ((< amount_avail amount_needed)
                   (binding-list amount_to_get
                                 (list (- amount_needed amount_avail)))
                   (binding-list amount_left (list 0))
                 )
                 ((= amount_avail amount_needed)
                   (binding-list amount_to_get (list 0))
                   (binding-list amount_left (list 0))
                 )))))


;  BINDING-LIST returns a binding list for a single variable, only
;
(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))
