

(setq *SCR-BINDINGS-PREFERENCE-RULES* '(

;;
;; PREFER-SCHEDULING-INNERCORE-IN-EARLIER-YEAR
;;   Straight forward, we want to finish asap so schedule
;;   courses asap!
;;

(PREFER-SCHEDULING-INNERCORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-OUTERCORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-ELECTIVECORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))


;;
;; PREFER-SCHEDULING-INNERCORE-IN-EARLIER-QUARTER
;;   Straight forward, we want to finish asap so schedule
;;   courses asap!
;;

(PREFER-SCHEDULING-INNERCORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-OUTERCORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-ELECTIVECORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))


;;
;; PREFER-SCHEDULING-INNERCORE-WITH-PREREQUISITES-SCHEDULED
;;   This is a GREAT rule which is used to prefer goals
;;   that do not have any prerequisites OR goals whose
;;   prerequisites are already in the state.  This way we
;;   don't schedule a class that needs 3 prerequisites in the 
;;   first quarter / year.
;;   

(PREFER-SCHEDULING-INNERCORE-WITH-PREREQUISITES-SCHEDULED
 (PRIORITY 1)
 (LHS 
  (AND 
   (CURRENT-NODE       <node>)
   (CANDIDATE-GOAL     <node> (Scheduled-class <class1>))
   (CANDIDATE-GOAL     <node> (Scheduled-class <class2>))
   (KNOWN              <node> 
    (OR
     (AND
      (~ (Class-prereq <class1> <other-class1>))
      (Class-prereq    <class1> <other-class2>))
     (AND
        (Class-prereq <class1>    <p-class1>)
	(Scheduled-class          <p-class1>)
        (Class-prereq <class2>    <p-class2>)
	(~ (Scheduled-class       <p-class2>)))))))
  (RHS (PREFER GOAL (Scheduled-class <class1>)
                    (Scheduled-class <class2>) )))

))

(setq *SCR-GOAL-REJECT-RULES*         nil)
(setq *SCR-OP-REJECT-RULES*           nil)
(setq *SCR-NODE-PREFERENCE-RULES*     nil)
(setq *SCR-GOAL-PREFERENCE-RULES*     nil)
(setq *SCR-OP-PREFERENCE-RULES*       nil)
(setq *SCR-NODE-SELECT-RULES*         nil)
(setq *SCR-GOAL-SELECT-RULES*         nil)
(setq *SCR-OP-SELECT-RULES*           nil)
(setq *SCR-BINDINGS-SELECT-RULES*     nil)
(setq *SCR-NODE-REJECT-RULES*         nil)

(setq *SCR-BINDINGS-REJECT-RULES* '(

;;
;; REJECT-INNERCORE-CLASS-ALREADY-SCHEDULED
;;
;; IMPORTANT: This rule is used to prevent trying to schedule a class
;;   that has already been scheduled in the domain.  Currently operator
;;   handles this... so not implemented.

;(REJECT-INNERCORE-CLASS-ALREADY-SCHEDULED
; (LHS (AND (CURRENT-NODE       <node>)
;           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
;           (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
;	   (KNOWN              <node> (Scheduled-class <class>))))
; (RHS (REJECT BINDINGS (<class> <quarter> <year>))))

;;
;; REJECT-SCHEDULING-CLASS-IN-SAME-QUARTER-WITH-SUICIDE
;;   Currently of no use as the operator handles this.
;;

;(REJECT-SCHEDULING-CLASS-IN-SAME-QUARTER-WITH-SUICIDE
; (LHS
;  (AND
;   (CURRENT-NODE       <node>)
;   (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
;   (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
;   (KNOWN              <node>
;    (AND
;     (Class-no-take-with <class> <suicide-class>)
;     (Scheduled <suicide-class> <quarter> <year>
;		<ss-m-sect>  M  <ss-m-start>  <ss-m-end>
;		<ss-t-sect>  T  <ss-t-start>  <ss-t-end>
;		<ss-w-sect>  W  <ss-w-start>  <ss-w-end>
;		<ss-t-sect>  TH <ss-th-start> <ss-th-end>
;		<ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))))
; (RHS (REJECT BINDINGS (<class> <quarter> <year>))))


))
