
(setq *OPERATORS* '(

(ADD-INNERCORE-CLASS
 (PARAMS (<class> <quarter> <year>))
 (PRECONDS
  (AND


(INFER-QUARTER-FULL
 (preconds
  (AND
   (Quarter-info <quarter> <year> <max-in-quarter> <quarter-count>)
   (Check-quarter-full <quarter-count> <max-in-quarter>)))
 (effects
  ((add (Quarter-full <quarter> <year>)))))

   (Quarter-info     <quarter> <year> <max-in-quarter> <quarter-count>)
   (~ (Quarter-full  <quarter> <year>))
   (Increment        <quarter-count>  <new-quarter-count>)

   ;; Grab course information
   (Class-core    <class> INNERCORE)
   (Class-credits <class> <credits>)

   ;; To simplify, used fixed class credits of 5 until we get sucker
   ;;   pruned down. Search TOO big now to concider variable credits..
   (Generate-credits  <credit-count> <new-credit-count> 5)
   (innercore-credits <credit-count>)

; ?? put this in a scr?
   ;; Test to make sure class has not been scheduled yet.
   (Class <class>)
   (~ (Scheduled-class <class>))

   ;; Make sure no suicidal classes are already scheduled in same quarter
   (FORALL
    (<suicide-class>)
    (Class-no-take-with <class> <suicide-class>)
    (~ (Scheduled <suicide-class> <quarter> <year>
		  <ss-m-sect>  M  <ss-m-start>  <ss-m-end>
		  <ss-t-sect>  T  <ss-t-start>  <ss-t-end>
		  <ss-w-sect>  W  <ss-w-start>  <ss-w-end>
		  <ss-t-sect>  TH <ss-th-start> <ss-th-end>
		  <ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))
   
   ;; Make sure that EVERY prerequisite has been scheduled AND that
   ;;   they are scheduled in earlier quarters
   (FORALL
    (<prereq-class>)
    (Class-prereq <class> <prereq-class>)
    (AND
     (Scheduled-class <prereq-class>)
     (Scheduled <prereq-class>  <prereq-quarter> <prereq-year>
		<prereq-m-sect>  M  <prereq-m-start>  <prereq-m-end>
		<prereq-t-sect>  T  <prereq-t-start>  <prereq-t-end>
		<prereq-w-sect>  W  <prereq-w-start>  <prereq-w-end>
		<prereq-t-sect>  TH <prereq-th-start> <prereq-th-end>
		<prereq-f-sect>  F  <prereq-f-start>  <prereq-f-end>)
     (Quarter-less-than <prereq-quarter> <prereq-year>
                        <quarter>        <year>)))

   ;; Make sure that the candidate class does not have a time conflict with
   ;;   ALL classes currently scheduled in the same quarter / year
   (AND

    ;; Pick an available schedule, note that the section number for Tuesday
    ;;   and Thursday MUST be the same.
    (Class-time <class> <quarter> <m-section>  M  <m-start>  <m-end>)
    (Class-time <class> <quarter> <t-section>  T  <t-start>  <t-end>)
    (Class-time <class> <quarter> <w-section>  W  <w-start>  <w-end>)
    (Class-time <class> <quarter> <t-section> TH  <th-start> <th-end>)
    (Class-time <class> <quarter> <f-section>  F  <f-start>  <f-end>)
   
    ;; Grab ALL other classes currently scheduled in the quarter / year
    (FORALL 
     (<other-class>
      <s-m-sect>  <s-m-start>  <s-m-end>
      <s-t-sect>  <s-t-start>  <s-t-end>
      <s-w-sect>  <s-w-start>  <s-w-end>
                  <s-th-start> <s-th-end>
      <s-f-sect>  <s-f-start>  <s-f-end>)
     
     (Scheduled <other-class> <quarter> <year>
		<s-m-sect>  M  <s-m-start>  <s-m-end>
		<s-t-sect>  T  <s-t-start>  <s-t-end>
		<s-w-sect>  W  <s-w-start>  <s-w-end>
		<s-t-sect>  TH <s-th-start> <s-th-end>
		<s-f-sect>  F  <s-f-start>  <s-f-end>)

     ;; Make sure there is NO time conflicts with these classes
     (AND
      (No-time-conflict <s-m-start>  <s-m-end>  <m-start>  <m-end>)
      (No-time-conflict <s-t-start>  <s-t-end>  <t-start>  <t-end>)
      (No-time-conflict <s-w-start>  <s-w-end>  <w-start>  <w-end>)
      (No-time-conflict <s-t-start>  <s-th-end> <th-start> <th-end>)
      (No-time-conflict <s-f-start>  <s-f-end>  <f-start>  <f-end>))))
    ))
  (EFFECTS 
   ((ADD (Scheduled <class> <quarter> <year> 
	  <m-section>  M  <m-start>  <m-end>
	  <t-section>  T  <t-start>  <t-end>
	  <w-section>  W  <w-start>  <w-end>
	  <t-section> TH <th-start>  <th-end>
	  <f-section>  F  <f-start>  <f-end>))
    (ADD (Scheduled-class <class>))

    ;; Update the quarter information and remove Quarter-not-full if 
    ;;   quarter is NOW full having added the class
;    (DEL (Quarter-info <quarter> <year> <max-in-quarter> <quarter-count>))
;    (ADD (Quarter-info <quarter> <year> <max-in-quarter> <new-quarter-count>))
;    (IF  (Quarter-full <new-quarter-count> <max-in-quarter>)
;	 (DEL (Quarter-not-full <quarter> <year>)))

    ;; Update the number of innercore credits scheduled
    (DEL (innercore-credits <credit-count>))
    (ADD (innercore-credits <new-credit-count>)) )))


;;
;; ADD-INNERCORE-COMPLETED:
;;   We are currently set up to handle fixed credit increments so that
;;   additions matches exactly with goal.. will never exceed it..
;;   eg. this case NOT handled but can easily be implemented swapping
;;       commented code once search is pruned down effectivly.
;;     (innercore-credits  18)
;;     (innercore-required 20)
;;     take a class for 4 credits for total of 22
;;
;;   Again, we do this to cut down the search until other aspects
;;   of the search are pruned to reasonable levels via scrs


(ADD-INNERCORE-COMPLETED
 (preconds
  (and
   (innercore-required <required>)

   ;;Variable credits
;   (Core-completed <count> <required>)
;   (innercore-credits <count>)

   ;;Fixed credits
   (innercore-credits <required>)))
 (effects
  ((add (InnerCoreCompleted)))))

))


(setq *INFERENCE-RULES* '(

(INFER-SCHEDULE-COMPLETE
 (preconds
  (InnerCoreCompleted))
;  (OuterCoreCompleted)
;  (ElectiveCoreCompleted))
 (effects
  ((add (ScheduleComplete)))))


(INFER-QUARTER-FULL
 (preconds
  (



))

; (setq *SCR-BINDINGS-SELECT-RULES* '(
;
;
; This control rule is to be used to prevent Prodigy from trying to 
;   add a class in a quarter that it doesn't have times available...
;   ie. we want <quarter> to available in static predicat Class-time.
;
; PROBLEM: I get the following error message:
;    Syntax error detected in rhs of control rule: RESTRICT-CLASSES...
;
; Why??!!
;
; (RESTRICT-CLASSES-TO-QUARTERS-AVAILABLE
;  (LHS (AND
;       (CURRENT-NODE     <node>)
;       (CURRENT-OP       <node> ADD-INNERCORE-CLASS)
;       (CURRENT-BINDINGS <node> (<class> <quarter> <year>))
;       (KNOWN  <node> (~ (Class-time <class> <quarter> 
;		      		      <m-section> M <m-start> <m-end>)))))
; (RHS (REJECT BINDINGS (<class> <quarter> <year>))))
;
; ))       

(setq *SCR-NODE-REJECT-RULES* '(

))







