

(setq *SCR-BINDINGS-REJECT-RULES* '(

;;
;; REJECT-INNERCORE-CLASS-ALREADY-SCHEDULED
;;
;; IMPORTANT: This rule is used to prevent trying to schedule a class
;;   that has already been scheduled in the domain.

(REJECT-INNERCORE-CLASS-ALREADY-SCHEDULED
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
	   (KNOWN              <node> (Scheduled-class <class>))))
 (RHS (REJECT BINDINGS (<class> <quarter> <year>))))

(REJECT-OUTERCORE-CLASS-ALREADY-SCHEDULED
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
	   (KNOWN              <node> (Scheduled-class <class>))))
 (RHS (REJECT BINDINGS (<class> <quarter> <year>))))

(REJECT-ELECTIVECORE-CLASS-ALREADY-SCHEDULED
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
	   (KNOWN              <node> (Scheduled-class <class>))))
 (RHS (REJECT BINDINGS (<class> <quarter> <year>))))


;;
;; REJECT-SCHEDULING-CLASS-IN-SAME-QUARTER-WITH-SUICIDE
;;   Currently of no use as the "FATAL" aspect of this
;;   domain does not allow it to run. Implement versions
;;   for OUTERCORE and ELECTIVECORE when needed.
;;

;(REJECT-SCHEDULING-CLASS-IN-SAME-QUARTER-WITH-SUICIDE
; (LHS
;  (AND
;   (CURRENT-NODE       <node>)
;   (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
;   (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
;   (KNOWN              <node>
;    (AND
;     (Class-no-take-with <class> <suicide-class>)
;     (Scheduled <suicide-class> <quarter> <year>
;		<ss-m-sect>  M  <ss-m-start>  <ss-m-end>
;		<ss-t-sect>  T  <ss-t-start>  <ss-t-end>
;		<ss-w-sect>  W  <ss-w-start>  <ss-w-end>
;		<ss-t-sect>  TH <ss-th-start> <ss-th-end>
;		<ss-f-sect>  F  <ss-f-start>  <ss-f-end>)))))
; (RHS (REJECT BINDINGS (<class> <quarter> <year>))))


;;
;; REJECT-SCHEDULING-CLASS-WHOSE-PREREQS-NOT-SCHEDULED
;;   Currently of no use as the "FATAL" aspect of this
;;   domain does not allow it to run. Implement versions
;;   for OUTERCORE and ELECTIVECORE when needed.
;;

;(REJECT-SCHEDULING-CLASS-WHOSE-PREREQS-NOT-SCHEDULED
; (LHS
;  (AND
;   (CURRENT-NODE       <node>)
;   (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
;   (CANDIDATE-BINDINGS <node> (<class> <quarter> <year>))
;   (KNOWN              <node>
;    (AND
;     (Class-prereq <class> <prereq-class>)     
;     (OR
;      (~ (Scheduled-class <prereq-class>))
;      (AND
;       (Scheduled <prereq-class>  <prereq-quarter> <prereq-year>
;		  <prereq-m-sect>  M  <prereq-m-start>  <prereq-m-end>
;		  <prereq-t-sect>  T  <prereq-t-start>  <prereq-t-end>
;		  <prereq-w-sect>  W  <prereq-w-start>  <prereq-w-end>
;		  <prereq-t-sect>  TH <prereq-th-start> <prereq-th-end>
;		  <prereq-f-sect>  F  <prereq-f-start>  <prereq-f-end>)
;       (~ (Quarter-less-than <prereq-quarter> <prereq-year>
;			     <quarter>        <year>))))))))
; (RHS (REJECT BINDINGS (<class> <quarter> <year>))))

))

(setq *SCR-BINDINGS-PREFERENCE-RULES* '(


;;
;; PREFER-SCHEDULING-INNERCORE-IN-EARLIER-YEAR
;;   Straight forward, we want to finish asap so schedule
;;   courses asap!
;;

(PREFER-SCHEDULING-INNERCORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-OUTERCORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-ELECTIVECORE-IN-EARLIER-YEAR
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <year1> <year2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))


;;
;; PREFER-SCHEDULING-INNERCORE-IN-EARLIER-QUARTER
;;   Straight forward, we want to finish asap so schedule
;;   courses asap!
;;

(PREFER-SCHEDULING-INNERCORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-OUTERCORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))

(PREFER-SCHEDULING-ELECTIVECORE-IN-EARLIER-QUARTER
 (PRIORITY 0)
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
           (CANDIDATE-BINDINGS <node> (<class> <quarter1> <year1>))
           (CANDIDATE-BINDINGS <node> (<class> <quarter2> <year2>))
           (LESS-THAN <quarter1> <quarter2>)))
 (RHS (PREFER BINDINGS (<class> <quarter1> <year1>)
                       (<class> <quarter2> <year2>) )))


;;
;; PREFER-SCHEDULING-INNERCORE-WITH-PREREQUISITES-SCHEDULED
;;   This simply allows us to choose good initial bindings
;;   for the domain.. CS210.  
;;   

(PREFER-SCHEDULING-INNERCORE-WITH-PREREQUISITES-SCHEDULED
 (PRIORITY 1)
 (LHS 
  (AND 
   (CURRENT-NODE       <node>)
   (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
   (CANDIDATE-BINDINGS <node> (<class>   <quarter>   <year>))
   (CANDIDATE-BINDINGS <node> (<p-class> <p-quarter> <p-year>))
   (KNOWN              <node> 
    (OR
     (~ (Class-prereq <p-class> <other-class>))
     (AND
        (Class-prereq <class> <p-class>)
	(Scheduled-class      <p-class>))))))
  (RHS (PREFER BINDINGS (<p-class> <p-quarter> <p-year>)
                        (<class>   <quarter>   <year>  ) )))

(PREFER-SCHEDULING-OUTERCORE-WITH-PREREQUISITES-SCHEDULED
 (PRIORITY 1)
 (LHS 
  (AND 
   (CURRENT-NODE       <node>)
   (CURRENT-OP         <node> ADD-OUTERCORE-CLASS)
   (CANDIDATE-BINDINGS <node> (<class>   <quarter>   <year>))
   (CANDIDATE-BINDINGS <node> (<p-class> <p-quarter> <p-year>))
   (KNOWN              <node> 
    (OR
     (~ (Class-prereq <p-class> <other-class>))
     (AND
        (Class-prereq <class> <p-class>)
	(Scheduled-class      <p-class>))))))
  (RHS (PREFER BINDINGS (<p-class> <p-quarter> <p-year>)
                        (<class>   <quarter>   <year>  ) )))

(PREFER-SCHEDULING-ELECTIVECORE-WITH-PREREQUISITES-SCHEDULED
 (PRIORITY 1)
 (LHS 
  (AND 
   (CURRENT-NODE       <node>)
   (CURRENT-OP         <node> ADD-ELECTIVECORE-CLASS)
   (CANDIDATE-BINDINGS <node> (<class>   <quarter>   <year>))
   (CANDIDATE-BINDINGS <node> (<p-class> <p-quarter> <p-year>))
   (KNOWN              <node> 
    (OR
     (~ (Class-prereq <p-class> <other-class>))
     (AND
        (Class-prereq <class> <p-class>)
	(Scheduled-class      <p-class>))))))
  (RHS (PREFER BINDINGS (<p-class> <p-quarter> <p-year>)
                        (<class>   <quarter>   <year>  ) )))

))

(setq *SCR-GOAL-REJECT-RULES*         nil)
(setq *SCR-OP-REJECT-RULES*           nil)
(setq *SCR-NODE-PREFERENCE-RULES*     nil)
(setq *SCR-GOAL-PREFERENCE-RULES*     nil)
(setq *SCR-OP-PREFERENCE-RULES*       nil)
(setq *SCR-NODE-SELECT-RULES*         nil)
(setq *SCR-GOAL-SELECT-RULES*         nil)
(setq *SCR-OP-SELECT-RULES*           nil)
(setq *SCR-BINDINGS-SELECT-RULES*     nil)
(setq *SCR-NODE-REJECT-RULES* '(


;; This is a rule I WAS working on to try to eliminate scheduling
;; the same class down the search tree.
;;
;(REJECT-CLASSES-ALREADY-SOUGHT
; (LHS 
;  (AND
;   (CURRENT-NODE    <cur-node>)
;   (CANDIDATE-NODE  <can-node>)
;   (CURRENT-OP      <cur-node> ADD-INNERCORE-CLASS)
;   (CANDIDATE-OP    <can-node> ADD-INNERCORE-CLASS)
;
;   ;; But we don't know this yet! State not updated yet!
;;; (KNOWN           <cur-node> (Scheduled <cur-class>))
;   ;; I need a CURRENT-BINDINGS
;   (CANDIDATE-BINDINGS <cur-node> (<class> <cur-quarter> <cur-year>))
;   (CANDIDATE-BINDINGS <can-node> (<class> <can-quarter> <can-year>))))
; (RHS (REJECT NODE <can-node>)))
	   


;;
;; REJECT-INNERCORE-CLASS-IF-INNERCORE-COMPLETED
;;   ALL innercore classes must be scheduled.  We don't
;;   want to try to schedule one if the core requirement
;;   has already been completed
;;

(REJECT-INNERCORE-CLASS-IF-INNERCORE-COMPLETED
 (LHS (AND (CURRENT-NODE       <node>)
           (CURRENT-OP         <node> ADD-INNERCORE-CLASS)
	   (KNOWN              <node> (InnerCoreCompleted))))
 (RHS (REJECT NODE <node>)))

))
