(setq *SCR-GOAL-SELECT-RULES* 
	'(
	(SELECT-FIRST-GOAL
	 (lhs (and (current-node <node>)
		   (not-top-level-node <node>)
		   (primary-candidate-goal <node> <goal>)))
	 (rhs (select goal <goal>)))
))

(setq *SCR-GOAL-PREFERENCE-RULES*
	'(

	  ;;; The following four rules prefer a goal (goal1) over another
          ;;; goal (goal2) for which goal2 is a prerequisite.

	  (PREFER-PREREQ-GOAL-1
	   (lhs (and (current-node <node>)
	             (candidate-goal <node> (havetaken <course1>))
	             (candidate-goal <node> (havetaken <course2>))
	             (not-equal <course1> <course2>)
	             (known <node> (prerequisite <course1> <course2>))))
	   (rhs (prefer goal (havetaken <course2>) (havetaken <course1>))))

	  (PREFER-PREREQ-GOAL-2
	   (lhs (and (current-node <node>)
		     (candidate-goal <node> havetaken <course1>)
		     (candidate-goal <node> (time-taken <course2>
					                <quarter2>
					                <year2>
							<credits2>))))
	   (rhs (prefer goal (havetaken <course2>) (time-taken <course1>
						               <quarter1>
						               <year1>
                                                               <credits1>))))
	  (PREFER-PREREQ-GOAL-3
	   (lhs (and (current-node <node>)
	             (candidate-goal <node> (time-taken <course1>
					                <quarter1>
					                <year1>
					                <credits1>))
		     (candidate-goal <node> (havetaken <course2>))
	             (not-equal <course1> <course2>)
	             (known <node> (prerequisite <course1> <course2>))))
	   (rhs (prefer goal (time-taken <course2>
			                 <quarter2>
			                 <year2>
			                 <credits2>)
	                      (havetaken <course1>))))

	  (PREFER-PREREQ-GOAL-4
	   (lhs (and (current-node <node>)
		     (candidate-goal <node> (time-taken <course1>
					                <quarter1>
					                <year1>
					                <credits1>))
		     (candidate-goal <node> (time-taken <course2>
					                <quarter2>
					                <year2>
					                <credits2>))
		     (not-equal <course1> <course2>)
		     (known <node> (prerequisite <course1> <course2>))))
	   (rhs (prefer goal (time-taken <course2>
			                 <quarter2>
			                 <year2>
			                 <credits2>)
		             (time-taken <course1>
			                 <quarter1>
			                 <year1>
			                 <credits1>))))

))

(setq *SCR-BINDINGS-REJECT-RULES* 
      '(
	;;; Rejects bindings that will obviously fail for TAKE-COURSE-SET

	(DONT-TRY-USED-COURSE
	 (lhs (and (current-node <node>)
	           (current-op <node> TAKE-COURSE-SET)
	           (candidate-bindings <node> (<course> <set>))
	           (known <node> (used-course <course> <set>))))
	 (rhs (reject bindings (<course>))))

	;;; Rejects bindings that will obviously fail for TAKE-CREDIT-SET

	(DONT-TRY-USED-CREDITS
	 (lhs (and (current-node <node>)
	           (current-op <node> TAKE-CREDIT-SET)
	           (candidate-bindings <node> (<course> <set>))
	           (known <node> (used-credits <course> <set>))))
	 (rhs (reject bindings (<course>))))
))

(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-OP-REJECT-RULES* nil)
