;;;
;;; minus
;;;
;;; Tests if x - y = z.  If exactly one of arguments is a variable it will
;;; return a binding list for that argument.  If more than one arguments
;;; is a variable, returns 'no-match-attempted.
;;;

(defun minus (x y z)
  (cond ((and (is-variable x) (is-variable y)) 'no-match-attempted)
	((and (is-variable x) (is-variable z)) 'no-match-attempted)
	((and (is-variable y) (is-variable z)) 'no-match-attempted)
	((and (is-variable x) 
	      (is-variable y)
	      (is-variable z)) 'no-match-attempted)
	((is-variable x)
	 (binding-list x (list (+ z y))))
	((is-variable y)
	 (binding-list y (list (- x z))))
	((is-variable z)
	 (binding-list z (list (- x y))))
	((= (- x y) z) t)
	(t nil)))

;;;
;;; geqzero
;;;
;;; Returns t if num >= 0, false otherwise.  If num is a variable returns
;;; no-match-attempted.
;;;

(defun geqzero (num)
  (cond ((is-variable num) 'no-match-attempted)
	((>= num 0))
	(t nil)))
	 
;;;
;;; earlier
;;;
;;; Determines if quarter-before/year-before occurs before
;;; quarter-after/year-after.  Do not attempt a binding list.  If any arguments
;;; are variables, returns no-match-attempted
;;;

(defun earlier (quarter-before year-before quarter-after year-after)
  (cond ((is-variable quarter-before) 'no-match-attempted)
	((is-variable year-before) 'no-match-attempted)
	((is-variable quarter-after) 'no-match-attempted)
	((is-variable year-after) 'no-match-attempted)
	((> year-before year-after) nil)
	((< year-before year-after))
	((= year-before year-after)
	 (cond ((eq quarter-before quarter-after) nil)
	       ((eq quarter-before 'FALL))
	       ((and (eq quarter-before 'WINTER)
		     (not (eq quarter-after 'FALL))))
	       ((and (eq quarter-before 'SPRING)
		     (not (eq quarter-after 'FALL))
		     (not (eq quarter-after 'WINTER))))
	       ((and (eq quarter-before 'SUMMER)
		     (not (eq quarter-after 'FALL))
		     (not (eq quarter-after 'WINTER))
		     (not (eq quarter-after 'SPRING))))
	       (t nil)))))

;;;
;;; conc-or-earlier
;;;
;;; Determines if quarter-before/year-before occurs at the same time or before
;;; quarter-after/year-after.  Does not attempt a binding list.  If any
;;; arguments are variables, returns no-match-attempted.
;;;

(defun conc-or-earlier (quarter-before year-before quarter-after year-after)
  (cond ((is-variable quarter-before) 'no-match-attempted)
	((is-variable year-before) 'no-match-attempted)
	((is-variable quarter-after) 'no-match-attempted)
	((is-variable year-after) 'no-match-attempted)
	((> year-before year-after) nil)
	((< year-before year-after))
	((= year-before year-after)
	 (cond ((eq quarter-before quarter-after))
	       ((eq quarter-before 'FALL))
	       ((and (eq quarter-before 'WINTER)
		     (not (eq quarter-after 'FALL))))
	       ((and (eq quarter-before 'SPRING)
		     (not (eq quarter-after 'FALL))
		     (not (eq quarter-after 'WINTER))))
	       ((and (eq quarter-before 'SUMMER)
		     (not (eq quarter-after 'FALL))
		     (not (eq quarter-after 'WINTER))
		     (not (eq quarter-after 'SPRING))))
	       (t nil)))))

;;;
;;; maximum
;;;
;;; Tests if result is the max of num1 and num2.  If so returns true.  If num1
;;; or num2 is a variable returns no-match-attempted.  If result is a variable
;;; returns a binding list for result with the max of num1 and num2.  
;;; Otherwise, it returns false.
;;;

(defun maximum (num1 num2 result)
  (cond ((is-variable num1) 'no-match-attempted)
	((is-variable num2) 'no-match-attempted)
	((and (is-variable result)
	      (>= num1 num2))
	 (binding-list result (list num1)))
	((and (is-variable result)
	      (< num1 num2))
	 (binding-list result (list num2)))
	(t (or (and (= result num1)
		    (>= num1 num2))
	       (and (= result num2)
		    (<= num1 num2))))))

;;;
;;; binding-list
;;;
;;; Copied from schedworld
;;;

(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))
