;; ****************************************************************************
;;
;;                      FUNCTIONS
;; ****************************************************************************


(proclaim '(special *START-STATE* *END-TIME*))

(eval-when (compile) 
	(load-path *PLANNER-PATH* "g-loop")
	(load-path *PLANNER-PATH* "g-map"))


;; **************************************
;;
;;  PREVIOUS-SLOT ---  META FUNCTION ---
;;     pre-time gets <time-1>.
;;
;; *************************************



(defun previous-slot (time pre-time)
  (cond ((and (is-variable time)
              (is-variable pre-time)) 'no-match-attempted)
        ((is-variable pre-time)
              (binding-list pre-time (times-before (- time 1))))
        ((eq (- time 1) pre-time))))


;; *************************************
;;   
;;   NEXT-TIME
;;    increment time by an argument, incr.
;;
;; **************************************

(defun next-time (next incr time)
  (cond
    ((and (is-variable next)
        (is-variable time)) 'no-match-attempted)
    ((is-variable next)
        (binding-list next (times-after (+ (- incr 1) time))))
    ((eq next (+ incr time)))))
    
;; *************************************
;;
;; LESS-THAN   (copied from SCHEDWORLD)
;;
;; *************************************

(defun less-than (a b)
    (cond ((is-variable a) 'no-match-attempted)
	  ((is-variable b) 'no-match-attempted)
	  (t (< a b))))

(defun times-before (last-tme)
    (g-loop (init tme 1 ret-val nil)
	  (while (not (> tme last-tme)))
	  (do (push tme ret-val))
	  (next tme (+ 1 tme))
	  (result ret-val)))

(defun times-after (last-tme)
    (g-loop (init tme (+ 1 last-tme) ret-val nil)
	  (while (not (> tme *END-TIME*)))
	  (do (push tme ret-val))
	  (next tme (+ 1 tme))
	  (result ret-val)))

(defun before (tme last-tme)
    (cond ((and (is-variable tme) 
		(is-variable last-tme))
	   (error "before"))
	  ((is-variable tme)
	   (binding-list tme (times-before last-tme)))
	  ((is-variable last-tme)
	   (binding-list last-tme (times-after tme)))
	  ((> last-tme tme))))
	  

(defun later (tme prev-tme)
    (cond ((and (is-variable tme) 
		(is-variable prev-tme))
	   'no-match-attempted)
	  ((is-variable tme)
	   (binding-list tme (times-after prev-tme)))
	  ((is-variable prev-tme)
	   (binding-list prev-tme (times-before tme)))
	  ((> tme prev-tme))))

(defun is-time (tme)
    (cond ((is-variable tme) (binding-list tme (times-before *END-TIME*)))
          (t)))


;; ***************************************
;;
;;   BINDING-LIST  (copied from SCHEDWORLD)
;;    returns a binding list for a single variable, only
;;
;; ***************************************


(defun binding-list (var val-list)
  (cond ((null val-list) nil)
        ((null (car val-list)) (binding-list var (cdr val-list)))
        (t (append (list (list (list var (car val-list))))
                   (binding-list var (cdr val-list))))))

(defun mult-binding-list (vars val-lists)
    (and vars
	 (g-loop (init ret-val nil vals (car val-lists) var (car vars)
		     rst-bindings (mult-binding-list (cdr vars) 
				      (cdr val-lists)))
	       (while vals)
	       (do (cond (rst-bindings
			     (setq ret-val 
				   (append
					  (g-map (b in rst-bindings)
						(save (cons (list var 
								  (car
								      vals)) b)))
					  ret-val)))
			 (t (push (list (list var (car vals))) ret-val))))
	       (next vals (cdr vals))
	       (result ret-val))))

(add-meta-fn 'previous-slot)


