(setf *OPERATORS* '(

  (CUT
  ;;
  ;; cut an object as specified if none of CUT, ADD
  ;; REMOVE-SHELL, WASH operations is going on.
  ;;
  (params (<obj> <how-to> <time>))
  (preconds
     (and (object <obj>)
	  (finished wash <obj>)
          (cook-to cut <obj>)
	  (to-cut <obj> <how-to>)
      	  (can-be-cut <obj>)
	  (last-scheduled <obj> <pre-time1>)
          (last-scheduled knife <pre-time2>)
          (last-scheduled kitchen-board <pre-time3>)
	  (later <time> <pre-time1>)
          (later <time> <pre-time2>)
          (later <time> <pre-time3>)
          (idle WASHING <time>)
	  (idle CUTTING <time>)
          (idle ADDING <time>)))
  (effects (
     (del (to-cut <obj> <how-to>))
     (del (cook-to cut <obj>))
     (add (finished cut <obj>))
     (del (last-scheduled <obj> <pre-time1>))
     (add (last-scheduled <obj> <time>))
     (add (scheduled CUTTING <time>))))
  )


  (REMOVE-SHELL
  ;;
  ;; an object has shell and need to be removed.
  ;; (surface hard <obj>) implies that an object has shell.
  ;; make sure none of CUT, WASH, REMOVE-SHELL,ADD  operations
  ;; is going on.
  ;; 
  (params (<obj> <time>))
  (preconds
     (and (object <obj>)
          (surface hard <obj>)
          (last-scheduled <obj> <pre-time>)
          (later <time> <pre-time>)
          (idle WASHING <time>)
          (idle CUTTING <time>)
          (idle ADDING <time>)))
  (effects (                                   
     (del (surface hard <obj>))
     (del (last-scheduled <obj> <pre-time>))
     (add (scheduled CUTTING <time>))
     (add (last-scheduled <obj> <time>))))
  )
    

  (ADD
  ;;
  ;; add an object to one of utensils which are being 
  ;; used, or will be used later. 

  ;;
  (params (<obj> <tool> <time>))
  (preconds
     (and (object <obj>)
          (tools <tool> <opr>)
          (to-be-added <obj> <tool>)
          (ready-to-add <obj>)
          (last-scheduled <obj> <pre-time>)
          (later <time> <pre-time>)
          (idle WASHING <time>)
          (idle CUTTING <time>)))
  (effects (
     (del (to-be-added <obj> <tool>))           
     (add (added <obj> <tool>))
     (del (last-scheduled <obj> <pre-time>))
     (add (scheduled ADDING <time>))
     (add (last-scheduled <obj> <time>))))
  )

  (ADD-SEASONING-TO
  ;;
  ;; add seasoning to one of utensils which is 
  ;; in use. 
  ;; 
  (params (<sps> <tool> <time>))
  (preconds
     (and (add-spice <sps> <tool>)
          (exists (<obj>) (object <obj>)
          (and (added <obj> <tool>)
               (last-scheduled <obj> <time>)))))
  (effects (
     (del (add-spice <sps> <tool>))
     (add (scheduled ADDING <time>))))
  )

  (SEASON-WITH
  ;; 
  ;; add seasoning to food.
  ;;
  (params (<obj> <sps> <time>))
  (preconds
    (and  (add-spice <sps> <obj>)    ; nonstatic generator
          (finished wash <obj>)
          (last-scheduled <obj> <pre-time>)
          (later <time> <pre-time>)))
  (effects (
     (if (cook-to season <obj>)
     (del (cook-to season <obj>)))
     (del (add-spice <sps> <obj>))
     (del (last-scheduled <obj> <pre-time>))
     (add (last-scheduled <obj> <time>))
     (add (scheduled ADDING <time>))))
  )

     

  (WASH-INGREDIENT
  ;;
  ;; wash food <obj> if none of REMOVE-SHELL, CUT, ADD,
  ;; WASH operations is going on.
  ;; 
  (params (<obj> <time>))
  (preconds
     (and (object <obj>)
	  (last-scheduled <obj> <pre-time>)
	  (later <time> <pre-time>)
          (can-be-washed <obj>)
          (idle CUTTING <time>)
	  (idle WASHING <time>)
          (idle ADDING <time>)))
  (effects (
     (if (cook-to wash <obj>) (del (cook-to wash <obj>)))
     (add (finished wash <obj>))
     (del (last-scheduled <obj> <pre-time>))
     (add (last-scheduled <obj> <time>))
     (add (scheduled WASHING <time>))))
  )

  (WASH-UTENSIL
  ;;
  ;; wash utensil if it's dirty and emty, and none of
  ;; REMOVE-SHELL, CUT, WASH, ADD  operations is going on.
  ;;
  (params (<tool> <time>))
  (preconds
     (and (tools <tool> <opr>)
	  (dirty <tool>)
	  (~ (full <tool>))
	  (last-scheduled <tool> <pre-time>)
	  (later <time> <pre-time>)
          (idle CUTTING <time>)
	  (idle WASHING <time>)
          (idle ADDING <time>)))
  (effects (
     (del (dirty <tool>))
     (add (finiched wash <tool>))
     (del (last-scheduled <tool> <pre-time>))
     (add (last-scheduled <tool> <time>))
     (add (scheduled WASHING <time>))))
  )

  (SERVE-DISH-FROM-TO
  ;;
  ;; serve a dish from the utensil to a plate.
  ;;
  (params (<tool> <plate> <time>))
  (preconds
     (and (tools <tool> <opr>)
          (plates <plate>)
          (last-scheduled <plate> <pre-time2>)
          (last-scheduled <tool> <pre-time>)
          (later <time> <pre-time2>)
          (later <time> <pre-time>)
          (idle SERVING <time>)))
  (effects (
     (del (full <tool>))
     (del (last-scheduled <plate> <pre-time2>))
     (del (last-scheduled <tool> <pre-time>))
     (add (last-scheduled <plate> <time>))
     (add (last-scheduled <tool> <time>))
     (add (scheduled SERVING <time>))))
  )



  (PLACE-FOOD-ON
  ;;
  ;;  place food on the tool which is going to be used to 
  ;;  roll rice.
  ;;
  (params (<obj> <tool> <time>))
  (preconds
     (and (object <obj>)
          (tools <tool> <opr>)
          (to-be-added <obj> <tool>)
          (ready-to-add <obj>)
          (last-scheduled <obj> <pre-time1>)
          (last-scheduled <tool> <pre-time2>)
          (later <time> <pre-time1>)
          (later <time> <pre-time2>)
          (idle ADDING <time>)
          (idle WASHING <time>)
          (idle CUTTING <time>)))
  (effects (
     (del (to-be-added <obj> <tool>))           
     (add (placed <obj> <tool>))
     (del (last-scheduled <tool> <pre-time2>))
     (del (last-scheduled <obj> <pre-time1>))
     (add (last-scheduled <tool> <time>))
     (add (last-scheduled <obj> <time>))))
  )


  (SPREAD-RICE-ON
  ;;
  ;; place rice on the roller after it is seasoned.
  ;;
  (params (<tool> <time>))
  (preconds
     (and (tools <tool> ROLLING)
          (seasoned rice)
          (last-scheduled <tool> <pre-time1>)
          (last-scheduled rice <pre-time2>)
          (later <time> <pre-time1>)
          (later <time> <pre-time2>)))
  (effects (
     (del (last-scheduled <tool> <pre-time1>))
     (del (last-scheduled rice <pre-time2>))
     (add (last-scheduled <tool> <time>))
     (add (last-scheduled rice <time>))
     (add (spread rice <tool>))))
  )

  (ROLL-RICE
  ;;
  ;; add all the ingredients on rice and roll it.
  ;; If rice is not cooked yet, have to achieve
  ;; (finished boil rice <time>) first before achieving
  ;; roll-rice.
  ;;
  (params (<time>))
  (preconds
     (and (tools <tool> ROLLING)
          (placed laver <tool>)
          (spread rice <tool>)
          (forall (<obj>) (ingrets <obj>)
          (and (seasoned <obj>)
               (placed <obj> <tool>)))
          (last-scheduled <tool> <pre-time>)
          (later <time> <pre-time>)))
  (effects (
     (add (rolled rice))))
  )


  (START
  ;; 
  ;; start operation using stove <st>.
  ;; operation could be anything as long as it heats
  ;; the food in one way or another.
  ;; (fry, bake, boil, steam ,..... etc).
  ;;
  (params (<opr> <obj> <tool> <st> <heat> <time> <next-time>))
  (preconds
     (and (tools <tool> <opr>)
          (stove <st>)
          (object <obj>)
          (time-for <opr> <obj> <time-unit> <heat>)
          (~ (dirty <tool>))                         ; utensil has to be clean
          (added <obj> <tool>)                       ; obj is added to utensil
          (seasoned <tool>)                          ; spice is added
          (last-scheduled <st> <pre-time3>)
          (last-scheduled <tool> <pre-time2>)
          (last-scheduled <obj> <pre-time1>)
          (later <time> <pre-time1>)
          (later <time> <pre-time2>)
          (later <time> <pre-time3>)
          (next-time <next-time> <time-unit> <time>))); get the time to finish
  (effects (
     (add (start <opr> <obj> <tool> <st> <time> <next-time>))
     (del (last-scheduled <obj> <pre-time1>))
     (del (last-scheduled <tool> <pre-time2>))
     (del (last-scheduled <st> <pre-time3>))
     (add (last-scheduled <obj> <next-time>))
     (add (last-scheduled <tool> <next-time>))
     (add (last-scheduled <st> <next-time>))
     (add (scheduled <opr> <next-time>))))
   )

  (FINISH
  ;;
  ;; finish operation going on at stove <st>.
  ;;
  (params (<opr> <st> <time>))
  (preconds
     (and (tools <tool> <opr>)
          (stove <st>)
          (start <opr> <obj> <tool> <st> <pre-time> <time>)
          (~ (exists (<ingr>) (object <ingr>)     ; all the ingredients are
	  (to-be-added <ingr> <tool>)))))         ; added to a utensil.
  (effects (
     (add (dirty <tool>))
     (add (full <tool>))

     (add (finished <opr> <obj>))
     (del (start <opr> <obj> <tool> <st> <pre-time> <time>))))
   )

))
 


(setf *INFERENCE-RULES* '(

  (INFER-CAN-BE-CUT
  ;;
  ;; if surface of an object is hard, remove the shell.
  ;;
  (params (<obj>))
  (preconds
   (~ (surface hard <obj>)))
  (effects (
     (add (can-be-cut <obj>))))
  )

  (INFER-SEASONED
  ;;
  ;; true if all the seasonings are added to <obj>
  ;;
  (params (<obj>))
  (preconds
     (~ (exists (<sps>) (add-spice <sps> <obj>))))
  (effects (
     (add (seasoned <obj>))))
  )

  (INFER-CAN-BE-WASHED
  ;;
  ;; if any operation has already done to an object
  ;; it can't be washed.
  ;;
  (params (<obj>))
  (preconds
     (and (~ (surface soft <obj>))
          (~ (finished <opr> <obj>))))
  (effects (
     (add (can-be-washed <obj>))))
  )


  (INFER-IDLE
  ;;
  ;; true if the operator is idle at <time>.
  ;;
  (params (<match> <time>))
  (preconds
     (~ (exists (<pre-time>)
       (scheduled <match> <pre-time>)              
       (is-equal <pre-time> <time>))))
  (effects (
     (add (idle <match> <time>))))
  )

  (INFER-READY-TO-ADD
  ;;
  ;; an object can be added if necessary preparations
  ;; have been done.
  ;;
  (params (<obj>))
  (preconds
    (~ (exists (<opr> <obj>)
       (cook-to <opr> <obj>))))
  (effects (
     (add (ready-to-add <obj>))))
  )

))
     







