


(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '(
        (SELECT-FIRST-GOAL
          (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
        ))

(setq *SCR-OP-SELECT-RULES* 
      '(
	(SELECT-DECORATIVE-2
;; 
;;  there are different decorating operators which are used depending on
;;  what is already in the dish: if the cooked food in the dish has 1 color,
;;  we will try to use a operator which will put into the dish a decorative
;;  with 2 colors.
;;
	 (lhs (and
	       (current-node <node>)
	       (current-goal <node> (decor-on-plate <food>))
	       (known <node> (on-plate S-PLATE <food>))))
	 (rhs (select operator PUT-IN-DECORATIVE-2)))

	(SELECT-DECORATIVE-3
;; 
;;  there are different decorating operators which are used depending on
;;  what is already in the dish: if the cooked food in the dish has 1 color,
;;  we will try to use a operator which will put into the dish a decorative
;;  with 2 colors.
;;
	 (lhs (and
	       (current-node <node>)
	       (current-goal <node> (decor-on-plate <food>))
	       (known <node> (on-plate D-PLATE <food>))))
	 (rhs (select operator PUT-IN-DECORATIVE-3)))


        (SELECT-WASH-SCALED-FOOD-IF-HAS-SCALES
;
;  when the food has scales, use wash-scaled-food operator
;
         (lhs (and
               (current-node <node>)
               (current-goal <node> (~(contains <food> unedible-stuff)))
               (candidate-op <node> WASH-FOOD)
               (candidate-op <node> WASH-SCALED-FOOD)
               (KNOWN <node> (contains <food> scales))))
         (rhs (select operator WASH-SCALED-FOOD)))

	(SELECT-STEAM-OPERATOR-IF-WANT-STEAMED-FOOD
;
;  do not let Prodigy use other operators such as deepfry or stirfry which,
;  although will solve the problem finally, will make it traverse many
;  more nodes.
;
	 (lhs (and
	       (current-node <node>)
	       (current-goal <node> (contains WOK <food>))
	       (is-top-level-goal <node> (serving-steamed-food <food>))))
	 (rhs (select operator STEAM-SEAFOOD)))


	))


(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* 
      '(
        (DO-NOT-SUBGOAL-COOK-WHEN-DECOR-2
;;
;;  when we are putting in decoratives for the dishes, we don't want to
;;  cook the dishes again, i.e. if something is already on-plate, that's
;;  fine, but don't ever try to subgoal on on-plate.
;;
            (lhs (and
                  (current-node <node>)
		  (current-op <node> PUT-IN-DECORATIVE-2)
		  (primary-candidate-goal <node> (on-plate S-PLATE <food>))))
          (rhs (reject goal (on-plate S-PLATE <food>))))

	(DO-NOT-SUBGOAL-COOK-WHEN-DECOR-3
; 
;  same as that for decor-2
;
	    (lhs (and
		  (current-node <node>)
                  (current-op <node> PUT-IN-DECORATIVE-3)
                  (primary-candidate-goal <node> (on-plate-D-PLATE <food>))))
	  (rhs (reject goal (on-plate D-PLATE <food>))))

	(DO-NOT-SUBGOAL-COOK-WHEN-DECOR-1
;
;  same as that for decor-2
;
	    (lhs (and
		  (current-node <node>)
		  (current-op <node> PUT-IN-DECORATIVE-1)
		  (primary-candidate-goal <node> 
		   (on-plate F-PLATE <food>))))
	  (rhs (reject goal (on-plate F-PLATE <food>))))
        ))

(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* 
      '(
        (CLEAN-BEFORE-DRY
;;
;;  it will be quicker is we clean the food or utentils before we dry them
;;  if both are the goals, otherwise after we clean them they will be wet 
;;  again and thus we will have to dry them again.
;;
         (lhs (and
               (current-node <node>)
               (candidate-goal <node> (clean <thing>))
               (candidate-goal <node> (is-dry <thing>))))
         (rhs (prefer goal (clean <thing>) (is-dry <thing>))))


        (CLEAN-BEFORE-LAST-SCHED
;;
;;  it will be quicker if we first clean the utentils before we check if
;;  it was last-scheduled, then we don't have to have it scheduled again when
;;  we are washing them.
;;
         (lhs (and
               (current-node <node>)
               (candidate-goal <node> (clean <equip-or-food>))
               (candidate-goal <node>
                (last-scheduled <equip-or-food> <prev-time>))))
         (rhs (prefer goal
               (clean <equip-or-food>)
               (last-scheduled <equip-or-food> <prev-time>))))



	(STIRFRY-BEFORE-CHECK-IF-IN-WOK
;;
;;  when we want the food to be contained in the WOK and also stirfried,
;;  it is better to stirfry them first, since after stirfrying the food
;;  will be inside the WOK itself.
;;
	 (lhs (and
	       (current-node <node>)
	       (candidate-goal <node> (contains WOK <food>))
	       (candidate-goal <node> (stirfried <food>))))
	 (rhs (prefer goal (stirfried <food>) (contains WOK <food>))))


	(CHECK-IS-CRISPY-BEFORE-CHECK-IF-COOKED
;
;   when we want the food to be crispy after it's cooked, it is better
;   to satisfy the is-crispy precondition first, since it will be cooked 
;   after the is-crispy precondition is satisfied. Otherwise, Prodigy will
;   try different operators to cook the food and then test those against
;   the is-crispy precondition, and that is very slow.
;
	 (lhs (and
	       (current-node <node>)
	       (is-top-level-goal <node> (is-crispy <food>))
	       (is-top-level-goal <node> (cooked <food>))))
	 (rhs (prefer goal (is-crispy <food>) (cooked <food>))))

	))

(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)















