;;;**********************************************************************
;;;**********************************************************************
;; CAR PAINTING DOMAIN
;;
;; Edit Marcinkech
;;
;; Spring 1991
;;;**********************************************************************
;;;**********************************************************************
;;
;; OPERATORS: 28 
;;
;; INFERENCE RULES: 0 
;;
;;;**********************************************************************
;;
;; NOTE:  The generator for <accum-cost>  (job-cost <car> <accum-cost>)
;;        is a non-static generator.  This has not led to a problem in
;;        any of the test problems as far as Prodigy subgoaling on this
;;        precondition.  There is only one <accum-cost> associated with
;;        a <car> in the state at any time so there should not be any
;;        confusion for Prodigy.
;;
;;;**********************************************************************

(setq *OPERATORS* '(

;;;**********************************************************************
;; Operators for cleaning.

; Removes smudges as well as dust.
 
(CHEMICAL-WASH
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 18 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(add (clean <car>))
	(add (dust-free <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Remove dust by using compressed air.

(BLOW-OFF-DUST
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 5 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(add (dust-free <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators for removing and installing parts.

; Remove door handles, bumpers, side mirrors, and possibly windshield.

(DISASSEMBLE
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (~(masked <car>))
        (assembled <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 150 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (disassembled <car>))
        (del (assembled <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Put removed parts back on car.

(ASSEMBLE
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (~(masked <car>))
        (disassembled <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 150 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (del (disassembled <car>))
        (add (assembled <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators to mask and unmask.

; Protect windows, chrome, and trim from overspray.

(MASK
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 60 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (masked <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Remove tape and other papers.

(UNMASK
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(masked <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 8 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (del (masked <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators for dry sanding.

; Used with all techniques.  After the car has been striped, sanding 
;  with 80-grit paper will leave a rough finish on the surface.  It is
;  now ready to be metal etched and primed.

(DRY-SAND-WITH-80-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(has-scratches <car> 36-GRIT)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 70 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> ROUGH))
	(del (has-scratches <car> <*2-r>))
	(add (has-scratches <car> 80-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Only used with the Sikkens technique.  After the car has been primed, 
;  sanding with 150-grit paper will leave a surface finish that is 
;  somewhat smooth.  Guidecoating must be done before this operator 
;  can be used.

(DRY-SAND-WITH-150-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)	
        (surface-finish <car> PRIMED)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 255 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SEMI-SMOOTH))
	(del (has-scratches <car> <*2-r>))
	(add (has-scratches <car> 150-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Used with all techniques except Sikkens.  After the car has been
;  primed, sanding with 220-grit paper will leave a surface finish 
;  that is somewhat smooth.  Guidecoating must be done before this
;  operator can be used.

(DRY-SAND-WITH-220-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)	
        (surface-finish <car> PRIMED)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 85 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SMOOTH))
	(del (has-scratches <car> <*2-r>))
	(add (has-scratches <car> 220-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Used with all techniques except Sikkens.  Sanding with 320-grit 
;  paper leaves the surface texture smooth enough so that the next
;  step of sanding with 400-grit is not too difficult and time-
;  consuming.  Guidecoating must be done before this operator can 
;  be used.

(DRY-SAND-WITH-320-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)	
	(has-scratches <car> 220-GRIT)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 85 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> VERY-SMOOTH))
	(del (has-scratches <car> <*2-r>))
	(add (has-scratches <car> 320-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Used with all techniques except Sikkens.  Sanding with 400-grit 
;  paper leaves the surface smooth enough so that it is ready for 
;  painting.  Guidecoating must be done before this operator can 
;  be used.

(DRY-SAND-WITH-400-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(has-scratches <car> 320-GRIT)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 100 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SEMI-SHEEN))
	(del (has-scratches <car> <*2-r>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators for wet sanding.  Wet sanding leaves the surface much 
;;  smoother than dry sanding with the same grit paper and it also takes
;;  more time.  Therefore, it not only costs more but also the finished
;;  product is of much higher quality.  So it is of no surprise that
;;  only the Sikkens technique uses these operators.

; Only used with the Sikkens technique.  Sanding with 400-grit 
;  paper leaves the surface texture smooth enough so that the next
;  step of sanding with 600-grit is not too difficult and time-
;  consuming.  Guidecoating must be done before this operator can 
;  be used.

(WET-SAND-WITH-400-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(has-scratches <car> 150-GRIT)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 130 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> VERY-SMOOTH))
	(del (has-scratches <car> <*2-r>))
	(add (has-scratches <car> 400-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


; Only used with the Sikkens technique.  Sanding with 400-grit 
;  paper leaves the surface texture smooth enough so that the next
;  step of sanding with 600-grit is not too difficult and time-
;  consuming.  Guidecoating must be done before this operator can 
;  be used.

(WET-SAND-WITH-600-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(has-scratches <car> 400-GRIT)
        (surface-finish <car> GUIDECOATED)
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 160 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SHEEN))
	(del (has-scratches <car> <*2-r>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(WET-SAND-WITH-1000-GRIT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> LACQUERED)
	(~ (has-scratches <car> <*3-r>))
	(~ (masked <car>))
	(disassembled <car>)
	(dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 125 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> ULTRA-FINE))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))

;;;**********************************************************************
;; Other operators applied before painting.

(STRIP
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (~ (masked <car>))
	(disassembled <car>)
	(clean <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 350 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> ROUGH))
	(add (has-scratches <car> 36-GRIT))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(METAL-ETCH
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(has-scratches <car> 80-GRIT)
	(disassembled <car>)
	(masked <car>)
	(clean <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 10 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
	(add (etched <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PRIME
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(disassembled <car>)
	(has-scratches <car> 80-GRIT)
        (etched <car>)
	(masked <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 150 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> PRIMED))
	(del (has-scratches <car> <*2-r>))
        (del (etched <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(APPLY-GUIDECOAT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
	(disassembled <car>)
        (dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 3 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
        (add (surface-finish <car> GUIDECOATED))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(SAND-EDGES
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (or (surface-finish <car> SHEEN)
            (surface-finish <car> SEMI-SHEEN))
        (~ (masked <car>))
	(disassembled <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 70 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (sanded-edges <car>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators for painting.

(PAINT-COLOR-SIKKENS
  (params (<car> <color> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (is-paint <color>)
        (surface-finish <car> SHEEN)
        (~ (has-scratches <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (clean <car>)    
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 95 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SIKKENS))
        (add (paint <car> <color>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-COLOR-ACRYLIC
  (params (<car> <color> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (is-paint <color>)
        (surface-finish <car> SEMI-SHEEN)
        (~ (has-scratches <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (clean <car>)    
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 60 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> ACRYLIC))
        (add (paint <car> <color>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-COLOR-SYNTHETIC
  (params (<car> <color> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (is-paint <color>)
        (surface-finish <car> SEMI-SHEEN)
        (~ (has-scratches <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (clean <car>)    
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 55 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SYNTHETIC))
        (add (paint <car> <color>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-COLOR-LACQUER
  (params (<car> <color> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (is-paint <color>)
        (surface-finish <car> SEMI-SHEEN)
        (~ (has-scratches <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (clean <car>)    
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 52 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> LACQUER))
        (add (paint <car> <color>))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


;;;**********************************************************************
;; Operators for applying clear.

(PAINT-CLEAR-SIKKENS
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> SIKKENS)
        (~ (has-scratches  <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 120 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (surface-finish <car> SHINY))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-CLEAR-ACRYLIC
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> ACRYLIC)
        (~ (has-scratches  <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 100 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (surface-finish <car> SHINY))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-CLEAR-SYNTHETIC
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> SYNTHETIC)
        (~ (has-scratches  <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 80 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (surface-finish <car> SHINY))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


(PAINT-CLEAR-LACQUER
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> LACQUER)
        (~ (has-scratches  <car> <*3-r>))
        (sanded-edges <car>)
	(disassembled <car>)
        (masked <car>)
        (dust-free <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 75 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (dust-free <car>) (del (dust-free <car>)))
        (add (surface-finish <car> LACQUERED))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))



;;;**********************************************************************
;; Other operators applied after painting.

(RUB-OUT
  (params (<car> <new-cost>))
 (preconds
   (and
        (is-car <car>)
        (surface-finish <car> ULTRA-FINE)
	(~ (has-scratches <car> <*3-r>))
	(~ (masked <car>))
	(disassembled <car>)
        (estimated-cost <car> <allowed-cost>)
        (job-cost <car> <accum-cost>)
        (get-new-cost <accum-cost> 135 <new-cost>)
        (less-than <new-cost> <allowed-cost>)))
   (effects (
	(if (clean <car>) (del (clean <car>)))
	(if (dust-free <car>) (del (dust-free <car>)))
        (if (surface-finish <car> <*1-r>)
            (del (surface-finish <car> <*1-r>)))
        (add (surface-finish <car> SHINY))
	(del (job-cost <car> <accum-cost>))
	(add (job-cost <car> <new-cost>)))))


))

;;;**********************************************************************
;;;**********************************************************************
;;;**********************************************************************

(setq *INFERENCE-RULES* '(


))