;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Credit for GREATER-THAN function goes to the class notes.
;;

(setq *NUM-STATES* 5)

(defun GREATER-THAN (val1 val2)
  (cond ((is-variable val1) 'no-match-attempted)
	((is-variable val2) 'no-match-attempted)
	((> val1 val2))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; The purpose of not-equal is, simply, to see if to values, in this case s-expressions, aren't
;; equal.
;;

(defun not-equal (val1 val2)
  (cond ((is-variable val1) 'no-match-attempted)
	((is-variable val2) 'no-match-attempted)
	((equal val1 val2) nil)
	(t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Credit for the following function goes to Schedworld.
;;

(defun bindings-list (var val-list)
  (cond ((null val-list) nil)
	((null (first val-list)) (bindings-list var (rest val-list)))
	(t (append (list (list (list var (first val-list))))
		   (bindings-list var (rest val-list))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; These incrimentation/decrimentation functions came from Tad Orman's mail message.
;;

(setq *MAX-VOTES* 459)         ;; These constants represents the maximum values in the state given
(setq *MIN-VOTES* 0)           ;; the current test problems.  They might need to be changed for
(setq *MAX-FUNDS* 30000)       ;; more complex problems.
(setq *MIN-FUNDS* 0)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will take an incrimentation step size (votes) and the old number (old) and
;; add votes to old binding the new value to new.  this new value will be used as the vote count
;; in the specific state.
;;

(defun generate-votes (new old votes)
  (cond ((and (is-variable old) (is-variable new) (is-variable votes))
	 'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append (bindings-list old (generate-old-new-values votes *MAX-VOTES* #'>= #'+))
		 (bindings-list new (rest (generate-old-new-values votes *MAX-VOTES* #'>= #'+)))))

	((and (is-variable new) (is-variable votes))
	 (append (bindings-list votes '(1 2 3 4 5 6 7 8))
		 (bindings-list new (generate-new-values old '(1 2 3 4 5 6 7 8) #'+))))

	((and (is-variable old) (is-variable votes))
	 (append (bindings-list votes '(1 2 3 4 5 6 7 8))
		 (bindings-list old (generate-old-values new '(1 2 3 4 5 6 7 8) #'-))))

	((is-variable old)
	 (bindings-list old (list (- new votes))))

	((is-variable new)
	 (bindings-list new (list (+ old votes))))

	((is-variable votes)
	 (bindings-list votes (list (- new old))))

	(t (= new (+ old votes)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will return an incrimentation list for old and new, stopping the list as soon
;; as the value of max-value is reached or exceeded.
;;

(defun generate-old-new-values (value comp-value comp-func arith-func &optional (n 0))
  (cond
    ((funcall comp-func n comp-value) nil)
    ((cons (funcall arith-func value n) (generate-old-new-values value 
								 (funcall arith-func n value)
								 comp-func
								 arith-func)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will return an incrimentation list for new, stopping when the list of possible
;; values, kept by value, has run out.
;;

(defun generate-new-values (old value func)
  (cond
    ((null value) nil)
    ((cons (funcall func (first value) old) (generate-new-values old (rest value) func)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will return an incrimentation list for new, stopping when the list of possible
;; values, kept by value, has run out.
;;

(defun generate-old-values (new value func)
  (cond
    ((null value) nil)
    ((or (plusp (funcall func new (first value))) (zerop (funcall func new (first value))))
     (cons (funcall func new (first value)) (generate-old-value new (rest value) func)))
    (t nil)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will bind the variable new to the value obtained by decrimenting old by votes.
;; it compensates for all possible cases of the lack of variable bindings in the variables.
;;

(defun decriment-votes (new old votes)
  (cond ((and (is-variable old) (is-variable new) (is-variable votes))
	 'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append (bindings-list old (generate-old-new-values votes *MIN-VOTES* #'<= #'-))
		 (bindings-list new (rest (generate-old-new-values votes *MIN-VOTES* #'<= #'-)))))

	((and (is-variable new) (is-variable votes))
	 (append (bindings-list votes '(1 2 3 4 5 6 7 8))
		 (bindings-list new (generate-new-values old '(1 2 3 4 5 6 7 8) #'-))))

	((and (is-variable old) (is-variable votes))
	 (append (bindings-list votes '(1 2 3 4 5 6 7 8))
		 (bindings-list old (generate-old-values new '(1 2 3 4 5 6 7 8) #'+))))

	((is-variable old)
	 (bindings-list old (list (+ new votes))))

	((is-variable new)
	 (bindings-list new (list (- old votes))))

	((is-variable votes)
	 (bindings-list votes (list (+ new old))))

	(t (= new (+ old votes)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will incriment old by the appropriate step size, funds, and will bind the value
;; to new.  This will be used to incriment the ammount of money by an appropriate value.
;;

(defun incriment-funds (new old funds)
  (cond ((and (is-variable old) (is-variable new) (is-variable funds))
	 'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append (bindings-list old (generate-old-new-values funds *MAX-FUNDS* #'>= #'+))
		 (bindings-list new (rest (generate-old-new-values funds *MAX-FUNDS* #'>= #'+)))))

	((and (is-variable new) (is-variable funds))
	 (append (bindings-list funds '(600 800 2000))
		 (bindings-list new (generate-new-values old '(600 800 2000) #'+))))

	((and (is-variable old) (is-variable funds))
	 (append (bindings-list funds '(600 800 2000))
		 (bindings-list old (generate-old-values new '(600 800 2000) #'-))))

	((is-variable old)
	 (bindings-list old (list (- new funds))))

	((is-variable new)
	 (bindings-list new (list (+ old funds))))

	((is-variable funds)
	 (bindings-list funds (list (- new old))))

	(t (= new (+ old funds)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will decriment old by the ammount of funds spent on a certain action.  It will
;; take the new value and bind it to new.
;;

(defun decriment-funds (new old funds)
  (cond ((and (is-variable old) (is-variable new) (is-variable funds))
	 'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append (bindings-list old (generate-old-new-values funds *MIN-FUNDS* #'<= #'-))
		 (bindings-list new (rest (generate-old-new-values funds *MIN-FUNDS* #'<= #'-)))))

	((and (is-variable new) (is-variable funds))
	 (append (bindings-list funds '(1500 1100 900 800 400 300 200))
		 (bindings-list new 
				(generate-new-values old '(1500 1100 900 800 400 300 200) #'-))))

	((and (is-variable old) (is-variable funds))
	 (append (bindings-list funds '(1500 1100 900 800 400 300 200))
		 (bindings-list old
				(generate-old-values new '(1500 1100 900 800 400 300 200) #'+))))

	((is-variable old)
	 (bindings-list old (list (+ new funds))))

	((is-variable new)
	 (bindings-list new (list (- old funds))))

	((is-variable funds)
	 (bindings-list funds (list (+ new old))))

	(t (= new (+ old funds)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This function will incriment the total number of votes the candidate has by the appropriate 
;; step size, thus allowing the candidate to approach the necessesary number of votes to win the
;; "election" or whatever.
;;

(defun incriment-total-votes (new old step)
  (cond ((and (is-variable old) (is-variable new) (is-variable step))
	 'no-match-attempted)

	((and (is-variable old) (is-variable new))
	 (append (bindings-list old (generate-old-new-values step *MAX-VOTES* #'>= #'+))
		 (bindings-list new (rest (generate-old-new-values step *MAX-VOTES* #'>= #'+)))))

	((and (is-variable new) (is-variable step))
	 (append (bindings-list step '(1 2 3 4 27 36 45 54))
		 (bindings-list new (generate-new-values old '(1 2 3 4 27 36 45 54) #'+))))

	((and (is-variable old) (is-variable step))
	 (append (bindings-list step '(1 2 3 4 27 36 45 54))
		 (bindings-list old (generate-old-values new '(1 2 3 4 27 36 45 54) #'-))))

	((is-variable old)
	 (bindings-list old (list (- new step))))
	((is-variable new)
	 (bindings-list new (list (+ old step))))

	((is-variable step)
	 (bindings-list step (list (- new old))))

	(t (= new (+ old step)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  The credit for this function doesn't go to Tad Orman, but is my own.  It a fixed incrimentation
;; value since the time taken for each operator is assumed to be one unit of time, allowing the 
;; law of averages to take over.
;;

(defun decriment-time (new old)
  (cond ((and (is-variable new) (is-variable old)) 'no-match-attempted)
	((is-variable old) 'no-match-attempted)
	((is-variable new) (bindings-list new (list (- old 1))))
	(t (< new old))))





