;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  Campaign world
;;
;;       There are three different non-static generators used throughout this domain.  They are:
;;  TIME, FUNDS, and, TOTAL-VOTES.  The reason that these are used is that the values they
;;  represent are constantly changing.  Time is constantly decreasing, funds changed depending
;;  on weather the operator earns you money, or costs you money, and total-votes increases by an
;;  ammount dependant upon the number of votes won in each state by the operator.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq *OPERATORS* '(

(FLY
 (PARAMS (<start-loc> <end-loc> <start-orientation> <end-orientation> <money> <old-time>
         <current-votes>))
 (PRECONDS
  (AND
   (POS-LOC <start-loc> <start-orientation>)
   (AT-LOC <start-loc>)
   (POS-LOC <end-loc> <end-orientation>)
   (FUNDS <money>)
   (GREATER-THAN <money> 899)
   (DECRIMENT-BY-900 <new-money> <money>)   ;; decriment funds by 900 and assign to new-money.
   (TIME-LEFT <old-time>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <old-time> 0)
   (DECRIMENT-BY-1 <new-time> <old-time>))) ;; decriment time by 1 and assign to new-time.

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <old-time>))
  (DEL (AT-LOC <start-loc>))
  (ADD (TIME-LEFT <new-time>))
  (ADD (FUNDS <new-money>))
  (ADD (AT-LOC <end-loc>))

  (IF (AND                                     ;; change the vote counts in various locations
       (POS-LOC <loc1> <orient1>)              ;; for and against the candidate.
       (~ (AT-LOC <loc1>))
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(DRIVE
 (PARAMS (<start-loc> <end-loc>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (GREATER-THAN <money> 299)
   (TIME-LEFT <old-time>)
   (GREATER-THAN <old-time> 0)
   (POS-LOC <start-loc> <start-orientation>)
   (AT-LOC <start-loc>)
   (POS-LOC <end-loc> <end-orientation>)
   (TOTAL-VOTES <current-votes>)
   (~ (ISOLATED-LOC <start-loc>))
   (~ (ISOLATED-LOC <end-loc>))
   (DECRIMENT-BY-2 <new-time> <old-time>)             ;; decriment old-time by time taken.
   (DECRIMENT-BY-300 <new-money> <money>)))           ;; decriment money by the cost to drive.

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (AT-LOC <start-loc>))
  (DEL (TIME-LEFT <old-time>))
  (ADD (AT-LOC <end-loc>))
  (ADD (TIME-LEFT <new-time>))
  (ADD (FUNDS <new-money>))

  (IF (AND                                       ;; adjust the vote counts in the various states
       (POS-LOC <loc1> <orient1>)                ;; and incriment the total votes.
       (~ (AT-LOC <loc1>))
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(STAY
 (PARAMS (<loc> <time> <money>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (POS-LOC <end-loc> <end-orientation>)
   (AT-LOC <end-loc>)
   (TIME-LEFT <old-time>)
   (GREATER-THAN <old-time> 0)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <money> 199)
   (DECRIMENT-BY-1 <new-time> <old-time>)       ;; decriment old-time by time stayed.
   (DECRIMENT-BY-200 <new-money> <money>)))     ;; decriment money by the cost of staying without
                                                ;;  major expenses.
 (EFFECTS (

  (DEL (TIME-LEFT <old-time>))
  (DEL (FUNDS <money>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                        ;; adjust the vote count, assumes minor
       (POS-LOC <loc1> <orient1>)                 ;; campaigning by no special effort.  general 
       (~ (AT-LOC <loc1>))                        ;; shoring of support in area.
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(SPONSOR-BANQUET
 (PARAMS (<money> <end-loc> <end-orientation>))
 (PRECONDS
  (AND
   (POS-LOC <end-loc> <end-orientation>)
   (AT-LOC <end-loc>)
   (GOOD-SUPPORT <end-loc>)
   (FUNDS <money>)
   (GREATER-THAN <money> 499)
   (TIME-LEFT <time>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 2)
   (DECRIMENT-BY-1 <new-time> <time>)          ;; decriment time by time taken to prepare banquet.
   (INCRIMENT-BY-600 <new-money> <money>)))    ;; incriment money by ammount earned after expences.

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                     ;; Adjust the vote counts, assuming minor public
       (POS-LOC <loc1> <orient1>)              ;; campaigning but, again, no major effort.
       (~ (AT-LOC <loc1>))
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(SPEAK-WITH-BUISNESS
 (PARAMS (<end-loc> <end-orientation> <name> <time> <money>))
 (PRECONDS
  (AND
   (POS-LOC <end-loc> <end-orientation>)
   (AT-LOC <end-loc>)
   (TIME-LEFT <time>)
   (FUNDS <money>)
   (GREATER-THAN <time> 0)
   (TOTAL-VOTES <current-votes>)
   (BUISNESS <name> <end-loc> <buis-orientation>)
   (DECRIMENT-BY-1 <new-time> <time>)))            ;; adjust time by time taken to lobby buisness.

 (EFFECTS (

  (DEL (TIME-LEFT <time>))
  (DEL (FUNDS <money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND
       (CAND-ORIENT <buis-orientation>)
       (INCRIMENT-BY-2000 <new-money> <money>))  ;; adjust money by ammount given in support

      (ADD (FUNDS <new-money>)))

  (IF (AND
       (~ (CAND-ORIENT <buis-orientation>))
       (INCRIMENT-BY-800 <new-money> <money>))   ;; adjust money by ammount given as show of
                                                 ;; support.
      (ADD (FUNDS <money>)))

  (IF (AND                                     ;; Adjust the vote counts, assuming minor public
       (POS-LOC <loc1> <orient1>)              ;; campaigning but, again, no major effort.
       (~ (AT-LOC <loc1>))
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(MAKE-CHEAP-POSITIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 849)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)          ;; adjust time to account for filming, and ideas.
   (DECRIMENT-BY-800 <new-money> <money>)))    ;; adjust funds to account for cost of "cheap"
                                               ;; commercial.
 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                   ;; adjust votes to account for national play of add.
       (POS-LOC <loc1> <orientation1>)
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-3 <new-neut1> <neut1>)
       (INCRIMENT-BY-3 <new-pos1> <pos1>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <new-pos1> <neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-pos2> <pos2>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>)
       (~ (CAND-ORIENT <orientation2>)))

      (ADD (STATE <loc2> <new-pos2> <neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(MAKE-MODERATE-POSITIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 1099)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)       ;; adjust time and funds to account for expences of add
   (DECRIMENT-BY-1100 <new-money> <money>)))

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                  ;; adjust votes to account for quality and national
       (POS-LOC <loc1> <orientation1>)      ;; play of add.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 4)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-4 <new-neut1> <neut1>)
       (INCRIMENT-BY-4 <new-pos1> <pos1>)
       (INCRIMENT-BY-4 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <new-pos1> <neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (~ (CAND-ORIENT <orientation2>))
       (DECRIMENT-BY-3 <new-neut2> <neut2>)
       (INCRIMENT-BY-3 <new-pos2> <pos2>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <loc2> <new-pos2> <neg2> <neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(MAKE-EXPENSIVE-POSITIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 1499)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 1)
   (DECRIMENT-BY-2 <new-time> <time>)      ;; adjust time and money to account for expences of add
   (DECRIMENT-BY-1500 <new-money> <money>)))

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                 ;; adjust votes to account for nation play, and quality,
       (POS-LOC <loc1> <orientation1>)     ;; of add.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 5)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-5 <new-neut1> <neut1>)
       (INCRIMENT-BY-5 <new-pos1> <pos1>)
       (INCRIMENT-BY-5 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <pos1> <neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 4)
       (~ (CAND-ORIENT <orientation2>))
       (DECRIMENT-BY-4 <new-neut2> <neut2>)
       (INCRIMENT-BY-4 <new-pos2> <pos2>)
       (INCRIMENT-BY-4 <new-votes> <current-votes>))

      (ADD (STATE <loc2> <new-pos2> <neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(MAKE-CHEAP-NEGATIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 849)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)      ;; adjust time and money for cost of add.
   (DECRIMENT-BY-800 <new-money> <money>)))

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                ;; adjust votes taking into account quality of add, and
       (POS-LOC <loc1> <orientation1>)    ;; negative orientation of add.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-2 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-pos1> <pos1>)
       (INCRIMENT-BY-1 <new-votes> <current-votes>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 4)
       (~ (CAND-ORIENT <orientation2>))
       (DECRIMENT-BY-3 <new-neut2> <neut2>)
       (INCRIMENT-BY-1 <new-pos2> <pos2>)
       (INCRIMENT-BY-1 <new-votes> <current-votes>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(MAKE-MODERATE-NEGATIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 1099)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)        ;; adjust time and money for cost of add.
   (DECRIMENT-BY-1100 <new-money> <money>)))

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                                ;; adjust votes, taking into account the quality and
       (POS-LOC <loc1> <orientation1>)    ;; negative orientation of the add.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-3 <new-neut1> <neut1>)
       (INCRIMENT-BY-2 <new-pos1> <pos1>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (~ (CAND-ORIENT <orientation2>))
       (DECRIMENT-BY-3 <new-neut2> <neut2>)
       (INCRIMENT-BY-1 <new-pos2> <pos2>)
       (INCRIMENT-BY-1 <new-votes> <current-votes>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(MAKE-EXPENSIVE-NEGATIVE-COMMERCIAL
 (PARAMS (<money> <time>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <money> 1499)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 1)
   (DECRIMENT-BY-2 <new-time> <time>)       ;; adjust time and money to reflect cost of add.
   (DECRIMENT-BY-1500 <new-money> <money>)))

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                               ;; adjust votes taking into account the quality and 
       (POS-LOC <loc1> <orientation1>)   ;; negative nature of the add.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 4)
       (CAND-ORIENT <orientation>)
       (DECRIMENT-BY-4 <new-neut1> <neut1>)
       (INCRIMENT-BY-3 <new-pos1> <pos1>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orientation2>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (~ (CAND-ORIENT <orientation2>))
       (DECRIMENT-BY-3 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-pos2> <pos2>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>)
       (INCRIMENT-BY-1 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(SPEAK-TO-PUBLIC
 (PARAMS (<money> <time> <end-loc> <end-orientation>))
 (PRECONDS
  (AND
   (FUNDS <money>)
   (GREATER-THAN <money> 399)
   (POS-LOC <end-loc> <end-orientation>)
   (AT-LOC <end-loc>)
   (TIME-LEFT <time>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)       ;; adjust time and money for the cost of organising the
   (DECRIMENT-BY-400 <new-money> <money>))) ;; speach.

 (EFFECTS (

  (DEL (FUNDS <money>))
  (DEL (TIME-LEFT <time>))
  (ADD (FUNDS <new-money>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                        ;; adjust the votes according to orientation of the speaker vs.
       (POS-LOC <loc1> <orient1>) ;; general orientation of the audience.
       (~ (AT-LOC <loc1>))
       (CAND-ORIENT <orient1>)
       (~ (HOME-STATE <loc1>))
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 3)
       (DECRIMENT-BY-1 <new-neut1> <neut1>)
       (INCRIMENT-BY-1 <new-neg1> <neg1>))

      (ADD (STATE <loc1> <pos1> <new-neg1> <new-neut1>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (AT-LOC <loc2>))
       (~ (CAND-ORIENT <orient2>))
       (~ (HOME-STATE <loc2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 3)
       (DECRIMENT-BY-2 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-neg2> <neg2>))

      (ADD (STATE <loc2> <pos2> <new-neg2> <new-neut2>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>)))

  (IF (AND 
       (CAND-ORIENT <end-orientation>)
       (STATE <end-loc> <pos3> <neg3> <neut3>)
       (GREATER-THAN <neut3> 3)
       (DECRIMENT-BY-3 <new-neut3> <neut3>)
       (INCRIMENT-BY-3 <new-pos3> <pos3>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos3> <neg3> <new-neut3>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos3> <neg3> <neut3>)))

  (IF (AND
       (~ (CAND-ORIENT <end-orientation>))
       (STATE <end-loc> <pos4> <neg4> <neut4>)
       (GREATER-THAN <neut4> 3)
       (DECRIMENT-BY-2 <new-neut4> <neut4>)
       (INCRIMENT-BY-2 <new-pos4> <pos4>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <end-loc> <new-pos4> <neg4> <new-neut4>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <end-loc> <pos4> <neg4> <neut4>))))))


(SPEAK-WITH-SPECIAL-INTEREST
 (PARAMS (<time> <money> <end-loc> <si-orientation>))
 (PRECONDS
  (AND
   (POS-SI-GROUP <si-group> <si-orientation> <end-loc>)
   (AT-LOC <end-loc>)
   (TOTAL-VOTES <current-votes>)
   (FUNDS <money>)
   (TIME-LEFT <time>)
   (GREATER-THAN <time> 1)
   (DECRIMENT-BY-1 <new-time> <time>)))   ;; adjust for time taken to lobby the special interest
                                          ;; group.
 (EFFECTS (

  (DEL (TIME-LEFT <time>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND
       (CAND-ORIENT <si-orientation>)
       (INCRIMENT-BY-2000 <new-money> <money>))  ;; if group likes position, add to funds.

      (ADD (FUNDS <new-money>))
      (DEL (FUNDS <money>)))

  (DEL (POS-SI-GROUP <si-group> <si-orientation> <end-loc>))
  (ADD (VISITED-SI-GROUP <si-group>))

  (IF (AND                                     ;; adjust votes according to if liked by the group.
       (POS-LOC <loc1> <si-orientation>)
       (CAND-ORIENT <si-orientation>)
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <netu1> 7)
       (DECRIMENT-BY-8 <new-neut1> <neut1>)
       (INCRIMENT-BY-6 <new-pos1> <pos1>)
       (INCRIMENT-BY-2 <new-neg1> <neg1>)
       (INCRIMENT-BY-6 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <pos-orientation>)
       (~ (CAND-ORIENT <pos-orientation>))
       (CAND-ORIENT <si-orientation>)
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 7)
       (DECRIMENT-BY-8 <new-neut2> <neut2>)
       (INCRIMENT-BY-3 <new-pos2> <pos2>)
       (INCRIMENT-BY-5 <new-neg2> <neg2>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(TAKE-CONTROVERCIAL-STANCE
 (PARAMS (<time> <orientation>))
 (PRECONDS
  (AND 
   (CAND-ORIENT <orientation>)
   (TIME-LEFT <time>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 0)
   (DECRIMENT-BY-1 <new-time> <time>)))  ;; adjust time for time taken to get stance to the public
                                         ;; ear.
 (EFFECTS (

  (DEL (TIME-LEFT <time>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                            ;; adjust the vote counts for the impact the stance will have
       (POS-LOC <loc1> <orientation>) ;; on the voters.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 10)
       (DECRIMENT-BY-10 <new-neut1> <neut1>)
       (INCRIMENT-BY-5 <new-pos1> <pos1>)
       (INCRIMENT-BY-5 <new-neg1> <neg1>)
       (INCRIMENT-BY-5 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <loc-orientation>)
       (~ (CAND-ORIENT <loc-orientation>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 10)
       (DECRIMENT-BY-10 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-pos2> <pos2>)
       (INCRIMENT-BY-8 <new-neg2> <neg2>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(DEBATE
 (PARAMS (<location> <time>))
 (PRECONDS
  (AND
   (POS-LOC <location> <orientation>)
   (AT-LOC <location>)
   (TIME-LEFT <time>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <time> 1)
   (DECRIMENT-BY-1 <new-time> <time>))) ;; adjust time for time taken to prepare and participate in
                                        ;; debate.
 (EFFECTS (

  (DEL (TIME-LEFT <time>))
  (ADD (TIME-LEFT <new-time>))

  (IF (AND                             ;; adjust votes taking into account how each state would be
       (POS-LOC <loc1> <orient1>)      ;; likely to view the outcome, dependant on candidiat vs.
       (CAND-ORIENT <orient1>)         ;; viewer political orientation.
       (STATE <loc1> <pos1> <neg1> <neut1>)
       (GREATER-THAN <neut1> 4)
       (DECRIMENT-BY-5 <new-neut1> <neut1>)
       (INCRIMENT-BY-3 <new-pos1> <pos1>)
       (INCRIMENT-BY-2 <new-neg1> <neg1>)
       (INCRIMENT-BY-3 <new-votes> <current-votes>))

      (ADD (STATE <loc1> <new-pos1> <new-neg1> <new-neut1>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc1> <pos1> <neg1> <neut1>)))

  (IF (AND
       (POS-LOC <loc2> <orient2>)
       (~ (CAND-ORIENT <orient2>))
       (STATE <loc2> <pos2> <neg2> <neut2>)
       (GREATER-THAN <neut2> 4)
       (DECRIMENT-BY-5 <new-neut2> <neut2>)
       (INCRIMENT-BY-2 <new-pos2> <pos2>)
       (INCRIMENT-BY-3 <new-neg2> <neg2>)
       (INCRIMENT-BY-2 <new-votes> <current-votes>))

      (ADD (STATE <loc2> <new-pos2> <new-neg2> <new-neut2>))
      (ADD (TOTAL-VOTES <new-votes>))
      (DEL (TOTAL-VOTES <current-votes>))
      (DEL (STATE <loc2> <pos2> <neg2> <neut2>))))))


(ADD-HAS-WON
 (PRECONDS
  (AND
   (MIN-TO-WIN <votes-needed>)
   (TOTAL-VOTES <current-votes>)
   (GREATER-THAN <current-votes> <votes-needed>)))
 (EFFECTS (
  (ADD (HAS-WON)))))

))
 