
; Operators

(setq *OPERATORS* '(



;;;*************SANITIZE**************


(SANITIZE-EQUIP
 (params (<ob> <from-loc>))
 (preconds (and (equip <ob>)
	        (place <from-loc>)
	        (at <ob> <from-loc>)
	        (clean <ob>)	       
	        (rinse <ob>)
                (chlorine <ob>)))
 (effects ((add (purify <ob>))
	   (add (at <ob> in-dry-rack))
	   (del (chlorine <ob>))
	   (del (at <ob> <from-loc>)))))





(CLEAN-EQUIP
 (params (<ob> <from-loc>))
 (preconds
          (and (equip <ob>)
	       (place <from-loc>)
	       (rinse <ob>)
	       (at <ob> <from-loc>)
	       (soap <ob>)))
 (effects ((add (clean <ob>))
	   (del (at <ob> <from-loc>))
	   (add (at <ob> dry-rack))
	   (del (soap <ob>)))))





(WASH-EQUIP
 (params (<ob-s> <time-s> <prev-time-s>))
 (preconds (and (equip <ob-s>)
	        (at <ob-s> in-sink)
		(dirty <ob-s>)
	        (rinse <ob-s>)
	        (last-scheduled <ob-s> <prev-time-s>)
	        (later <time-s> <prev-time-s>)
	        (idle sink <time-s>)))
 (effects ((add (soap <ob-s>))
	   (del (last-scheduled <ob-s> <prev-time-s>))
	   (add (last-scheduled <ob-s> <time-s>))
	   (add (scheduled <ob-s> sink <time-s>))
	   (del (rinse <ob-s>)))))

	    

(CHLORINE-EQUIP
 (params (<ob-c> <time-c> <prev-time-c>))
 (preconds (and (equip <ob-c>)
		(at <ob-c> in-sink)
	        (last-scheduled <ob-c> <prev-time-c>)
		(rinse <ob-c>)
		(clean <ob-c>)
	        (later <time-c> <prev-time-c>)
	        (idle sink <time-c>)))
 (effects ((add (chlorine <ob-c>))
	   (del (last-scheduled <ob-c> <prev-time-c>))
	   (add (last-scheduled <ob-c> <time-c>))
	   (add (scheduled <ob-c> <sink> <time-c>))
;	   (del (clean <ob-c>))       ;;;add search control rules to prevent
	   (del (rinse <ob-c>)))))    ;;;the duplication that occurs (or just
                                    ;;;comment out the (del (clean <ob>))





(RINSE-EQUIP
 (params (<ob-r> <time-r> <prev-time-r>))
 (preconds (and (equip <ob-r>)
	        (at <ob-r> in-sink)
	        (water-running)
	        (last-scheduled <ob-r> <prev-time-r>)
	        (later <time-r> <prev-time-r>)
	        (idle sink <time-r>)))
 (effects ((add (rinse <ob-r>))
	   (del (last-scheduled <ob-r> <prev-time-r>))
	   (add (last-scheduled <ob-r> <time-r>))
	   (add (scheduled <ob-r> sink <time-r>))
	   (del (water-running))
	   (IF  (soap <ob-r>)
	        (add (at <ob-r> in-dry-rack))
	        (del (at <ob-r> in-sink)))
	        (add (at <ob-r> in-dry-rack))
	        (del (at <ob-r> in-sink)))))


(TURN-WATER-ON
 (preconds (water-off))
 (effects ((add (water-running)))))




(MOVE-OBJ
 (params (<ob> <loc-from> <loc-to>))
 (preconds
          (and (equip <ob>)
	       (place <loc-from>)
	       (place <loc-to>)
	       (at <ob> <loc-from>)))
 (effects ((add (at <ob> <loc-to>))
	   (del (at <ob> <loc-from>)))))





;;;*************WORT PROCESS************************


(BREW-BEER
 (params (<beer>))
 (preconds
          (and (beer-type <beer>)
	       (wort-process <beer>)
	       (vat-ferment-first-stage <beer> vat)))
 (effects ((add (brew-beer <beer>)))))



(VAT-FERMENTATION
 (params (<wort> <vat-v>))
 (preconds
          (and (fluid <wort>)
	       (equip <vat-v>)
	       (has <wort> wort-pot)
	       (at wort-pot in-vat)))
(effects ((add (vat-ferment-first-stage <beer> <vat-v>)))))

	       


;(BOIL-WATER
; (params (<ob-b> <water> <element-b> <time-b> <prev-time-b>))
; (preconds
;          (and (equip <ob-b>)
;	       (fluid <water>)
;	       (fixed-feature <element-b>)
;	       (hot <element-b>)
;	       (has <ob-b> <water>)
;	       (last-scheduled <ob-b> <prev-time-b>)
;	       (at <ob-b> on-stove)
;	       (later <time-b> <prev-time-b>)
;               (idle <element-b> <time-b>)))
; (effects ((add (water-boiling <ob-b>))
;	   (del (last-scheduled <ob-b> <prev-time-b>))
;	   (add (last-scheduled <ob-b> <time-b>))
;	   (add (scheduled <ob-b> <element-b> <time-b>)))))





(WORT-PROCESS
 (params (<beer> <malt> <hop-type>))
 (preconds (and
	        (beer-type <beer>)
	        (malt-type <malt>)
	        (purify wort-pot)	       
	        (water-boiling wort-pot)
	        (add-malt <malt> wort-pot)
	        (add-hops <hops> wort-pot)))
 (effects ((add (wort-process <beer>))
	   (del (add-malt <malt> wort-pot))
	   (del (add-hops <hops> wort-pot))
	   (del (purify wort-pot))
	   (add (has wort wort-pot))
	   (del (water-boiling wort-pot)))))




;(SANIT-EQUIP
; (params (<ob>))
; (preconds
;          (FORALL (<ob>) (equip <ob>) (purify <ob>)))
; (effects ((add (purify-equip <ob>))))) 
;
;;;(effects ((add (purify-equip)))))
;;;
;;; (effects ((add (purify-equip wort-pot))
;;;	   (add (purify-equip spoon))
;;;	   (add (purify-equip carboy)))))
;;;



(ADDING-HOPS
 (params (<ob1> <ob2> <hops>))
 (preconds 
          (and (equip <ob1>)
	       (equip <ob2>)
	       (hop-type <hops>)
	       (stir <ob1> <ob2>)))
 (effects ((add (add-hops <hops> <ob1>))
	   (del (stir <ob1> <ob2>)))))


  
(ADDING-MALT
 (params (<ob1> <ob2> <malt>))
 (preconds 
          (and (equip <ob1>)
	       (equip <ob2>)
	       (malt-type <malt>)
	       (stir <ob1> <ob2>)))
 (effects ((add (add-malt <malt> <ob1>))
	   (del (stir <ob1> <ob2>)))))




(STIRRING
 (preconds (equip <ob>))
 (effects ((add (stir <ob> spoon)))))

	       



;(CHOOSE-MALT
; (params (<beer-type>))
; (preconds
;          (malt-type <beer-type>))
; (effects (

 



(BOIL-WATER
 (params (<ob-b> <water> <element-b> <time-b> <prev-time-b>))
 (preconds
          (and (equip <ob-b>)
	       (fluid <water>)
	       (fixed-feature <element-b>)
	       (hot <element-b>)
	       (has <ob-b> <water>)
	       (last-scheduled <ob-b> <prev-time-b>)
	       (at <ob-b> on-stove)
	       (later <time-b> <prev-time-b>)
	       (idle <element-b> <time-b>)))
 (effects ((add (water-boiling <ob-b>))
	   (del (last-scheduled <ob-b> <prev-time-b>))
	   (add (last-scheduled <ob-b> <time-b>))
	   (add (scheduled <ob-b> <element-b> <time-b>)))))


(STOVE-ON
 (params (<element-s>))
 (preconds
          (and (fixed-feature <element-s>)
	       (cold <element-s>)))
 (effects ((add (hot <element-s>)))))


(ADD-WATER
 (params (<ob-a> <water> <time-a> <prev-time-a>))
 (preconds
          (and (equip <ob-a>)
	       (empty <ob-a>)
	       (water-running)
	       (last-scheduled <ob-a> <prev-time-a>)
	       (later <time-a> <prev-time-a>)
	       (idle sink <time-a>)))
 (effects ((add (has <ob-a> <water>))
	   (del (last-scheduled <ob-a> <prev-time-a>))
	   (add (last-scheduled <ob-a> <time-a>))
	   (add (scheduled <ob-a> sink <time-a>))
	   (del (water-running)))))
;	   (add (at <ob-a> in-sink)))))
	       





;;;*************INFERENCE RULES**********************

(INFER-WATER-RUNNING
 (preconds
  (~ (water-running)))
 (effects ((add (water-off)))))
  


(INFER-AT-INVENTORY
 (params (<ob>))
 (preconds (and
  (~ (exists (<ob>) (at <ob> in-sink)))
  (~ (exists (<ob>) (at <ob> on-stove)))
  (~ (exists (<ob>) (at <ob> in-dry-rack)))))
 (effects ((add (at <ob> inventory)))))



(INFER-DIRTY
 (params (<ob>))
 (preconds
  (and (~ (exists (<ob>) (equip <ob>) (clean <ob>)))
       (~ (exists (<ob>) (equip <ob>) (soap <ob>)))
       (~ (exists (<ob>) (equip <ob>) (chlorine <ob>)))))
 (effects ((add (dirty <ob>)))))
  


(INFER-COLD-ELEMENT
 (params (<element>))
 (preconds
  (~ (exists (<element>) (fixed-feature <element>) (hot <element>))))
 (effects ((add (cold <element>)))))
  


(INFER-EMPTY
 (params (<ob> <water>))
 (preconds
  (~ (exists (<ob> <water>) (equip <ob>) (has <ob> <water>))))
 (effects ((add (empty <ob>)))))
  


;;;Taken from Schedworld domain

(INFER-IDLE 
 (params (<mach> <time-t>))
 (preconds
          (FORALL (<obj2> <m>)
		  (scheduled <obj2> <m> <time-t>)
		  (not-equal <m> <mach>)))
 (effects ((add (idle <mach> <time-t>)))))





))

