(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES*
      '((SELECT-FIRST-GOAL
          (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))


; Add-use-op-first makes sure that all of the optional parts that a user lists in the goal will
; be added to the state first.  USE-OPs are added using the use-op <obj> inference rule.  This
; way I'm assured that all the parts that need to go on the bike are added to the state BEFORE
; the bike is assembled... 

        (Add-use-op-first
          (lhs (and (current-node <node>)
		    (candidate-goal <node> (use-op <obj>))))
	  (rhs (select goal (use-op <obj>))))
       ))


(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* nil)

(setq *SCR-OP-REJECT-RULES* '(

(only-bolt-things-that-are-drillable
  (LHS 
    (and (current-node <node>)
         (current-goal <node> (attached <x> <y>))
         (candidate-op <node> BOLT)
         (KNOWN <node>
              (OR (~ (drillable <x>))
                  (~ (drillable <y>))))))
   (RHS (REJECT OPERATOR BOLT)))


; This prevents the INSERT operator from being fired using parts that cannot be inserted into 
; other parts or with parts that cannot be inserted into.  Pretty straight forward.

(only-try-and-insert-proper-items
  (LHS
    (and (current-node <node>)
         (current-goal <node> (attached <obj1> <obj2>))
         (candidate-op <node> INSERT)
         (KNOWN <node>
       (or (and (~ (a-type-of frame <obj2>))   ; parts that can be inserted into.
                (~ (a-type-of fork <obj2>))
                (~ (a-type-of Fwheel <obj2>))
                (~ (a-type-of Bwheel <obj2>)))
           (and (~ (a-type-of seat <obj1>))    ; parts that can insert.
                (~ (a-type-of fork <obj1>))
                (~ (a-type-of Bwheel <obj1>))
                (~ (a-type-of Lpedal <obj1>))
                (~ (a-type-of Rpedal <obj1>))
                (~ (a-type-of handleBars <obj1>))
                (~ (a-type-of Fwheel <obj1>))
                (~ (a-type-of Ftire <obj1>))
                (~ (a-type-of Btire <obj1>)))))))
   (RHS (REJECT OPERATOR INSERT)))



; The following rules simply prevent operators from firing with parts that cannot be
; attached using that operator... the names of the operators say it all.


(only-weld-things-that-are-weldable
  (LHS
    (and (current-node <node>)
         (current-goal <node> (attached <x> <y>))
         (candidate-op <node> WELD)
         (KNOWN <node>
              (OR (~ (weldable <x>))
                  (~ (weldable <y>))))))
   (RHS (REJECT OPERATOR WELD)))


(only-glue-things-that-are-gluable
  (LHS
    (and (current-node <node>)
         (current-goal <node> (attached <x> <y>))
         (candidate-op <node> GLUE)
         (KNOWN <node>
              (OR (~ (can-glue <x>))
                  (~ (can-glue <y>))))))
   (RHS (REJECT OPERATOR GLUE)))


(only-clamp-appropriate-things-together
  (LHS
    (and (current-node <node>)
         (current-goal <node> (attached <x> <y>))
         (candidate-op <node> CLAMP-ON)
         (KNOWN <node>
              (OR (~ (can-clamp <x>))
                  (~ (can-be-clamped-to <y>))))))
   (RHS (REJECT OPERATOR CLAMP-ON)))
))

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* '(


; This makes sure that it does not subgoal on the preconditions of the ATTACH-CHAIN operator. 
; I just want to check to make sure that all the parts that are necessary for the chain are on
; the bike before the chain goes on... I don't want to subgoal on getting these parts on.

(Dont-Subgoal-On-Attach-Chain-Preconds
  (LHS
    (AND (CURRENT-NODE <V30>)
	 (PARENT-OP <V30> ATTACH-CHAIN)
	 (PRIMARY-CANDIDATE-GOAL <V30> (ATTACHED <X> <Y>))))
  (RHS (REJECT GOAL (ATTACHED <X> <Y>))))


; This makes sure you don't subgoal on the (~ needs ...) precondition
; found in all of the attach operators (except for attach-chain).
; Obviously there is no operator to put (~needs) in the state...

(Dont-Subgoal-On-not-need
  (LHS
    (AND (CURRENT-NODE <V30>)
         (PARENT-OP <V30> <ANY-OP>)
         (PRIMARY-CANDIDATE-GOAL <V30> (~ (NEEDS <X> <Y>)))))
  (RHS (REJECT GOAL (~ (NEEDS <X> <Y>)))))


; Again, there is no way to achieve ~UESE <X> so I don't want it to subgoal on
; this in the ADD-OPTIONAL-PARTS operator.

(Dont-Subgoal-On-not-use
  (LHS
    (AND (CURRENT-NODE <V30>)
         (PARENT-OP <V30> <ANY-OP>)
         (PRIMARY-CANDIDATE-GOAL <V30> (~ (USE <X>)))))
  (RHS (REJECT GOAL (~ (USE <X>)))))

;makes sure you don't subgoal on the (~ attached...) precondition found in all of the attach
;operatores (except attach-chain).

(Dont-Subgoal-On-not-attached
  (LHS
    (AND (CURRENT-NODE <V30>)
         (PARENT-OP <V30> <ANY-OP>)
         (PRIMARY-CANDIDATE-GOAL <V30> (~ (ATTACHED <X> <Y>)))))
  (RHS (REJECT GOAL (~ (ATTACHED <X> <Y>)))))


(Dont-Subgoal-On-attaches-to
  (LHS
    (AND (CURRENT-NODE <V30>)
         (PARENT-OP <V30> <ANY-OP>)
         (PRIMARY-CANDIDATE-GOAL <V30> (ATTACHES-TO <X> <Y>))))
  (RHS (REJECT GOAL (ATTACHES-TO <X> <Y>))))


; This make sure you don't subgoal on USE <X>.  I want it to only use
; the parts given to it in the MAKE-<KIND>-BIKE list and not try and
; use other parts that are in the state.  This acheives that.

(Dont-Subgoal-On-use-obj
  (LHS
    (AND (CURRENT-NODE <V30>)
         (PARENT-OP <V30> <ANY-OP>)
         (PRIMARY-CANDIDATE-GOAL <V30> (USE <X>))))
  (RHS (REJECT GOAL (USE <X>))))


))









