; Operators

(setq *OPERATORS* '(


(GLUE
 (params (<obj1> <obj2>))
 (preconds
  (and (part <obj1>)
       (part <obj2>)
       (~(attached <obj1> <anything>))
       (can-glue <obj1>)
       (can-glue <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (add (attached <obj1> <obj2>)))))


(INSERT 
 (params (<obj1> <obj2>)) 
 (preconds
  (and (part <obj1>)
       (part <obj2>)
       (~(attached <obj1> <anything>))
       (or (and (frame <obj2>) (or (seat <obj1>)
				   (fork <obj1>)
				   (Bwheel <obj1>)
				   (Lpedal <obj1>)
				   (Rpedal <obj1>)
				   (handleBars <obj1>)))
	   (and (fork <obj2>) (Fwheel <obj1>))
	   (and (Fwheel <obj2>) (Ftire <obj1>))
	   (and (Bwheel <obj2>) (Btire <obj1>)))
       (compatible <obj1> <obj2>)))
  (effects (
   (add (attached <obj1> <obj2>)))))

(WELD
 (params (<obj1> <obj2>))
 (preconds
  (and (part <obj1>)
       (part <obj2>)
       (~(attached <obj1> <anything>))
       (weldable <obj1>)
       (weldable <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (add (attached <obj1> <obj2>)))))


(BOLT
 (params (<obj1> <obj2>))
 (preconds
  (and (part <obj1>)
       (part <obj2>)
       (~(attached <obj1> <anything>))
       (has-bolt-hole <obj1>)
       (has-bolt-hole <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (del (has-bolt-hole <obj1>))
  (del (has-bolt-hole <obj2>))
  (add (attached <obj1> <obj2>)))))


(CLAMP-ON
  (params (<obj1> <obj2>))
  (preconds 
    (and (part <obj1>)
         (part <obj2>)
         (~(attached <obj1> <anything>))
         (can-clamp <obj1>)
         (can-be-clamped-to <obj2>)
         (compatible <obj1> <obj2>)))
  (effects (
    (add (attached <obj1> <obj2>)))))


;(ATTACH-CHAIN
; (params (<obj1>))
; (preconds 
;   (and (chain <obj1>)
;        (Fsprocket <obj2>)
;        (Bsprocket <obj3>)
;        (Rpedal <obj4>)
;        (Bwheel <obj5>)
;        (shift-mech <obj6>)
;        (Lpedal <left-pedal>)
;        (Bwheel <back-wheel>)
;       (frame <xframe>)
;        (attached <obj2> <left-pedal>)
;        (attached <obj3> <back-wheel>)
;        (attached <obj6> <back-wheel>)
;        (attached <obj4> <xframe>)
;        (attached <obj5> <xframe>)))
; (effects (
;      (add (chain-attached)))))

(DRILL
 (params (<obj1>))
 (preconds
  (and (part <obj1>)
       (drillable <obj1>)))
 (effects (
   (add (has-bolt-hole <obj1>)))))

(PAINT
 (params (<obj1> <color1>))
 (preconds 
  (and (part <obj1>)
       (paint <color1>)
       (primed <obj1>)))
 (effects (
    (del (primed <obj1>))
    (add (painted <obj1> <color1>)))))


(PRIME
 (params (<obj>))
 (preconds
   (and (frame <obj>)
	(sanded <obj>)))
 (effects (
   (del (sanded <obj>))
   (add (primed <obj>)))))


(SAND 
  (params (<obj1>))
  (preconds (part <obj1>))
  (effects ( (add (sanded <obj1>)))))

))


(setq *INFERENCE-RULES* '(

(COMPATIBLE
 (params (<obj1> <obj2>))
 (preconds 
  (and (part <obj1>)
       (part <obj2>)
       (~(incompatible <obj1> <obj2>))
       (~(incompatible <obj2> <obj1>))))
 (effects (
   (add (compatible <obj1> <obj2>)))))

(PART
 (params (<obj>))
 (preconds
   (or (frame <obj>)
      (Fwheel <obj>)
      (Bwheel <obj>)
      (Ftire <obj>)
      (Btire <obj>)
      (Fsprocket <obj>)
      (Bsprocket <obj>)
      (seat <obj>)
      (handleBars <obj>)
      (Rpedal <obj>)
      (Lpedal <obj>) 
      (Fbrakes <obj>)
      (Bbrakes <obj>)
      (brake-cable <obj>)
      (chain <obj>)
      (brake-handle <obj>)
      (gear-shift <obj>)
      (gear-cable <obj>)
      (shift-mech <obj>)
      (Bfender <obj>)
      (Ffender <obj>)
      (chain-guard <obj>)
      (Breflector <obj>)
      (Freflector <obj>)
      (mirror <obj>)
      (squeeze-horn <obj>)
      (bell <obj>)
      (light <obj>)
      (decal <obj>)
      (foot-clip <obj>)
      (grip <obj>)
      (rack <obj>)
      (tassle <obj>)
      (fork <obj>)))
 (effects (
   (add (part <obj>)))))


(WELDABLE
  (params (<obj>))
  (preconds
    (or (frame <obj>)
        (rack <obj>)
        (Fsprocket <obj>)
        (Bsprocket <obj>)
        (Bwheel <obj>)
        (Rpedal <obj>)
        (Lpedal <obj>)
        (Fbrakes <obj>)
        (Bbrakes <obj>)
;        (shift-mech <obj>)
        (chain-guard <obj>)
        (Bfender <obj>)
        (Ffender <obj>)))
  (effects (
    (add (weldable <obj>)))))


(CAN-GLUE
  (params (<obj>))
  (preconds
    (or (frame <obj>)
        (Breflector <obj>)
        (Freflector <obj>)
        (decal <obj>)
        (tassle <obj>)
        (grip <obj>)))
  (effects (
     (add (can-glue <obj>)))))


(CAN-CLAMP
  (params (<obj>))
  (preconds 
     (or (Breflector <obj>)
         (Freflector <obj>)
         (light <obj>)
         (foot-clip <obj>)
         (rack <obj>)
         (tassle <obj>)
         (squeeze-horn <obj>)
         (mirror <obj>)
         (bell <obj>)
         (brake-cable <obj>)
         (gear-cable <obj>)))
  (effects (
     (add (can-clamp <obj>)))))


(CAN-BE-CLAMPED-TO
  (params (<obj>))
  (preconds
     (or (frame <obj>)
         (handleBars <obj>)
         (Rpedal <obj>)
         (Lpedal <obj>)
         (Bfender <obj>)
         (Ffender <obj>)))
  (effects (
      (add (can-be-clamped-to <obj>)))))


(DRILLABLE 
  (params (<obj>))
  (preconds
    (or (frame <obj>)
         (brake-handle <obj>)
         (Fbrakes <obj>)
         (Bbrakes <obj>)
         (gear-shift <obj>)
         (shift-mech <obj>)
         (fork <obj>)
         (Rpedal <obj>)
         (Lpedal <obj>)
         (Fsprocket <obj>)
         (Bsprocket <obj>)
         (Bwheel <obj>)
         (Bfender <obj>)
         (Ffender <obj>)
         (handleBars <obj>)
         (chain-guard <obj>)
         (Breflector <obj>)
         (Freflector <obj>)
         (mirror <obj>)
         (squeeze-horn <obj>)
         (bell <obj>)
         (light <obj>)
         (rack <obj>)))
  (effects (
    (add (drillable <obj>)))))


(MAKE-ROAD-BIKE
  (params (nil))
  (preconds
    (and (attached road-fork road-frame)
         (attached normal-shift-mech road-frame)
         (attached light-gear-cable road-frame)
         (attached road-Bhandle road-hbars)
         (attached normal-gear-shift road-frame)
         (attached light-Bcable road-frame)
         (attached top-Bbrakes road-frame)
         (attached top-Fbrakes road-fork)
         (attached cushy-seat road-frame)
         (attached road-Hbars road-frame)
         (attached F1-gear road-Rpedal)
         (attached road-Rpedal road-frame)
         (attached road-Lpedal road-frame)
         (attached B1-gear road-Bwheel)
         (attached road-Btire road-Bwheel)
         (attached road-Bwheel road-frame)
         (attached road-Ftire road-Fwheel)
         (attached road-Fwheel road-fork)))
  (effects (
       (add (built-road-bike)))))

(MAKE-RACE-BIKE
  (params (nil))
  (preconds
    (and (attached race-fork race-frame)
         (attached speed-shift-mech race-frame)
         (attached light-gear-cable race-frame)
         (attached race-Bhandle race-hbars)
         (attached precision-gear-shift race-frame)
         (attached light-Bcable race-frame)
         (attached low-Bbrakes race-frame)
         (attached low-Fbrakes race-fork)
         (attached hard-seat race-frame)
         (attached race-Hbars race-frame)
         (attached F3-gear race-Rpedal)
         (attached race-Rpedal race-frame)
         (attached race-Lpedal race-frame)
         (attached B5-gear race-Bwheel)
         (attached race-Btire race-Bwheel)
         (attached race-Bwheel race-frame)
         (attached race-Ftire race-Fwheel)
         (attached race-Fwheel race-fork)))
  (effects (
       (add (built-race-bike)))))


(MAKE-MOUTAIN-BIKE
  (params (nil))
  (preconds
    (and (attached mtn-fork mtn-frame)
         (attached normal-shift-mech mtn-frame)
         (attached heavy-gear-cable mtn-frame)
         (attached mtn-Bhandle mtn-hbars)
         (attached normal-gear-shift mtn-frame)
         (attached heavy-Bcable mtn-frame)
         (attached top-Bbrakes mtn-frame)
         (attached top-Fbrakes mtn-fork)
         (attached cushy-seat mtn-frame)
         (attached mtn-Hbars mtn-frame)
         (attached F2-gear mtn-Rpedal)
         (attached mtn-Rpedal mtn-frame)
         (attached mtn-Lpedal mtn-frame)
         (attached B5-gear mtn-Bwheel)
         (attached mtn-Btire mtn-Bwheel)
         (attached mtn-Bwheel mtn-frame)
         (attached mtn-Ftire mtn-Fwheel)
         (attached mtn-Fwheel mtn-fork)))
  (effects (
       (add (built-moutain-bike)))))



))




















