; Operators

(setq *OPERATORS* '(


;; NOTE: about all the operators that attach things (except for
;ATTACH-CHAIN which is treated as a special case).  ; we read the
;attached condition as "obj1 attached to obj2".  This is important.
;For instance optional ; parts can only attach to necessary parts.
;This is why the first generator reads "use obj1 OR use-op obj1" ; this
;means the part being attached can be either necessary or an optional
;part.  However obj2 must be a ; necessary part, period.  It then
;checks to see that obj1 is not attached to anything else because the ;
;way things are set up each object can only be attached to one thing
;(except for the frame and the chain).  ;NOTE: While I have the
;"compatible obj1 obj2" as a precondition you will notice I didn't add
;any incompatability ; to the state.  This is easy to do and I have a
;life to live so I didn't bother.  All you have to do is add ;
;"incompatible multi-tassle race-Hbars" to prevent multi colored
;tassles from being connected to the racing ; handlebars.  No problem.
;It WILL fail if you've state the goal as attaching multi-tassle and
;you're bulding ; a race bike (evenetualy) because none of the attach
;operators will be able to get past the compatible ; precondition.
;
;;NOTE: I got around using non-static generators for most things.
;Although "Use <x> <y>" list is absent from the ; start state it is
;added by the build-bike inference rule which is fired first thing
;(also I wrote a ; control rule to fire on optional parts lists
;"use-op" first thing if there were any optional parts ; listed in the
;top level goal of the start state... see the sc-rules.lisp file).
;Hence I did not need ; to infer whether or not I was using a
;particular part to build a bike every time.  I did, however, have ; to
;infer whether something was a part (everything except paint is treated
;as a part here).  I only had ; to resort to that once.  Damn I'm
;good...
;
;; NOTE: The NEEDs list.  You will notice every operator that attaches
;anything or paints deletes some things from the ; "needs obj1 obj2"
;list in the state.  What the NEEDs list does is ensures that no part
;goes on without having ; all the necessary parts attached to IT first.
;For instance you will find "NEEDS Bwheel Bsprocket" and ; "NEEDS
;Bwheel Btire" among the things in the list.  This means that the back
;wheel needs to have the ; back sprocket attached to it AND the back
;tire put on it before it can be attached to anything (in this ; case
;the frame).  When the back tire it attached to the back wheel ALL
;things which need the back tire ; are deleted from the needs list.
;Hence the "NEEDS Bwheel Btire" will dissapear from the list.  This way
;; I ensure that that nothing impossible goes on like putting the tire
;on AFTER the wheel is on the bike.  ; Pretty simple, yet somehow
;ingenious at the same time isn't it...
;
;; NOTE: When I say that it tries to attache an object to something
;this is not just a random attach attampt (of ; course).  It refers to
;the ATTACHES-TO list in the state (see the state).  For instance you
;will find ; "ATTACHES-TO seat frame" in the list.  This means that
;something that is a type of seat should be ; attached to something
;that is a type of frame.  Every type is delt with in this list so
;everything ; attaches the way its supposed to.  This way Prodigy will
;only bind Obj1 and Obj2 objects in such ; a way that they can, and are
;supposed to, be attached to one another.  Before I set this up it ;
;would simply generate random bindings for Obj1 and Obj2 and try to
;connect them.  Obviously this ; was an unsatisfacotry solution as
;large problems took FOREVER!  By adding the ATTACHES-TO constraint ;
;in the preconditions, the bindings for the objects to be attached are
;restricted not only to things ; that the user wants to add to the bike
;(with the USE and USE-OP scheme), but obj1 and obj2 varriables ; are
;bound only to parts that are supposed to attach such that obj1
;attaches to obj2.  It works out ; rather well since I can create a
;bike using EVERY optional part I have available and the bike is ;
;assembled in less than 350 nodes... not too bad.
;
;
;; INSERT was a real pain in the butt to get working.  It basicaly
;takes obj1 and sees if it can insert it into ; obj2.  For instance
;inserting a seat into the frame.  It checks to see if ojb1 is
;insertable and the obj2 ; has a slot for it to go in.  If both of
;these are true then you're off and running.
;
;;SLOT SCHEME: The frame type has slots for seats, handlebars, back
;wheels, left and right pedals and the fork.  ; Lpedal= type of left
;pedal, Bwheel = type of back wheel... you get it.  ; The fork has one
;slot for a front wheel.  ; The back and front wheels both have 'slots'
;for their respective tires.

(INSERT
 (params (<obj1> <obj2>))
 (preconds
  (and (OR (use <obj1>) (use <obj1>))
       (use <obj2>)
       (~(attached <obj1> <anything>))
       (a-type-of <type1> <obj1>)
       (a-type-of <type2> <obj2>)
       (attaches-to <type1> <type2>)
       (~(needs <type1> <anything2>))
       (or (and (a-type-of frame <obj2>) (or (a-type-of seat <obj1>)
                                   (a-type-of fork <obj1>)
                                   (a-type-of Bwheel <obj1>)
                                   (a-type-of Lpedal <obj1>)
                                   (a-type-of Rpedal <obj1>)
                                   (a-type-of handleBars <obj1>)))
           (and (a-type-of fork <obj2>) (a-type-of Fwheel <obj1>))
           (and (a-type-of Fwheel <obj2>) (a-type-of Ftire <obj1>))
           (and (a-type-of Bwheel <obj2>) (a-type-of Btire <obj1>)))
       (compatible <obj1> <obj2>)))
  (effects (
  (del (needs <*all> <type1>))                ;Please see above NOTE for explanation of this.
  (add (attached <obj1> <obj2>)))))


;; WELD is real simple.  Just checks all the usual preconditions (see
;NOTEs above) and then checks to see if both objects are ; weldable via
;an inference rule WELDABLE (pretty neat name choice, huh?).  If
;everythings aok it attaches the two objects ; and adusts the NEEDS
;list.

(WELD
 (params (<obj1> <obj2>))
 (preconds
  (and (OR (use <obj1>) (use-op <obj1>))
       (use <obj2>)
       (~(attached <obj1> <anything>))
       (a-type-of <type1> <obj1>)
       (a-type-of <type2> <obj2>)
       (attaches-to <type1> <type2>)
       (~(needs <type1> <anything2>))
       (weldable <obj1>)
       (weldable <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (del (needs <*all> <type1>))
  (add (attached <obj1> <obj2>)))))

;
;; BOLT works about the same as WELD except it has the "has-hole <obj>"
;precondition for the parts.  If it one or both of the ; parts don't
;have bolt holes in them the DRILL operator is called upon to rectify
;the situation (if it can).  If it is ; succsessful then we bolt the
;two parts together.  In the process, of course, the has-bolt-hole
;condition goes away.  This ; does not mean it no longer has a hole, it
;just no longer has an AVAILABLE hole... the one it has is filled with
;a bolt.

(BOLT
 (params (<obj1> <obj2>))
 (preconds
  (and (OR (use <obj1>) (use-op <obj1>))
       (use <obj2>)
       (~(attached <obj1> <anything>))
       (a-type-of <type1> <obj1>)
       (a-type-of <type2> <obj2>)
       (attaches-to <type1> <type2>)
       (~(needs <type1> <anything2>))
       (has-bolt-hole <obj1>)
       (has-bolt-hole <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (del (has-bolt-hole <obj1>))
  (del (has-bolt-hole <obj2>))
  (del (needs <*all> <type1>))
  (add (attached <obj1> <obj2>)))))


;GLUE works EXACTLY the same way weld does except it calls GLUABLE instead of WELDABLE 
;in the preconditions.  

(GLUE
 (params (<obj1> <obj2>))
 (preconds
  (and (OR (use <obj1>) (use-op <obj1>))
       (use <obj2>)
       (~(attached <obj1> <anything>))
       (a-type-of <type1> <obj1>)
       (a-type-of <type2> <obj2>)
       (attaches-to <type1> <type2>)
       (~(needs <type1> <anything2>))
       (can-glue <obj1>)
       (can-glue <obj2>)
       (compatible <obj1> <obj2>)))
 (effects (
  (del (needs <*all> <type1>))
  (add (attached <obj1> <obj2>)))))


;; CLAMP-ON works about the same way as the other attach operators
;except obj1 must be clampable (can be clamped on to ; something else)
;and obj2 (the thing it is being attached to) must be able to be
;clamped to.  Pretty simple.

(CLAMP-ON
  (params (<obj1> <obj2>))
  (preconds 
    (and (OR (use <obj1>) (use-op <obj1>))
       (use <obj2>)
       (~(attached <obj1> <anything>))
       (a-type-of <type1> <obj1>)
       (a-type-of <type2> <obj2>)
       (attaches-to <type1> <type2>)
       (~(needs <type1> <anything2>))
         (can-clamp <obj1>)
         (can-be-clamped-to <obj2>)
         (compatible <obj1> <obj2>)))
  (effects (
    (del (needs <*all> <type1>))
    (add (attached <obj1> <obj2>)))))

;
;;ATTACH-CHAIN is a specail case because I treated all chains
;differently than any other part.  I had to do this because the ; chain
;is attached to three different parts as opposed to just one.  You will
;note chain is not found in the NEEDS list...  ; I check that all the
;necessary parts are on in the preconditions (I wrote a control rule so
;that it would not subgoal on ; these preconditions... see
;SC-RULES.LISP).  Basicaly it just finds what chain its using
;(use-chain <chain>) and then ; checks to see if the right pedal (which
;must have the front sprocket attached to it if it is attached ala the
;NEEDS ; list), back wheel (which must have the back sprocket and back
;tire attached to it ala the NEEDS list) and the shift ; mechanism are
;all attached to the frame.  If they are then it goes ahead and
;attaches the chain, if not it fails.

 (ATTACH-CHAIN
  (params (<obj1>))
  (preconds 
    (and (use-chain <obj1>)
         (a-type-of chain <obj1>)
         (a-type-of Rpedal <obj2>)
         (a-type-of Bwheel <obj3>)
         (a-type-of shift-mech <obj4>)
         (attached <obj2> <frame>)
         (attached <obj3> <frame>)
         (attached <obj4> <frame>)))
  (effects (
       (del (needs <*anything> chain))
       (add (chain-attached <obj1>)))))


;DRILL just takes an object, sees if its DRILLABLE and then puts a bolt-hole in it if it is.

(DRILL
 (params (<obj1>))
 (preconds
  (and (OR (use <obj1>) (use-op <obj1>))
       (drillable <obj1>)))
 (effects (
   (add (has-bolt-hole <obj1>)))))


;; PAINT takes an object which must be a frame and paints it if it is
;first primed.  I only want to paint frames right now, ; but if later I
;wanted to paint fenders or whatever I could just add an or list... no
;problem.

(PAINT
 (params (<obj1> <color1>))
 (preconds 
  (and (use <obj1>)
       (a-type-of frame <obj1>)
       (a-type-of paint <color1>)
       (primed <obj1>)))
 (effects (
    (del (primed <obj1>))
    (del (needs <*anything> paint))
    (add (painted <obj1> <color1>)))))


;PRIME takes a frame and primes it if it is first sanded.

(PRIME
 (params (<obj>))
 (preconds
   (and (a-type-of frame <obj>)
	(sanded <obj>)))
 (effects (
   (del (sanded <obj>))
   (add (primed <obj>)))))


;SAND takes any object and sands it.

(SAND 
  (params (<obj1>))
  (preconds (use <obj1>))
  (effects ( (add (sanded <obj1>)))))

))


(setq *INFERENCE-RULES* '(


;; COMPATIBLE takes two objects and checks to see if they are in the
;INCOMPATIBLE list in either order.  NOTE that I do not ; have an
;incompatibles list in this examp[12~le, but you can see its easy to
;add one if you so desire.

(COMPATIBLE
 (params (<obj1> <obj2>))
 (preconds 
  (and (OR (use <obj1>) (use-op <obj1>))
       (use <obj2>)
       (~(incompatible <obj1> <obj2>))
       (~(incompatible <obj2> <obj1>))))
 (effects (
   (add (compatible <obj1> <obj2>)))))


;PART takes any object and determins if it is a part.  In this scheme
; everything is a part except the paint.

(PART
 (params (<obj>))
 (preconds
   (or (a-type-of frame <obj>)
      (a-type-of Fwheel <obj>)
      (a-type-of Bwheel <obj>)
      (a-type-of Ftire <obj>)
      (a-type-of Btire <obj>)
      (a-type-of Fsprocket <obj>)
      (a-type-of Bsprocket <obj>)
      (a-type-of seat <obj>)
      (a-type-of handleBars <obj>)
      (a-type-of Rpedal <obj>)
      (a-type-of Lpedal <obj>) 
      (a-type-of Fbrakes <obj>)
      (a-type-of Bbrakes <obj>)
      (a-type-of brake-cable <obj>)
      (a-type-of chain <obj>)
      (a-type-of brake-handle <obj>)
      (a-type-of gear-shift <obj>)
      (a-type-of gear-cable <obj>)
      (a-type-of shift-mech <obj>)
      (a-type-of Bfender <obj>)
      (a-type-of Ffender <obj>)
      (a-type-of chain-guard <obj>)
      (a-type-of Breflector <obj>)
      (a-type-of Freflector <obj>)
      (a-type-of mirror <obj>)
      (a-type-of squeeze-horn <obj>)
      (a-type-of bell <obj>)
      (a-type-of light <obj>)
      (a-type-of decal <obj>)
      (a-type-of Rfoot-clip <obj>)
      (a-type-of Lfoot-clip <obj>)
      (a-type-of grip <obj>)
      (a-type-of rack <obj>)
      (a-type-of tassle <obj>)
      (a-type-of fork <obj>)))
 (effects (
   (add (part <obj>)))))


;WELDABLE takes an object and adds to the state if it is weldable.

(WELDABLE
  (params (<obj>))
  (preconds
    (or (a-type-of frame <obj>)
        (a-type-of rack <obj>)
        (a-type-of Fsprocket <obj>)
        (a-type-of Bsprocket <obj>)
        (a-type-of Bwheel <obj>)
        (a-type-of Rpedal <obj>)
        (a-type-of Lpedal <obj>)
        (a-type-of Fbrakes <obj>)
        (a-type-of Bbrakes <obj>)
        (a-type-of chain-guard <obj>)
        (a-type-of Bfender <obj>)
        (a-type-of Ffender <obj>)))
  (effects (
    (add (weldable <obj>)))))


(CAN-GLUE
  (params (<obj>))
  (preconds
    (or (a-type-of frame <obj>)
        (a-type-of Breflector <obj>)
        (a-type-of Freflector <obj>)
        (a-type-of decal <obj>)
        (a-type-of handleBars <obj>)
        (a-type-of tassle <obj>)
        (a-type-of grip <obj>)))
  (effects (
     (add (can-glue <obj>)))))


(CAN-CLAMP
  (params (<obj>))
  (preconds 
     (or (a-type-of Breflector <obj>)
         (a-type-of Freflector <obj>)
         (a-type-of light <obj>)
         (a-type-of Rfoot-clip <obj>)
         (a-type-of Lfoot-clip <obj>)
         (a-type-of rack <obj>)
         (a-type-of tassle <obj>)
         (a-type-of squeeze-horn <obj>)
         (a-type-of mirror <obj>)
         (a-type-of bell <obj>)
         (a-type-of brake-cable <obj>)
         (a-type-of gear-cable <obj>)))
  (effects (
     (add (can-clamp <obj>)))))


(CAN-BE-CLAMPED-TO
  (params (<obj>))
  (preconds
     (or (a-type-of frame <obj>)
         (a-type-of handleBars <obj>)
         (a-type-of Rpedal <obj>)
         (a-type-of Lpedal <obj>)
         (a-type-of Bfender <obj>)
         (a-type-of Ffender <obj>)))
  (effects (
      (add (can-be-clamped-to <obj>)))))


(DRILLABLE 
  (params (<obj>))
  (preconds
    (or (a-type-of frame <obj>)
         (a-type-of brake-handle <obj>)
         (a-type-of Fbrakes <obj>)
         (a-type-of Bbrakes <obj>)
         (a-type-of rack <obj>)
         (a-type-of gear-shift <obj>)
         (a-type-of shift-mech <obj>)
         (a-type-of fork <obj>)
         (a-type-of Rpedal <obj>)
         (a-type-of Lpedal <obj>)
         (a-type-of Fsprocket <obj>)
         (a-type-of Bsprocket <obj>)
         (a-type-of Bwheel <obj>)
         (a-type-of Bfender <obj>)
         (a-type-of Ffender <obj>)
         (a-type-of handleBars <obj>)
         (a-type-of chain-guard <obj>)
         (a-type-of Breflector <obj>)
         (a-type-of Freflector <obj>)
         (a-type-of mirror <obj>)
         (a-type-of squeeze-horn <obj>)
         (a-type-of bell <obj>)
         (a-type-of light <obj>)
         (a-type-of rack <obj>)))
  (effects (
    (add (drillable <obj>)))))


;; USE-RACE--BIKE-PARTS adds the USE list to the state which determines
;which parts will be used to build the bike.  Note in ; this scheme it
;is easy to add new parts to the list or alter which parts are
;necessary and which are optional.  I did it ; that way because (a) I
;wanted a flexible, easily expandable and realistic problem and (b) I'm
;amazing.

(USE-RACE-BIKE-PARTS
  (params (nil))
  (preconds (part race-frame))
  (effects (
       (add (use-race-bike-parts))       ;Note that race bikes have no brakes... this is intentional because they don't.
       (add (use race-frame))
       (add (paint-color hot-pink))
       (add (use race-fork))
       (add (use speed-shift-mech))
       (add (use light-gear-cable))
       (add (use race-Bhandle))
       (add (use precision-gear-shift))
        (add (use race-hbars))
       (add (use light-Bcable))
       (add (use hard-seat))
       (add (use race-Lpedal))
       (add (use race-Rpedal))
       (add (use F3-gear))
       (add (use B5-gear))
       (add (use-chain light-chain))     ; Note that chains are treated seperately.
       (add (use race-Btire))
       (add (use race-Ftire))
       (add (use race-Bwheel))
       (add (use race-Fwheel)))))



;;USE-MOUNTAIN-BIKE-PARTS is the same as the use race bike parts except
;it introduces a different set of bike parts to the state.  ; NOTE I
;could have also added USE-ROAD-BIKE-PARTS etc... but I have a life and
;I've already spent WAY too much time on this.

(USE-MOUTAIN-BIKE-PARTS
  (params (nil))
  (preconds (part mtn-frame))
  (effects (
       (add (use-mtn-bike-parts))
       (add (use mtn-frame))
       (add (paint-color black))
       (add (use mtn-fork))
       (add (use normal-shift-mech))
       (add (use heavy-gear-cable))
       (add (use heavy-Bcable))
       (add (use mtn-Bhandle))
       (add (use mtn-hbars))
       (add (use normal-gear-shift))
       (add (use top-Bbrakes))
       (add (use top-Fbrakes))
       (add (use cushy-seat))
       (add (use F2-gear))
       (add (use B5-gear))
       (add (use mtn-Rpedal))
       (add (use mtn-Lpedal))
       (add (use-chain heavy-chain))
       (add (use mtn-Btire))
       (add (use mtn-Ftire))
       (add (use mtn-Bwheel))
       (add (use mtn-Fwheel)))))


; MAKE-MOUNTAIN-BIKE simply assembles all the parts in the USE list
;using the parts from the USE-MOUNTAIN-BIKE-PARTS list.  ; It first
;paints the frame (of course) and then tries to attach all the parts in
;the USE <z> list.  After this is done ; it then attaches the chain.
;Only after the chain is attached can the optional parts be added...
;and this is done.  ; hence the goal for bulding a simple, no frills
;moutain bike will be "built-mtn-bike" and thats it.  It will put the ;
;'stock' bike together for you.

(MAKE-MOUNTAIN-BIKE
  (params ())
   (preconds (and
     (use-mtn-bike-parts)
     (paint-color <color>)
     (use <frame>)
     (a-type-of frame <frame>)
     (painted <frame> <color>)
     (FORALL (<obj>) (use <obj>)
         (attached <obj> <anything>))
     (use-chain <chain>)
     (chain-attached <chain>)
     (attached-optional-parts)))
   (effects (
       (add (built-mtn-bike)))))

(MAKE-RACE-BIKE
  (params ())
   (preconds (and
     (use-race-bike-parts)
     (paint-color <color>)
     (use <frame>)
     (a-type-of frame <frame>)
     (painted <frame> <color>)
     (FORALL (<obj>) (use <obj>)
         (attached <obj> <anything>))
     (use-chain <chain>)
     (chain-attached <chain>)
     (attached-optional-parts)))
   (effects (
       (add (built-race-bike)))))


; ADD-OPTIONAL-PARTS-TO-STATE is used to do just that.  If your goal
;includes any "use-op <Z>" statements, it will add ; "USE-OP <part>" to
;the state.  These work the same way as the "USE <part>" list only they
;are not assemble until ; AFTER the chain goes on the bike using the
;ATTACH-OPTIONAL-PARTS (below).

(ADD-OPTIONAL-PARTS-TO-STATE
   (params (<obj>))
   (preconds (part <obj>))
   (effects (
       (add (use-op <obj>)))))

; ATTACH-OPTIONAL-PARTS works the same way the FORALL does in the
;MAKE-BIKE inference rules above.  It simply cycles through ; all the
;parts (if any) in the USE-OP list and tries to attach them to
;something.  When succsessfull it adds ; attached-optional-parts to the
;state and the MAKE-BIKE rule can satisfy it last precondition and it
;will then add ; built-bike to the state and we are done.  groovy...

(ATTACH-OPTIONAL-PARTS
   (params ())
   (preconds (FORALL (<obj>) (use-op <obj>)
               (attached <obj> <anything>)))
   (effects ( (add (attached-optional-parts)))))

))









