;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Search Control Rules for the Autoflight domain
;;;
;;;  Written by : Lin Chia-Chen
;;;
;;;  Email      : c473bf
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 

  ;;; this is the depth first search control rule
  '((SELECT-FIRST-GOAL
     (lhs (and (current-node <node>)
	       (not-top-level-node <node>)
	       (primary-candidate-goal <node> <goal>)))
     (rhs (select goal <goal>)))
    )
  )


(setq *SCR-BINDINGS-SELECT-RULES* 
  '(

    ;;; This sc-rules make the plane land on destination cities and
    ;;; take off from departing cities.  Current-position of the city
    ;;; could be the departing or the arriving city.  At landing
    ;;; the pilot could only land of the city it's currently above of.
    ;;; At take-off, the plane has to be at the current position.
    ;;; (eg: the plane cannot take-off from a city, it's not presently
    ;;; at)
    (LAND-ON-AND-TAKE-OFF-FROM-RIGHT-CITIES
     (lhs (and (current-node <node>)
	       (or (current-op   <node>  LAND)
		   (current-op   <node>  TAKE-OFF))
	       (known <node> (current-position <city>))))
     (rhs (select bindings (<city>))))
))


(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-OP-PREFERENCE-RULES*
  '(

    ;;; Prefers to circle the plane around when a turbulent 
    ;;; rainstorm is encountered. There are two ways to handle a rainstorm
    ;;; by elevating the plane - handle-rainstorm (not exactly a very good name
    ;;; but..) and by circling the plane around.  In case of a turbulence,
    ;;; for some reasons, the pilot should circle the plane around.
    ;;; so Ready to circle rainstorm is prefered over elevation.
    ;;; I guess, I could make this preference rule a selection rule instead.
    ;;; But there might be situations for which circling the plane won't do it.
    (PREFER-CIRCUMVENTION-FOR-TURBULENT-RAINSTORMS
     (priority 0)
     (lhs (and (current-node <node>)
	   (candidate-bindings <node> (<from> <to> <country1> <country2>))
	   (candidate-op <node> READY-TO-HANDLE-RAINSTORM)
	   (candidate-op <node> READY-TO-CIRCLE-RAINSTORM)
	   (current-goal <node> (handle <from> <to> RAINSTORM))
	   (known <node> (and (weather <from> <to> RAINSTORM)
			      (weather <from> <to> TURBULENCE)))))
     (rhs (prefer operator READY-TO-CIRCLE-RAINSTORM READY-TO-HANDLE-RAINSTORM)))


  ))


(setq *SCR-GOAL-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* 

  '(


    ;;; As the name indicates, this sc-rule limits the pilot to fly out of
    ;;; of the country, as long as there are other paths his own country.
    ;;; <country-f>'s in the first candidate binding rule makes the cities
    ;;; from1 and to be in the same country, while the second binding rule
    ;;; allows other cities from different countries to be selected.
    ;;; Notice that in the "known <node>" rule <from1> is made the current
    ;;; position of the plane.  Thus a city where the plane is located, would
    ;;; be the more likely one to be prefered. 
    (PREFER-FLYING-IN-THE-COUNTRY-OF-DEST-CITY-AND-FLY-OUT-FROM-A-DEPARTING-CITY
      (priority 0)
      (lhs (and
	    (current-node <node>)
	    (current-op <node> FLY--------TO)
	    (candidate-bindings <node>
				(<from1> <to> <country-f> <country-f>))
	    (candidate-bindings <node>
				(<from2> <to> <country-x> <country-y>))
	    (known <node> (and (current-position <from1>)
			       (cityof <from1> <country-f>)))))
      (rhs (prefer bindings
		   (<from1> <to> <country-f> <country-f>)
		   (<from2> <to> <country-x> <country-y>))))


    ;;; This sc-rule is similar to the above control rule, the only
    ;;; difference is that the current-position <city> does not have
    ;;; to be the same as the departing city.  But this rule is necessary
    ;;; to "limit" flying to other cities not in the same country.
    ;;; Note: the priority in this sc-rules is set to 1, a "lower" priority
    ;;;       than the above sc-rule, so that when the above fails
    ;;;       (ie: when the departing city is not the current position of
    ;;;       plane) this rule can catch it.
    (PREFER-FLYING-IN-THE-COUNTRY-OF-DEST-CITY
      (priority 1)
      (lhs (and
	    (current-node <node>)
	    (current-op <node> FLY--------TO)
	    (candidate-bindings <node>
				(<from1> <to> <country-f> <country-f>))
	    (candidate-bindings <node>
				(<from2> <to> <country-x> <country-y>))
	    (known <node> (and (current-position <city>)
			       (cityof <city> <country-f>)))))
      (rhs (prefer bindings
	    (<from1> <to> <country-f> <country-f>)
	    (<from2> <to> <country-x> <country-y>))))


    ;;; this sc-rules makes the pilot choose easy to handle paths such
    ;;; as the sunny weather conditions.  (I'm not sure weather this
    ;;; rules is actually working)
     (PREFER-SUNNY-PATHS
      (priority 1)
      (lhs (and
	    (current-node <node>)
	    (current-op <node> FLY--------TO)
	    (candidate-bindings <node>
				(<from1> <to> <country1> <country2>))
	    (candidate-bindings <node>
				(<from2> <to> <country3> <country4>))
	    (known <node> (weather <from1> <to> SUNNY))))
      (rhs (prefer bindings
	    (<from1> <to> <country1> <country2>)
	    (<from2> <to> <country3> <country4>))))
    


     

     
))


  
