

(load-goal '(and
	     (current-position VANCOUVER)
	     (on-ground)
	     (tank FULL)))


(load-start-state
 '(

   ;; lets split the entire journey into 5 intervals
   ;; and lets give the weather conditions for those 10 intervals
   ;; city <name> <x-coord> <y-coord>  respect to San Diego
   (weather-type RAINSTORM)
   (weather-type HI-WIND)
   (weather-type LOW-WIND)
   (weather-type TURBULENCE)
   (weather-type LOW-PRESSURE)
   (weather-type SUNNY)
   (weather-type SNOW)
   (weather-type HAIL)

   (flap-position UP)
   (flap-position NEUTRAL)            ;; take-off
   (flap-position DOWN)               ;; landing

   (stick-position FRONT)             ;; landing  (descend)
   (stick-position BACK)              ;; take-off (ascend)
   (stick-position LEFT)              ;; turning
   (stick-position RIGHT)             ;; turning
   (stick-position NEUTRAL)           
   
   (gear-position  UP)                ;; after take-off
   (gear-position  DOWN)              ;; before landing

   (rudder-position NEUTRAL)          
   (rudder-position LEFT)
   (rudder-position RIGHT)

   (throttle-level  FULL)
   (throttle-level  MEDIUM)
   (throttle-level  LOW)
   (throttle-level  OFF)

   (runway-state CLEAR)
   (runway-state BUSY)

   (tank-level   FULL)
   (tank-level   MEDIUM)
   (tank-level   LOW)
   (tank-level   EMPTY)

   (direction    NORTH)
   (direction    SOUTH)
   (direction    EAST)
   (direction    WEST)

   (altitude-max 20000)               ;; maximum altitude
   (altitude-min 3000)                ;; minimum flight altitude

   (gas-truck-position  NEAR)
   (gas-truck-position  FAR)
	
;; available flight paths

   (path SEATTLE PORTLAND)
   (path LOSANGELES SANDIEGO)
   (path PORTLAND SANFRANCISCO)
   (path SANFRANCISCO LOSANGELES)
   (path PORTLAND CHICAGO)
   (path CHICAGO  RHINO)
   
   (path RHINO   SANDIEGO)
   (path SEATTLE VANCOUVER)
   (path VANCOUVER TORONTO)
   (path TORONTO CHICAGO)
   (path CHICAGO SANJOSE)
   (path SANJOSE LOSANGELES)

;; you can get to the destination only if the weather is sunny or stable
;; (weather SEATTLE  PORTLAND        STABLE)
;; it's conceivable that the auto-pilot cannot find any way to handle
;; the current weather condition so the plan
   

   (weather SEATTLE  PORTLAND        RAINSTORM)
   (weather SEATTLE  PORTLAND        HI-WIND)
   (weather SEATTLE  PORTLAND        TURBULENCE)
   (weather LOSANGELES SANDIEGO      LOW-WIND)
   (weather PORTLAND SANFRANCISCO    LOW-PRESSURE)
   (weather SANFRANCISCO LOSANGELES  HI-WIND)
   (weather PORTLAND CHICAGO         SUNNY)
   
   (weather SEATTLE VANCOUVER        RAINSTORM)
   (weather VANCOUVER TORONTO        SNOW)
   (weather TORONTO CHICAGO          HI-WIND)
   (weather CHICAGO SANJOSE          HI-WIND)
   (weather SANJOSE LOSANGELES       SUNNY)

   (current-position   SEATTLE) 		    ;; current position
;;   (current-position   RHINO)
   (route       SEATTLE SANDIEGO)
   (distance    SEATTLE SANDIEGO 1000)      ;; (miles)  just a wild guess

   (on-ground)
   (gas-truck   NEAR)
   (runway      CLEAR)

   (tank        EMPTY)                      ;; (gallons)
   (stick       BACK)
   (flap        NEUTRAL)
   (gear        DOWN)
   (rudder      NEUTRAL)
   (throttle    FULL)
   
;   (city  VANCOUVER  0  14   NORTH)
;   (city  SEATTLE    0  12   SOUTH)
;   (city  PORTLAND   0  10   SOUTH)
;   (city  SANFRANCISCO     0  7    NORTH)
;   (city  SANJOSE          0  6    EAST)
;   (city  LOSANGELES       0  1    NORTH)
;   (city  SANDIEGO         0  0    NORTH)
;   (city  TORONTO          1  13   WEST)
;   (city  CHICAGO          1  10   EAST)
;   (city  RHINO            1  1    WEST)

   (city  VANCOUVER)
   (city  SEATTLE  )
   (city  PORTLAND )
   (city  SANFRANCISCO )
   (city  SANJOSE      )
   (city  LOSANGELES   )
   (city  SANDIEGO     )
   (city  TORONTO      )
   (city  CHICAGO      )
   (city  RHINO        )

   
   ))








