
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;                     AUTOFLIGHT Operators
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(setq *OPERATORS* '(


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;           		    
;; These are the three principal operators: TAKE-OFF, FLY-TO, and LAND		    
;;         
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; To take off the we must be at the right locations and ensure
;; that we have enough gas, and set all instrumentations		    
		    
(TAKE-OFF
 (params (<thecity> <COUNTRY>))
 (preconds 
  (and 
   (cityof <thecity> <COUNTRY> )
   (current-position <thecity>)
   (tank        2000)
   (rudder      NEUTRAL)    
   (gear        DOWN)
   (flap        NEUTRAL)
   (stick       BACK)
   (runway      CLEAR)
   (throttle    FULL)
   (on-ground)))
 (effects
  ((del (on-ground))
   (del (stick    BACK))
   (del (throttle FULL))
   (del (gear  DOWN))           ;; bring in the gears
   (add (gear  UP))          
   (add (stick NEUTRAL))        ;; maintain altitude
   (add (in-air))
   )))


;; Fly from one city to another.  This requires that the plane
;; is ready to handle the weather conditions encountered on the
;; path.  (Maybe with the exceptions of a sunny weather)
;; Currently only one type of weather will be handled.
;; (ie: it cannot handle hi-wind and snow all together)

(FLY--------TO
 (params (<FROM> <TO> <COUNTRY1> <COUNTRY2>))
 (preconds
   (and
    (cityof <FROM> <COUNTRY1>) (cityof <TO> <COUNTRY2>)
    (path      <FROM> <TO>)
    (current-position <FROM>)
    (FORALL (<WEATHER>)
	    (weather   <FROM> <TO> <WEATHER>)
	    (handle    <FROM> <TO> <WEATHER>))
    (in-air)))
 (effects
  ((del (current-position <FROM>))
   (del (handle <FROM> <TO> <*ALLWEATHER>))
   (add (current-position <TO>)))))



;;  Land at the current city.
;;  This operator caused much trouble because of goal clobbering:
;;  e.g: to be in-air requires stick BACK but when this is achieved
;;  the requirement for stick FRONT to decend will no longer be
;;  valid.  

(LAND 
 (params (<thecity>))
 (preconds 
  (and 
   (cityof <thecity> <COUNTRY>)
   (current-position <thecity>)
   (runway      CLEAR)
   (in-air)
   (stick       FRONT)
   (flap        UP)             
   (gear        DOWN)           
   ))
 (effects
  ((del (TANK <*level>))
   (del (in-air))
   (add (TANK EMPTY))
   (add (on-ground)))))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;       Plane Control Operators
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;  When flap is down the plane ascends and vice versa

(TURN-FLAP
 (params (<position>))
 (preconds
  (and
   (flap-position <position>)
   (flap-position <current>)
   (flap <current>)
   (not-equal <position> <current>)))
 (effects
  ((del (flap <current>))
   (add (flap <position>)))))
 

;; The stick actually controls flap and the ruddar
;; stick front/back :  descend/ascend  : flap    up/down
;; stick left/right :  left/right      : rudder  left/right

(SHIFT-STICK
 (params (<position>))
 (preconds
  (and
   (stick-position <position>)
   (stick-position <current>)
   (stick <current>)
   (not-equal <position> <current>)))
 (effects
  ((del (stick <current>))
   (add (stick <position>)))))


;; This operator enable/disables landing gears

(TURN-GEAR
 (params (<position>))
 (preconds
  (and
   (gear-position <position>)
   (gear-position <current>)
   (gear <current>)
   (not-equal <position> <current>)))
 (effects
  ((del (gear <current>))
   (add (gear <position>)))))


(TURN-THROTTLE 
 (params (<new-level>))
 (preconds
  (and
   (throttle-level <new-level>)
   (throttle-level <old-level>)
   (throttle <old-level>)
   (not-equal <new-level> <old-level>)))
 (effects
  ((del (throttle <old-level>))
   (add (throttle <new-level>)))))


(TURN-RUDDER2
 (params (<position>))
 (preconds
  (and
   (rudder-position <position>)
   (not-equal <position> <current>)))
 (effects
  ((del (gear <current>))
   (add (gear <position>)))))


(FILL-TANK
 (params (<level> <full>))
 (preconds
  (and
   (full-tank  <full>)
   (tank       <level>)
   (gas-truck NEAR)))
 (effects
  ((del (tank <level>))
   (add (tank <full>))
   (add (tank FULL)))))


;; not used currently
 
(BALANCE-WINGS
 (preconds
  (and
   (above-clouds)
   (switch MAINTAIN-BALANCE-MODE ON)))
 (effects
  ((add (balance WINGS)))))


;; this operator elevates the plane above the cloud

(ELEVATE-PLANE
  (preconds
   (and
    (tank        <level>)
    (stick       BACK)
    (flap        DOWN)))
  (effects
   ((add (above-clouds)))))


;;  not used currently

(LOWER-PLANE
  (preconds
   (and
    (stick       FRONT)
    (flap        UP)))
  (effects
   ((if (above-clouds)
	(del (on <disk1> <post1>)))
    (add (below-clouds)))))


;; this is a switch operator : flips switches from one state to the other

(FLIP
  (params (<switch> <state2>))
  (preconds
   (and
    (on-off <state1>)
    (on-off <state2>)
    (switch-type <switch>)
    (not-equal <state1> <state2>)
    (switch  <switch> <state1>)))
  (effects
   ((del (switch <switch> <state1>))
    (add (switch <switch> <state2>)))))


(SET-RUDDER-ANGLE
 (preconds
  (and
   (angle <current>)
   (less-than <current> <required>)))
 (effects
  ((add (angle-required <required>)))))
    

(TURN-RUDDER
 (params (<angle-count> <new-angle-count>))
  (PRECONDS
   (AND
    (~ (rudder-turned))
    (Generate <angle-count> <new-angle-count> 1)
    (angle <angle-count>)))
  (EFFECTS
   ((del (angle <angle-count>))
    (add (angle <new-angle-count>)))))


(RUDDER-TURNED-TO-ANGLE
 (params (<required>))
 (preconds
  (and
   (angle-required <required>)
   (angle <required>)))
 (effects
  ((add (rudder-turned)))))


(SPEED-UP
 (effects
   ((del (throttle <*level>))
    (add (throttle FULL))
    (add (full-speed)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;      These Operators Handle weather conditions
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This is not a complete set of operators to handle all weather
;;  conditions therefore, only rainstorm and snow conditions are
;;  solvable by the planner.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;; Elevating the plane above the clouds is the best way to handle
;; rainstorms

(READY-TO-HANDLE-RAINSTORM
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO>   <COUNTRY2>)
   (weather   <FROM> <TO> RAINSTORM)
   (in-air)
   (above-clouds)))                
 (effects
  ((del (above-clouds))
   (add (handle <FROM> <TO> RAINSTORM)))))


(READY-TO-CIRCLE-RAINSTORM
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather <FROM> <TO> RAINSTORM)
   (in-air)
   (angle-required 20)
   (rudder-turned)))
 (effects
  ((del (angle-required 20))
   (del (angle <*anyangle>))
   (del (rudder-turned))
   (add (angle 0))
   (add (handle <FROM> <TO> RAINSTORM)))))



;; Good visibility and air-conditioning (heating) are essential
;; in snow conditions

(READY-TO-HANDLE-SNOW
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> SNOW)
   (in-air)
   (switch AIR-CONDITIONING ON)
   (switch WIND-SCREEN-WIPER ON)))
 (effects
  ((add (handle <FROM> <TO> SNOW)))))



; lowing the plane and raise the throttle to go at full speed
(READY-TO-HANDLE-HI-WIND
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> HI-WIND)
   (in-air)
   (full-speed)
   (below-clouds)))
 (effects
  ((del (below-clouds))
   (del (full-speed))
   (add (handle <FROM> <TO> HI-WIND)))))


(READY-TO-HANDLE-LOW-WIND
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> LOW-WIND)
   (in-air)
   (above-clouds)))
 (effects
  ((del (above-clouds))
   (add (handle <FROM> <TO> LOW-WIND)))))


(READY-TO-HANDLE-TURBULENCE
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> TURBULENCE)
   (in-air)
   (balance WINGS)))
 (effects
  ((del (balance WINGS))
   (add (handle <FROM> <TO> TURBULENCE)))))


(READY-TO-HANDLE-SUNNY
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> SUNNY)
   (in-air)))
 (effects
  ((add (handle <FROM> <TO> SUNNY)))))


(READY-TO-HANDLE-LOW-PRESSURE
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO>   <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> LOW-PRESSURE)
   (in-air)
   (switch CABIN-PRESSURE-HI  ON)
   (switch CABIN-PRESSURE-LOW OFF)
   (balance WINGS)))
 (effects
  ((del (balance WINGS))
   (del (switch CABIN-PRESSURE-HI  ON))
   (del (switch CABIN-PRESSURE-LOW OFF))
   (add (handle <FROM> <TO> LOW-PRESSURE)))))



(READY-TO-HANDLE-HI-PRESSURE
 (params (<FROM> <TO>))
 (preconds
  (and
   (cityof <FROM> <COUNTRY1>)
   (cityof <TO> <COUNTRY2>)
   (weather-type <weather>)
   (weather   <FROM> <TO> HI-PRESSURE)
   (in-air)
   (switch CABIN-PRESSURE-HI  OFF)
   (switch CABIN-PRESSURE-LOW ON)
   (balance WINGS)))
 (effects
  ((del (balance WINGS))
   (del (switch CABIN-PRESSURE-HI  OFF))
   (del (switch CABIN-PRESSURE-LOW ON))
   (add (handle <FROM> <TO> LOW-PRESSURE)))))


))
		 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;;                     Inference Rules
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(setq *INFERENCE-RULES* '(

;; not used			  

(INFER-STABLE
 (preconds
  (and (windspeed  10)
       (pressure   1)))
 (effects
  ((add (stable)))))




			  
		       ))






