(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      ;; telling Prodigy to select goals in the order given.
      '((SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    ;; we want goals to be achieved in the right order
		    ;; even in the top level, so removed the next line
		    ;; (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))))

; no branching at operator level.
(setq *SCR-OP-SELECT-RULES* nil)

(setq *SCR-BINDINGS-SELECT-RULES* '(
      (BIND-TIME-FOR-STAY
           ;; binds the time-wanted to the operator before applying.
           (lhs
	        (and (current-node <node>)
		     (current-goal <node> (time-stay <city> <time-wanted>))
		     (current-op <node> CHECK-TIME-STAY)
		))
	   (rhs
	        (select bindings (<city> <time-wanted> <time-stayed>))
      ))

      (BIND-DIRECT-FLIGHT
         ;; choose binding from current city to next city in goal stack
         (lhs
	    (and (current-node <node>)
	         (current-goal <node> (flight-chosen <from-city> <city-to> <td> <ta>))
	         (current-op <node> CHOOSE-FLIGHT)
	         (known <node> 
		       (and 
			    (current-city <city-now>)
		            (flight <air-line> <city-now> <city-to> <f-num>)
	                    (flight-info <f-num> <td> <ta> <price>)
	                    (current-time <cur-time>)
	                    (later-time <td> <cur-time>)
			))
            ))
         (rhs (select bindings (<city-now> <city-to> <air-line> <price> <td> <ta>)))
      )

))


(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES* '(
      ;; if we want to find a flight to a city and we know there
      ;; was already a flight had flew to that city; and we know
      ;; the current time is even less than the previous time
      ;; when that trip was made, then we must reject this goal
      ;; to find a flight there.
      (REJECT-GOAL-FLIGHT-CHOSEN
          (lhs
	       (and (current-node <node>)
		    (current-goal <node> (flight-chosen <at> <to> <td> <ta>))
		    (known <node> (city-visited-at <to> <pre-time>))
		    (known <node> (current-time <cur-time>))
		    (later-time <pre-time> <cur-time>)
	       ))
	  (rhs
	       (reject goal (flight-chosen <at> <to> <td> <ta>))
      ))
))


(setq *SCR-OP-REJECT-RULES*  nil)

(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* nil)

(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES*  nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES*  '(
      (PREFER-DIRECT-FLIGHT
         ;; This is to choose a direct flight from the current city to
         ;; next destination city.
         (priority 0)
         (lhs
	    (and (current-node <node>)
	         (current-goal <node> (flight-chosen <city-now> <city-to> <td> <ta>))
	         (current-op <node> CHOOSE-FLIGHT)
	         (candidate-bindings <node> 
		       (<city-now> <city-to> <air-line> <price> <td> <ta>))
	         (candidate-bindings <node> 
                       (<city-now2> <city-to> <air-line2> <price2> <td2> <ta2>))
	         (not-equal <city-now> <city-now2>)
	         (known <node> 
		       (and 
			    (current-city <city-now>)
		            (flight <air-line> <city-now> <city-to> <f-num>)
	                    (flight-info <f-num> <td> <ta> <price>)
	                    (current-time <cur-time>)
	                    (later-time <td> <cur-time>)
			))
            ))
         (rhs (prefer bindings (<city-now> <city-to> <air-line> <price> <td> <ta>)
	                       (<city-now2> <city-to> <air-line2> <price2> <td2> <ta2>))
      ))
))


