(defun later-time (time1 time2)
    (cond ((and (is-variable time1) (is-variable time2))
	        'no-match-attempted)
	  ((is-variable time1)
	        (range-f time1 (1+ time2) (+ time2 10)))
	  ((is-variable time2)
	        (range-f time2 (- time1 10) (1- time1)))
	  (t (> time1 time2))))

(add-meta-fn 'later-time)

(defun less-than (x y)
    (cond ((and (is-variable x) (is-variable y))
	        'no-match-attempted)
	  ((is-variable x)
	        (range-f x (- y 10) (1- y)))
	  ((is-variable y)
	        (range-f y (1+ x) (+ x 10)))
	  (t (< x y))))


(defun over-budget (cur-amount)
    (cond ((is-variable cur-amount)
	        'no-match-attempted)
	  (t (> cur-amount *BUDGET*))))

(defun is-between (x high low)
    (cond ((or (is-variable high) (is-variable low))
	      'no-match-attemped)
	  ((not (is-variable x))
	      (and (<= x high) (>= x low)))
	  (t t)))


;; check time constraint takes three parameters in which one of
;; them is optional.  In the presense of optional time-list,
;; the function will check if the arrival time met the arrival
;; time requirement that the customer requires.
;;
;; it tries to find if there is a requirement set by the
;; customer and to check if it could fulfill the requirement.
;;
(defun check-time-constraint (city arr-time 
		    &optional (time-list *TIME-ARRIVAL-CONSTRAINT*))
    (cond ((null time-list)
	       t)
	  ((equal (caar time-list) city)
	       (is-between arr-time 
			   (second (car time-list))
			   (third (car time-list))))
	  (t (check-time-constraint city arr-time (cdr time-list)))
))


;; this function is copied from the domain matrix
(defun sum (x y result)          ;result := x + y
  (cond
   ((or (and (is-variable x)
	     (is-variable y)
	     (is-variable result))
	(and (is-variable x)
	     (is-variable y))
	(and (is-variable x)
	     (is-variable result))
	(and (is-variable y)
	     (is-variable result)))
    'no-match-attempted)
   ((is-variable x)
    `(((,x ,(- result y)))))
   ((is-variable y)
    `(((,y ,(- result x)))))
   ((is-variable result)
    `(((,result ,(+ x y)))))
   ((eq result (+ x y)))))



;; this function is copied from the domain matrix
(defun subtract (x y result)          ;result := x - y
  (cond
   ((or (and (is-variable x)
	     (is-variable y)
	     (is-variable result))
	(and (is-variable x)
	     (is-variable y))
	(and (is-variable x)
	     (is-variable result))
	(and (is-variable y)
	     (is-variable result)))
    'no-match-attempted)
   ((is-variable x)
    `(((,x ,(+ result y)))))
   ((is-variable y)
    `(((,y ,(- x result)))))
   ((is-variable result)
    `(((,result ,(- x y)))))
   ((eq result (- x y)))))




;; this function is copied from the domain matrix
(defun range-f (k start end)    ;generates integers from 'start to 'end
  (cond
   ((or (not (is-variable k))
	(is-variable start)
	(is-variable end))
    'no-match-attempted)
   (t
    (do* ((val end (- val 1))
	  (lst-of-bindings 
	   (list (list (list k val)))
	   (cons (list (list k val))
		 lst-of-bindings)))
	 ((equal start val) lst-of-bindings)))))

