
;*****************************************************************************
;**									    **
;**  Project 3								    **
;**									    **
;**									    **
;**  File:  sc-rules.lisp						    **
;**									    **
;**									    **
;**	John Williams							    **
;**	8858702								    **
;**	CSE 473  Spring 1991						    **
;**									    **
;**									    **
;**  War World II							    **
;**									    **
;**     Late World War II era, operational level battle planning.	    **
;**     See README file for more information.				    **
;**									    **
;*****************************************************************************



(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES*
      '(
        (SELECT-FIRST-GOAL  (PRIORITY 0)	; This, I presume, is
          (lhs (and (current-node <node>)	; the default sc-rule.
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
          (rhs (select goal <goal>)))
      ))

(setq *SCR-OP-SELECT-RULES*		nil)
(setq *SCR-BINDINGS-SELECT-RULES*	nil)
(setq *SCR-NODE-REJECT-RULES*		nil)
(setq *SCR-GOAL-REJECT-RULES*		nil)
(setq *SCR-OP-REJECT-RULES*		nil)
(setq *SCR-BINDINGS-REJECT-RULES*	nil)
(setq *SCR-NODE-PREFERENCE-RULES*	nil)
(setq *SCR-GOAL-PREFERENCE-RULES*	nil)




(setq *SCR-OP-PREFERENCE-RULES*
      '(

;;; -------------------------------------------------------------------------
;;;  This rule works.  It keeps Prodigy from trying to assign units to the
;;;  reserve until it's tried doing something else with them.
;;; -------------------------------------------------------------------------

	(PREFER-ASSIGN-UNIT  (PRIORITY 0)	; This means we create the
	   (lhs (and (current-node <node>)	; reserve last of all.
		     (candidate-op <node> ASSIGN-UNIT)
		     (candidate-op <node> RESERVE-UNIT) ))
	   (rhs (prefer operator ASSIGN-UNIT RESERVE-UNIT)) )
      ))



(setq *SCR-BINDINGS-PREFERENCE-RULES*
      '(

;;; -------------------------------------------------------------------------
;;;  I can't get these rules to work.  They are very important for solving
;;;  basic problems.  For example, the first one allows vulnerable infantry
;;;  units to be singled out for armor attacks.  The others work about the
;;;  same way.  Problems p3 and p4 are the same, except for the order of
;;;  part of the start state.  Problem p3 cannot be solved without these
;;;  rules, while p4 is solved quickly.
;;;  For example, the first rule, PREFER-ARMOR-VS-INFANTRY, should try to
;;;  apply armored units when attacking INF class objectives.  <group> should
;;;  be bound to such a unit, which <group2> is bound to another type.  Also
;;;  note that the objective modifier must be less than 200, otherwise there
;;;  is no benefit to adding more armor.  (Only the first tank unit counts.)
;;; -------------------------------------------------------------------------


	(PREFER-ARMOR-VS-INFANTRY  (PRIORITY 0)	; This means tanks work
	  (lhs (and (current-node <node>)	; best on lightly armed men.
		    (current-goal <node> (~ (unassigned <unit>)))
		    ;&&(current-op   <node> ASSIGN-UNIT) ;causes rhs syntax err
		    (known <node> (and (unit-class <unit> ARMOR)
				       (is-group <group>)
				       (is-group <group2>)
				       (objective-class <group> INF)
				       (or (objective-class <group2> ARMOR)
					   (objective-class <group2> AT   ))
				       (objective-modifier <group> <mod>)
				       (less-than <mod> 200) )) ))
	  (rhs (prefer bindings (<group>) (<group2>))) )



	(PREFER-ARMOR-VS-ARMOR  (PRIORITY 0)	; This means tanks are
	  (lhs (and (current-node <node>)	; okay when attacking tanks.
		    (current-goal <node> (~ (unassigned <unit>)))
		    ;&&(current-op   <node> ASSIGN-UNIT) ;causes rhs syntax err
		    (known <node> (and (unit-class <unit> ARMOR)
				       (is-group <a-group>)
				       (is-group   <group>)
				       (objective-class <a-group> ARMOR)
				       (or (objective-class <group> INF)
					   (objective-class <group> AT ))
				       (objective-modifier <a-group> <mod>)
				       (less-than <mod> 100) )) ))
	  (rhs (prefer bindings (<a-group>) (<group>))) )


	(PREFER-INFANTRY-VS-AT  (PRIORITY 0)	; This means men work
	  (lhs (and (current-node <node>)	; best on anti-tank guns.
		    (current-goal <node> (~ (unassigned <unit>)))
		    ;&&(current-op   <node> ASSIGN-UNIT) ;causes rhs syntax err
		    (known <node> (and (unit-class <unit> ARMOR)
				       (is-group <at-group>)
				       (is-group    <group>)
				       (objective-class <at-group> AT)
				       (or (objective-class <group> ARMOR)
					   (objective-class <group> INF  ))
				       (objective-modifier <at-group> <mod>)
				       (less-than <mod> 100) )) ))
	  (rhs (prefer bindings (<at-group>) (<group>))) )

      ))

