;*****************************************************************************
;**									    **
;**  Project 3								    **
;**									    **
;**									    **
;**  File:  domain.lisp							    **
;**									    **
;**									    **
;**	John Williams							    **
;**	8858702								    **
;**	CSE 473  Spring 1991						    **
;**									    **
;**									    **
;**  War World II							    **
;**									    **
;**     Late World War II era, operational level battle planning.	    **
;**     See README file for more information.				    **
;**									    **
;*****************************************************************************





;=============================================================================
;=   File:  domain.lisp						    Page  2  =
;=				Operators.				     =
;=									     =
;=============================================================================




(setq *OPERATORS* '(




;;; -------------------------------------------------------------------------
;;;	ASSIGN-UNIT assigns <unit> to a <group> (battle group).
;;;	It updates the strength of the group, stored in the state.
;;;	Note that strengths are modified by class.
;;; -------------------------------------------------------------------------


(ASSIGN-UNIT
   (params   (<unit> <group>))

   (preconds (and (is-unit    <unit>)
		  (unassigned <unit>)
		  (is-group       <group>)
		  (has-strength   <group> <strength>)
		  (needs-strength <group>)
		  (add-numb <strength> 1 <new-strength>)
		  (unit-class      <unit>  <u-class>)
		  (objective-class <group> <o-class>)
		  (objective-modifier <group> <old-mod>)
		  (find-modifier <u-class> <o-class> <old-mod> <new-mod>) ))

   (effects  ( (del (unassigned  <unit>)	          )
	       (add (assigned	 <unit>)	          )
	       (add (assigned-to <unit> <group>)          )
	       (del (objective-modifier <group> <old-mod>))
	       (add (objective-modifier <group> <new-mod>))
	       (del (has-strength <group> <strength>)     )
	       (add (has-strength <group> <new-strength>) ) )) )


;;; -------------------------------------------------------------------------
;;;	RESERVE-UNIT places <unit> in reserve.  The strength of
;;;	the reserve force is updated, and stored in the state.
;;; -------------------------------------------------------------------------


(RESERVE-UNIT
   (params   (<unit>))

   (preconds (and (is-unit    <unit>)
		  (unassigned <unit>)
		  (reserve-strength <reserve>)
		  (add-numb         <reserve> 1 <new-reserve>) ))

   (effects  ( (del (unassigned <unit>)		     )
	       (add (in-reserve <unit>)	     	     )
	       (del (reserve-strength <reserve>)     )
	       (add (reserve-strength <new-reserve>) ) )))



;=============================================================================
;=   File:  domain.lisp						    Page  3  =
;=				Operators (continued).			     =
;=									     =
;=============================================================================




;;; -------------------------------------------------------------------------
;;;	COUNT-ENGAGEMENTS uses ADD-ENGAGEMENT as a "subroutine".  The "call"
;;;	takes place when Prodigy tries to meet the precondition "engaged".
;;;	These operators insure that a minimum number of objectives will be
;;;	engaged by groups.
;;; -------------------------------------------------------------------------



(COUNT-ENGAGEMENTS
   (params   ())

   (preconds (FORALL (<group>)
		     (is-group <group>)
		     (or (has-strength <group> 0)	; A group is engaged
		         (engaged      <group>)  ) ))	; if strength > 0.

   (effects  ( (add (engagements-counted)) )) )



(ADD-ENGAGEMENT
   (params   (<group>))

   (preconds (and (is-group <group>)
		  (number-of-engaged-groups <number>)	; Calculate new number
		  (add-numb 1 <number> <new-number>) )) ; of engaged groups.

   (effects  ( (add (engaged <group>)		           )
	       (del (number-of-engaged-groups <number>)    )	    ; Update
	       (add (number-of-engaged-groups <new-number>)) )) )   ; state.


		       ))





;=============================================================================
;=   File:  domain.lisp						    Page  4  =
;=				Inference rules.			     =
;=									     =
;=============================================================================




(setq *INFERENCE-RULES* '(

;;; -------------------------------------------------------------------------
;;;  A group has adequate strength if it has three times the objective's
;;;  strength.  This is modified by unit classes.  This applies to both
;;;  of the following rules, although they have different uses:
;;;  	o  INFER-HAS-ADEQUATE-STRENGTH is used as a goal, for all groups.
;;;	   We don't want any group making an attack unless the odds are in
;;;	   its favor.  If strength=0, then you don't attack:  that's okay.
;;;  	o  INFER-NEEDS-STRENGTH is used by ASSIGN-UNIT.  We only want a unit
;;;	   assigned to a group which needs the additional strength.  If
;;;	   strength=0, then you need more.
;;;  Note to calculations (in preconds):
;;;	True-strength must be greater than triple-objective.  We multiply
;;;	by 300 to give a percent strength.  The objective-modifier gives a
;;;	percent change also, so this is okay.  See the functions file.
;;; -------------------------------------------------------------------------

(INFER-HAS-ADEQUATE-STRENGTH		; (note:  strength=0 is ok)
   (params   (<group>) )
   (preconds (and (is-group           <group>)
		  (has-strength       <group> <strength>)
		  (objective-strength <group> <obj-str>)
		  (mul-numb 300 <obj-str> <triple-obj>)
		  (objective-modifier <group> <modifier>)
		  (mul-numb <modifier> <strength> <true-str>)
		  (gtr-or-eql <true-str> <triple-obj>)    ))
   (effects  ( (add (has-adequate-strength <group>)) )) )

li
	     ;; -------------------------------------------------------------
	     ;;  In the OR clause below, we must also check for strength=0.
	     ;;  This is because a group must have at least strength 1,
	     ;;  even if the objective has strength 0.
	     ;; -------------------------------------------------------------

(INFER-NEEDS-STRENGTH			; (note: strength=0 => needs more)
   (params   (<group>) )
   (preconds (and (is-group           <group>)
		  (has-strength       <group> <strength>)
		  (objective-strength <group> <obj-str>)
		  (mul-numb 300 <obj-str> <triple-obj>)
		  (objective-modifier <group> <modifier>)
		  (mul-numb <modifier> <strength> <true-str>)
		  (or  (less-than  <true-str> <triple-obj>)
		       (equals     <true-str> 0)            ) ))
   (effects  ( (add (needs-strength <group>)) )) )


		       ))

