*******************************************************************************|#



(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* 
      '(
        (SELECT-FIRST-GOAL
          (lhs (and (current-node <node>)
                    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
        ))

(setq *SCR-OP-SELECT-RULES* nil)
(setq *SCR-BINDINGS-SELECT-RULES* nil)
(setq *SCR-NODE-REJECT-RULES* 
   '(
;; 
;;  AVOID-MOVES-SAME-SQUARE
;;
;;      We have a piece of equipment at the goal site, and are trying
;;   to move it back to the start position.  If we cross square (x,y)
;;   on our way there, we do not want to visit the square more than once,
;;   for obvious reasons.
;;
     (AVOID-MOVES-SAME-SQUARE
       (lhs  (and (current-node <node>)
                  (current-goal <node> (location <us-type> <us-id> <x> <y>))
                  (on-goal-stack <node> (location <us-type> <us-id> <x> <y>))))
       (rhs (REJECT NODE <node>)))
;;
;; DONT-CLIMB-ANY-MOUNTAIN
;;
;; If we know that the terrain at a position is impassable, don't bother
;; attempting to move there.
;;
    (DONT-CLIMB-ANY-MOUNTAIN
        (lhs (and (current-node <node>)
                  (current-goal <node> (location <us-type> <id> <x> <y>))
                  (known <node> (terrain MOUNTAIN <x> <y>))))
        (rhs (reject node <node>)))
))
(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*
 '(
;;
;; PREFER-DESTROY-AIRCRAFT-OVER-GROUND-TARGETS
;;
  (PREFER-DESTROY-AIRCRAFT-OVER-GROUND-TARGETS
    (priority 0)
    (lhs (and (current-node <node>)
              (candidate-goal <node> (no-enemy-air-activity <x> <y>))
              (candidate-goal <node> (no-enemy-ground-forces-present <x> <y>))))
    (rhs (prefer goal (no-enemy-air-activity <x> <y>)
                      (no-enemy-ground-forces-present <x> <y>))))
)) 
(setq *SCR-OP-PREFERENCE-RULES* 
 '(
;;
;; MOVE-NAVY-IF-ON-WATER
;;
;;    If our goal is to move to a position which we know is water, 
;;  the only moves that should be made are by the NAVY...
;;
      (MOVE-NAVY-IF-ON-WATER
         (priority 0)
         (lhs (and (current-node <node>)
                   (current-goal <node> (location <id> <x> <y>))
                   (known <node> (terrain WATER <x> <y>))
                   (candidate-op <node> MOVE-NAVY <id> <x> <y>)
                   (candidate-op <node> MOVE-AIRPLANE <id> <x> <y>)))
         (rhs (PREFER OP MOVE-NAVY MOVE-AIRPLANE))) 
;;
;; PREFER-DESTROY-HEAVY-TARGET-OVER-LIGHT-TARGET
;;
    (PREFER-DESTROY-HEAVY-TARGET-OVER-LIGHT-TARGET
       (priority 0)
       (lhs (and (current-node <node>)
                 (candidate-op <node> (DECREASE-HEAVY-GROUND-TARGETS <e-type> <x> <y>))
                 (candidate-op <node> (DECREASE-LIGHT-GROUND-TARGETS <e-type> <x> <y>))))
       (rhs (prefer op DECREASE-HEAVY-GROUND-TARGETS
                       DECREASE-LIGHT-GROUND-TARGETS)))
))
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)


