;;
;; problem - sw5
;;
;;  9x9 grid...a whopper!
;;
(setq *MAXVAL* 8)  ;; Grid size for this problem

(load-goal '(AND (no-enemy-ground-forces-present 0 1)
                 (no-enemy-ground-forces-present 8 1)
                 (no-enemy-ground-forces-present 3 1)
                 (no-enemy-ground-forces-present 6 1)
                 (no-enemy-ground-forces-present 4 2)
                 (no-enemy-ground-forces-present 4 1)
                 (no-enemy-ground-forces-present 7 1)
                 (liberated 1 1)
                 (liberated 6 1)))

(load-start-state
     '(
;;
;; Physical terrain 
;;
;;
       (terrain     DESERT   0 0)       (terrain     DESERT   0 8)
       (terrain     DESERT   0 1)       (terrain     DESERT   0 5)
       (terrain     DESERT   0 2)       (terrain     DESERT   0 6)
       (terrain     DESERT   0 3)       (terrain     DESERT   0 7)
       (terrain     DESERT   1 7)       (terrain     DESERT   3 7)
       (terrain     DESERT   4 7)       (terrain     DESERT   5 7)
       (terrain     DESERT   6 7)       (terrain     DESERT   7 7)
       (terrain     DESERT   2 6)       (terrain     DESERT   3 6)      
       (terrain     DESERT   4 6)       (terrain     DESERT   5 6)
       (terrain     DESERT   6 6)       (terrain     DESERT   3 5)
       (terrain     DESERT   4 5)       (terrain     DESERT   4 4)
       (terrain     DESERT   3 3)       (terrain     DESERT   4 3)
       (terrain     DESERT   5 3)       (terrain     DESERT   4 2)
       (terrain     DESERT   1 1)       (terrain     DESERT   2 1)
       (terrain     DESERT   3 1)       (terrain     DESERT   4 1)
       (terrain     DESERT   5 1)       (terrain     DESERT   6 1)
       (terrain     DESERT   7 1)       (terrain     DESERT   6 0)
       (terrain     DESERT   7 0)       (terrain     DESERT   8 0)

       (terrain     HILLS    0 0)       (terrain     HILLS    1 0)
       (terrain     HILLS    2 0)       (terrain     HILLS    3 0)
       (terrain     HILLS    4 0)

       (terrain     WATER    0 1)       (terrain     WATER    8 1)
       (terrain     WATER    0 2)       (terrain     WATER    7 2)
       (terrain     WATER    1 2)       (terrain     WATER    8 2)
       (terrain     WATER    0 3)       (terrain     WATER    6 3)
       (terrain     WATER    1 3)       (terrain     WATER    7 3)
       (terrain     WATER    2 3)       (terrain     WATER    8 3)
       (terrain     WATER    0 5)       (terrain     WATER    6 5)
       (terrain     WATER    1 5)       (terrain     WATER    7 5)
       (terrain     WATER    2 5)       (terrain     WATER    8 5)
       (terrain     WATER    0 6)       (terrain     WATER    7 6)
       (terrain     WATER    1 6)       (terrain     WATER    8 6)
       (terrain     WATER    0 7)       (terrain     WATER    8 7)
       (terrain     WATER    0 4)       (terrain     WATER    2 4)       
       (terrain     WATER    1 4)       (terrain     WATER    3 4)       

       (terrain     MOUNTAIN 5 0)       (terrain     MOUNTAIN 2 2) 
       (terrain     MOUNTAIN 3 2)       (terrain     MOUNTAIN 5 2)
       (terrain     MOUNTAIN 6 2)       (terrain     MOUNTAIN 5 5)
       (terrain     MOUNTAIN 2 7)       (terrain     MOUNTAIN 4 8)
       (terrain     MOUNTAIN 5 4)       (terrain     MOUNTAIN 6 4)
       (terrain     MOUNTAIN 7 4)       (terrain     MOUNTAIN 8 4)

;;
;;
;; Obstacles
;;
       (obstacle 0 3)    (obstacle 1 3)   (obstacle 2 3) (obstacle 3 3)
       (obstacle 4 3)    (obstacle 5 3)   (obstacle 6 3) (obstacle 7 3)
       (obstacle 8 3)    (obstacle 2 2)   (obstacle 3 2) (obstacle 5 2)
       (obstacle 6 2)

;;
;; Enemy target classes
;;
       (heavy-target       SCUD-SITE)
       (heavy-target       BORROWED-RUSSIAN-TANK)
       (heavy-target       SADAAMS-BILLION-DOLLAR-BOMB-SHELTER)

       (light-target       TROOP)
       (light-target       LEAKY-RAFT)
       
       (aerial-target      AIRCRAFT)
       (aerial-target      HELICOPTER)

;;
;; Enemy locations
;;
;;                   type                                 x-pos     y-pos
;;     ------------------------------------------------------------------
       (enemy       TROOP                                   2         1)
       (enemy       TROOP                                   4         1)
       (enemy       TROOP                                   5         1)
       (enemy       TROOP                                   6         0)

       (enemy       SCUD-SITE                               1         1)
       (enemy       SCUD-SITE                               3         1)
       (enemy       SCUD-SITE                               4         1)
       (enemy       SCUD-SITE                               7         1)
      
       (enemy       AIRCRAFT                                1         1)
       (enemy       AIRCRAFT                                7         1)
       (enemy       HELICOPTER                              4         3)
       (enemy       HELICOPTER                              7         0)

       (enemy       LEAKY-RAFT                              0         1)
       (enemy       LEAKY-RAFT                              8         1)

       (enemy       BORROWED-RUSSIAN-TANK                   3         1)
       (enemy       BORROWED-RUSSIAN-TANK                   6         1)
       (enemy       BORROWED-RUSSIAN-TANK                   4         2)

       (enemy       SADAAMS-BILLION-DOLLAR-BOMB-SHELTER     6         0)

;;
;; US FORCES HERE
;;

  (class ARMY) 
  (army-type A0) (army-type A1) (army-type A2)

  (class AIRFORCE) 
  (air-type AF0) (air-type AF1) (air-type AF2)

  (class NAVY)
  (navy-type N0) (navy-type N1)

  (class MARINES)
  (marine-type M0)

  (removes-light-targets M0)
  (removes-light-targets AF2)
  (removes-light-targets N1)
  (removes-light-targets A1)

  (removes-heavy-targets AF1)
  (removes-heavy-targets A2)
  (removes-heavy-targets N1)

  (removes-aerial-targets AF1)

  (may-establish-US-presence DIVISION)
  (may-establish-US-presence BATTLESHIP)

  (can-remove-barricade MINE-UNIT)
  (can-remove-barricade MINESWEEPER)

;;
;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      AWACS       AF0)
     (register  AIRFORCE      F-16        AF1)
     (register  AIRFORCE      B-52        AF2)

     (register  ARMY          MINE-UNIT   A0)
     (register  ARMY          PLATOON     A1)
     (register  ARMY          TANK        A2)

     (register  NAVY          MINESWEEPER N0)
     (register  NAVY          BATTLESHIP  N1)

     (register  MARINES       DIVISION    M0)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     1      8)
     (location   AF1     5      8)
     (location   AF2     7      7)

     (location   A0      5      6)
     (location   A1      3      8)
     (location   A2      3      5)

     (location   N0      0      6)
     (location   N1      0      6)

     (location   M0      3      6)

;;
;; Original locations of US assets - these change when a piece of US equipment
;;                                   destroys a target
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   1 8)
  (start-location AF1   5 8)
  (start-location AF2   7 7)
  (start-location A0    5 6)
  (start-location A1    3 8)
  (start-location A2    3 5)
  (start-location N0    0 6)
  (start-location N1    0 6)
  (start-location M0    3 6)
))




