;;
;; problem - sw3
;;
;;     On a 5x5 grid, the US has few forces and multiple targets
;;  Your basic bombing run...

(setq *MAXVAL* 5)  ;; Grid size for this problem

(load-goal '(AND (~ (ENEMY BRIDGE 2 3)) (~ (ENEMY SCUD 0 2)) (~ (ENEMY SCUD 1 3)) (~ (ENEMY SCUD 1 4)) (~ (ENEMY AMMO-STOCKPILE 0 4))))

(load-start-state
     '(
;;
;; Physical terrain 
;;
;;
;;                  type     x y
;; -------------------------------------
       (terrain     DESERT   2 0)
       (terrain     DESERT   2 1)
       (terrain     DESERT   3 0)
       (terrain     DESERT   3 1)
       (terrain     DESERT   4 0)
       (terrain     DESERT   4 1)
       (terrain     DESERT   3 2)
       (terrain     DESERT   3 3)
       (terrain     DESERT   3 4)
       (terrain     DESERT   4 2)
       (terrain     DESERT   4 3)
       (terrain     DESERT   4 4)
       (terrain     DESERT   0 4)
       (terrain     DESERT   1 4)
       (terrain     DESERT   2 4)
       (terrain     DESERT   3 4)

       (terrain     HILLS    0 2)
       (terrain     HILLS    0 3)
       (terrain     HILLS    1 2)
       (terrain     HILLS    2 2)
       (terrain     HILLS    3 2)

       (terrain     WATER    0 0)
       (terrain     WATER    0 1)
       (terrain     WATER    1 0)
       (terrain     WATER    1 1)

;;
;;
;; Obstacles
;;
       (obstacle 1 2)
       (obstacle 2 2)
       (obstacle 3 2)
       (obstacle 4 2)
       (obstacle 3 3)
       (obstacle 3 4)
       (obstacle 4 3)
       (obstacle 4 4)
       (obstacle 2 4)

;;
;; Enemy target classes
;;
       (heavy-target       BRIDGE)
       (heavy-target       SCUD)
       (heavy-target       AMMO-STOCKPILE)

       (light-target       TROOP)
       
       (aerial-target      AIRCRAFT)

;;
;; Enemy locations
;;
;;                   type           x-pos     y-pos
;;     --------------------------------------------------------
       (enemy       TROOP             0         3)

       (enemy       SCUD              0         2)
       (enemy       SCUD              1         3)
       (enemy       SCUD              1         4)
      
       (enemy       BRIDGE            2         3)

       (enemy       AIRCRAFT          0         1)
       (enemy       AIRCRAFT          2         3)

       (enemy       AMMO-STOCKPILE    0         4)
;;
;; US FORCES HERE
;;

  (class ARMY) 
  (army-type A0)

  (class AIRFORCE) 
  (air-type AF0) (air-type AF1)

  (class MARINES)
  (marine-type M0)

  (removes-light-targets M0)
  (removes-heavy-targets AF1)
  (removes-aerial-targets AF1)

  (may-establish-US-presence DIVISION)

  (can-remove-barricade MINE-UNIT)

;;
;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      AWACS       AF0)
     (register  AIRFORCE      F-16        AF1)

     (register  ARMY          MINE-UNIT   A0)

     (register  MARINES       DIVISION    M0)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     4      0)
     (location   AF1     4      0)
     (location   A0      3      0)
     (location   M0      4      1)

;;
;; Original locations of US assets - these change when a piece of US equipment
;;                                   destroys a target
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   4 0)
  (start-location AF1   4 0)
  (start-location A0    3 0)
  (start-location M0    4 1)
))



