;;
;; problem - sw2
;;
;;    This one is tricky because we add a line of mountains, and the
;; only airplane is an AWACS.
;;

(setq *MAXVAL* 3)  ;; Grid size for this problem

(load-goal '(liberated 0 0))

(load-start-state
     '(
;;
;;  uses a 4x4 grid for this problem
;;

;;
;; Physical terrain 
;;
;;
;;                  type          x y
;; ---------------------------------------
       (terrain     MOUNTAIN      0 1)
       (terrain     MOUNTAIN      1 1)
       (terrain     MOUNTAIN      2 1)
       (terrain     MOUNTAIN      2 2)

       (terrain     DESERT        0 0)
       (terrain     DESERT        1 0)
       (terrain     DESERT        2 0)
       (terrain     DESERT        3 0)
       (terrain     DESERT        3 1)
       (terrain     DESERT        3 2)
       (terrain     DESERT        3 3)

       (terrain     HILLS         0 2)
       (terrain     HILLS         0 3)
       (terrain     HILLS         1 2)
       (terrain     HILLS         1 3)
       (terrain     HILLS         2 3)

;;     (terrain     WATER         x y)

;;
;;
;; Obstacles
;;
;;           x y
;; ---------------
   (obstacle 2 1)
   (obstacle 2 2)
   (obstacle 2 3)
   (obstacle 3 1)
   (obstacle 3 2)
   (obstacle 3 3)

;;
;; Enemy target classes
;;

       (heavy-target       TANK)
       (heavy-target       BRIDGE)
       (heavy-target       SCUD)
       (heavy-target       SADAAMS-HOUSE)

       (light-target       TROOP)
       (light-target       ELITE-REPUBLICAN-WIMPS)
       
;;       (aerial-target    NOTUSED)  

;;
;; Enemy locations
;;
;;                   type           x-pos     y-pos
;;     --------------------------------------------------------
       (enemy       TROOP             3         3)
       (enemy       TROOP             2         0)
       (enemy       TROOP             1         0)


       (enemy       TANK              3         3)
       (enemy       TANK              3         0)
       (enemy       TANK              1         0)
       (enemy       TANK              0         0)

       (enemy       SCUD              2         0)
       (enemy       SCUD              1         0)

       (enemy       SADAAMS-HOUSE              0         0)
       (enemy       ELITE-REPUBLICAN-WIMPS     0         0)
;;
;; US FORCES HERE
;;

  (class ARMY) 
  (army-type A0) (army-type A1) (army-type A2) (army-type A3) 

  (class AIRFORCE) 
  (air-type AF0)

  (class MARINES)
  (marine-type M0) (marine-type M1) 

  (removes-light-targets A0)
  (removes-light-targets M0)
  (removes-heavy-targets A3)

  (may-establish-US-presence PLATOON)   
  (may-establish-US-presence DIVISION)  

  (can-remove-barricade MINE-UNIT)

;;              class         ITEM        id 
;;---------------------------------------------------------------
     (register  AIRFORCE      AWACS       AF0)

     (register  ARMY          PLATOON     A0)
     (register  ARMY          PLATOON     A1)
     (register  ARMY          MINE-UNIT   A2)
     (register  ARMY          TANK        A3)

     (register  MARINES       DIVISION    M0)
     (register  MARINES       DIVISION    M1)

;;
;; Starting locations of US assets - these will change as needed
;;
;;               id     x-pos  y-pos
;; -----------------------------------------------
     (location   AF0     0      3)
     (location   A0      0      2)
     (location   A1      0      2)
     (location   A2      0      2)
     (location   A3      0      2)
     (location   M0      0      3)
     (location   M1      0      3)

;;
;; Original locations of US assets - these change when a target is destroyed
;;                                   by the piece of equipment
;;
;;                id    x y
;; ----------------------------
  (start-location AF0   0 3)
  (start-location A0    1 3)
  (start-location A1    1 3)
  (start-location A2    1 3)
  (start-location A3    1 3)
  (start-location M0    0 3)
  (start-location M1    0 3)
))



