(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* '(
    
    (SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))

       ))
    
(setq *SCR-OP-SELECT-RULES*  '(

;***************************************************************************
; This rule will determine if the problem wants aggressive fish and if
;     so, apply the operator GET_AGGRESSIVE_REQUIREMENTS.  This will
;     save an extreme amount of searching by avoiding trying either
;     a community tank or a goldfish tank before figuring out it was
;     an aggressive tank.
;
; NOTE:  CHOOSE-COMMUNITY_TYPE and CHOOSE-GOLDFISH_TYPE are exactly like
;     this except for the different types.
;***************************************************************************
    (CHOOSE-AGGRESSIVE_TYPE
         (lhs (and (current-node <node>)
	           (known <node> (~ (Selected <type>)))
	           (or (known <node> (Wants_Fish <fish>))
		       (candidate-goal <node> (Swimming <fish>)))
	           (known <node> (Aggressive <fish>))
	           (candidate-op <node> GET_AGGRESSIVE_REQUIREMENTS)))
         (rhs (select operator GET_AGGRESSIVE_REQUIREMENTS)))

    (CHOOSE-COMMUNITY-TYPE
         (lhs (and (current-node <node>)
	           (known <node> (~ (Selected <type>)))
	           (or (known <node> (Wants_Fish <fish>))
		       (candidate-goal <node> (Swimming <fish>)))
	           (known <node> (Community <fish>))
	           (candidate-op <node> GET_COMMUNITY_REQUIREMENTS)))
         (rhs (select operator GET_COMMUNITY_REQUIREMENTS)))

    (CHOOSE-GOLDFISH-TYPE
         (lhs (and (current-node <node>)
	           (known <node> (~ (Selected <type>)))
	           (or (known <node> (Wants_Fish <fish>))
		        (candidate-goal <node> (Swimming <fish>)))
	           (known <node> (GoldFish <fish>))
	           (candidate-op <node> GET_GOLD_FISH_REQUIREMENTS)))
         (rhs (select operator GET_GOLDFISH_REQUIREMENTS)))
))

(setq *SCR-BINDINGS-SELECT-RULES* '(

;***************************************************************************
; This rule will check to see if a specifice filter is requested and if
;    so will not waste time trying other types first.
; NOTE:   CHOOSE-CORRECT-FISH, CHOOSE-CORRECT-PLANT, CHOOSE-CORRECT-GRAVEL
;    all work very similar
;***************************************************************************

    (CHOOSE-CORRECT-FILTER_ONE
         (lhs (and (current-node <node>)
	           (current-goal <node> (~ (Need Filter)))
	           (current-op <node> ADD_FILTER)
	           (known <node> (Wants_Filter <filter>))))
         (rhs (select bindings (<filter>))))

    (CHOOSE-CORRECT-FISH_ONE
         (lhs (and (current-node <node>)
	           (current-goal <node> (~ (Need Fish)))
	           (current-op <node> ADD_FISH)
	           (known <node> (Wants_Fish <fish>))))
         (rhs (select bindings (<fish>))))

    (CHOOSE-CORRECT-PLANT_ONE
         (lhs (and (current-node <node>)
		   (current-goal <node> (~ (Need Plant)))
		   (current-op <node> ADD_PLANT)
		   (known <node> (Wants_Plant <plant>))))
	 (rhs (select bindings (<plant>))))

    (CHOOSE-CORRECT-GRAVEL_ONE
         (lhs (and (current-node <node>)
		   (current-goal <node> (~ (Need Gravel)))
		   (current-op <node> ADD_GRAVEL)
		   (known <node> (Wants_Gravel <color>))))
	 (rhs (select bindings (<color>))))

;************************************************************************
;   These rules will make CERTAIN we choose the correct type of thing
;       on the first attempt.  This solves problems such as having a
;       goal of (Swimming Aba_Aba_Knife) and makes sure it selects
;       the fish Aba_Aba_Knife instaed of another and coming back to
;       add the Aba_Aba_Knife later.
;************************************************************************
    (CHOOSE-CORRECT-FILTER_TWO
         (lhs (and (current-node <node>)
	           (current-goal <node> (~ (Need Filter)))
	           (current-op <node> SELECT_FILTER)
	           (is-top-level-goal <node> (Has_Filter <filter>))))
         (rhs (select bindings (<filter>))))

    (CHOOSE-CORRECT-FISH_TWO
         (lhs (and (current-node <node>)
	           (current-goal <node> (~ (Need Fish)))
	           (current-op <node> SELECT_FISH)
	           (is-top-level-goal <node> (Swimming <fish>))))
         (rhs (select bindings (<fish>))))

    (CHOOSE-CORRECT-PLANT_TWO
         (lhs (and (current-node <node>)
		   (current-goal <node> (~ (Need Plant)))
		   (current-op <node> SELECT_PLANT)
		   (is-top-level-goal <node> (Planted <plant>))))
	 (rhs (select bindings (<plant>))))

    (CHOOSE-CORRECT-GRAVEL_TWO
         (lhs (and (current-node <node>)
		   (current-goal <node> (~ (Need Gravel)))
		   (current-op <node> SELECT_GRAVEL)
	           (is-top-level-goal <node> (Has_Gravel <color>))))
	 (rhs (select bindings (<color>))))


;***************************************************************************
;  This rule will determine if the problem did not ask for a specific fish,
;     if so, it will just take the fist one it comes across that fits the 
;     type of tank selected and use it.
;***************************************************************************
    (CHOOSE-RANDOM-AGGRESSIVE
         (lhs (and (current-node <node>)
	           (current-goal <node> (~(Need Fish)))
	           (current-op <node> ADD_FISH)
	           (known <node> (Selected Aggressive_Tank))
	           (known <node> (~(Wants_Fish <fish1>)))
	           (known <node> (Aggressive <fish2>))))
         (rhs (select bindings (<fish2>))))

    (CHOOSE-RANDOM-COMMUNITY
         (lhs (and (current-node <node>)
	           (current-goal <node> (~(Need Fish)))
	           (current-op <node> ADD_FISH)
	           (known <node> (Selected Community_Tank))
	           (known <node> (~(Wants_Fish <fish1>)))
	           (known <node> (Community <fish2>))))
         (rhs (select bindings (<fish2>))))

    (CHOOSE-RANDOM-GOLDFISH
         (lhs (and (current-node <node>)
	           (current-goal <node> (~(Need Fish)))
	           (current-op <node> ADD_FISH)
	           (known <node> (Selected GoldFish_Tank))
	           (known <node> (~(Wants_Fish <fish1>)))
	           (known <node> (GoldFish <fish2>))))
         (rhs (select bindings (<fish2>))))
				     
))

	          

(setq *SCR-NODE-REJECT-RULES* '(

;************************************************************
;  The following three rules make certain that if we have
;      selected a type of tank, we don't put the wrong type
;      fish in it.... Actually, this just reduces the serach
;      time on that situation.
;************************************************************

    (MAKE-SURE-ONLY-AGGRESSIVE
         (lhs (and (primary-candidate-node <node>)
	           (known <node> (Selected Aggressive_Tank))
	           (or (known <node> (EXISTS (<fish>) (Community <fish>)
					     (Wants_Fish <fish>)))
		       (known <node> (EXISTS (<fish1>) (GoldFish <fish1>)
					     (Wants_Fish <fish1>))))))
         (rhs (reject node <node>)))

    (MAKE-SURE-ONLY-COMMUNITY
         (lhs (and (primary-candidate-node <node>)
	           (known <node> (Selected Community_Tank))
	           (or (known <node> (EXISTS (<fish>) (Aggressive <fish>)
					     (Wants_Fish <fish>)))
		       (known <node> (EXISTS (<fish1>) (GoldFish <fish1>)
					     (Wants_Fish <fish1>))))))
         (rhs (reject node <node>)))

    (MAKE-SURE-ONLY-GOLDFISH
         (lhs (and (primary-candidate-node <node>)
	           (known <node> (Selected GoldFish_Tank))
	           (or (known <node> (EXISTS (<fish>) (Community <fish>)
					     (Wants_Fish <fish>)))
		       (known <node> (EXISTS (<fish1>) (Aggressive <fish1>)
					     (Wants_Fish <fish1>))))))
         (rhs (reject node <node>)))



;*************************************************************
;  The following two rules make certain that if we want fish
;      of different types, we reject the node. no mixing.
;*************************************************************

    (MAKE-SURE-NO_MIXED_ONE
         (lhs (and (primary-candidate-node <node>)
	           (known <node> (Wants_Fish <fish1>))
	           (known <node> (Aggressive <fish1>))
	           (or (known <node> (EXISTS (<fish2>) (Community <fish2>)
					     (Wants_Fish <fish2>)))
		       (known <node> (EXISTS (<fish3>) (Goldfish <fish3>)
					     (Wants_Fish <fish3>))))))         
         (rhs (reject node <node>)))


    (MAKE-SURE-NO_MIXED_TWO
         (lhs (and (primary-candidate-node <node>)
	           (known <node> (Wants_Fish <fish1>))
	           (known <node> (Community <fish1>))
	           (or (known <node> (EXISTS (<fish2>) (Aggressive <fish2>)
					     (Wants_Fish <fish2>)))
	               (known <node> (EXISTS (<fish3>) (Goldfish <fish3>)
					     (Wants_Fish <fish3>))))))
         (rhs (reject node <node>)))
))

(setq *SCR-GOAL-REJECT-RULES* nil)
(setq *SCR-OP-REJECT-RULES* nil)
(setq *SCR-BINDINGS-REJECT-RULES* nil)
(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES*  nil)
(setq *SCR-OP-PREFERENCE-RULES* nil)
(setq *SCR-BINDINGS-PREFERENCE-RULES* nil)
