;;;	Two major top-level goals are available :  hasdate and accepteddate.
;;;	Hasdate is achievable via Gloat; accepteddate is achieved by
;;;	accept-date.  

; Operators

(setq *OPERATORS* '(

;	Count of operators (1)



;;;	Gloat is what achieves hasdate.  This is mostly a humor
;;;	operator, that requires the dater to have a date, forces
;;;	him or her be through talking to anyone and to be alone. 


(GLOAT
  (params (<dater>))
  (preconds (and (human <dater>)
	(nolongerneedsdate <dater>)
	(~(conversing <dater>))
	(or (athome <dater>)
	(inprivate <dater>))))
  (effects ((del (nodate <dater>))
 	   (add (hasdate <dater>)))))

;;; This operator allows the dater to work up the courage (non-quantified
;;; personal attribute) and actually ask the victim for a date
;;; All that is necessare for this operator is that saide dater is talking
;;; to another of the opposite sex.
;	Count of operators (2)

(HIT-ON
 (params (<person1> <person2>))
 (preconds (and (human <person1>)
		(human <person2>)
		(oppsex <person1> <person2>)
		(aretalking <person1> <person2>)))
  (effects ((add (askedfordate <person1> <person2>)))))


;;; This operator will accept a date from a dater (who HIT ON) if IF IF!!
;;; the boy or girl is satisfied with the asking person.  More on satisfied
;;; later.  Satisfaction is represented by no more musthave predicates.
;;; Unfortunately, this means that once one person satisfies the victim,
;;; any other cheap slime that comes along can get a date too.

;	Count of operators (3)


(ACCEPT-DATE
  (params (<victim> <dater>))
  (preconds (and (human <dater>)
		(human <victim>)
		(askedfordate <dater> <victim>)
		(satisfied <victim>)
		(aretalking <dater> <victim>)))
  (effects ((del (askedfordate <dater> <victim>))
	(add (accepteddate <victim>))
	(add (nolongerneedsdate <dater>))
	(add (hasdatewith <dater> <victim>)))))


;;; Suppose that this nice fellow (we'll reciprocate later) asked for a nice 
;;; date and she really wanted some trinket (like flowers or something), and 
;;; due to mild disappointment, must turn down the boy.  This will of course
;;; crush the boy and cause him to sulk.  Very sad.  But now he will know 
;;; what to get.
;	Count of operators (4)

(TURN-DOWN-GENTLY
  (params (<victim> <dater>))
  (preconds (and (human <dater>)
		 (human <victim>)
		 (aretalking <dater> <victim>)
		 (object <item>)
		 (required <need>)
		 (musthave <victim> <need> <item>)
		 (askedfordate <dater> <victim>)))
  (effects (
	(del (askedfordate <dater> <victim>))
	(add (sulking <dater>))
	(add (droppedhint <victim> <need> <item>)))))
 
;;; In order to win the heart of that gorgeous hunk, he may want some ice
;;; breaking gift.  Knowing men, it probably can be gotten from a dispensing
;;; machine (like GUM... oh baby you're so thoughtful).
;	Count of operators (5)


(ACQUIRE 
  (params (<dater> <ob>))
  (preconds (and
		(object <ob>)
		(dispenser <ob>)))
  (effects (
	(add (has <dater> <ob>)))))

;;; When two relatively attractive (actually appearance is not taken into
;;; account) are talking, the potential couple will test the compatiblity
;;; waters by finding any common interests.  In fact some people will only
;;; find another acceptable if they like skiing.  We (project people)
;;; are generally less stringent.
;	Count of operators (6)


(FIND-COMMON-INTEREST
  (params (<person1> <person2> <topic>))
  (preconds (and  (human <person1>)
		(human <person2>)
		(object <topic>)
		(aretalking <person2> <person1>)
		(interested <person1> <topic>)
		(interested <person2> <topic>)))
  (effects (
	(if (musthave <person1> interest <topic>)
		(del (musthave <person1> interest <topic>)))
	(if (musthave <person2> interest <topic>)
		(del (musthave <person2> interest <topic>))))))

;;;  There are now two pretend operators.  One for common interest.
;;;  If, for instance, Madonna only dates people who are interested in
;;;  French food.  Warren, being massively hot for her, will pretend to
;;;  like anything she wants (the power of hormones)
;	Count of operators (7)

(PRETEND-TO-BE-INTERESTED
  (params (<person> <attrib>))
  (preconds (and (human <person>)
		 (human <person2>)
		 (aretalking <person> <person2>)
		 (object <attrib>)))
  (effects (
	(add (interested <person> <attrib>)))))

;;; One for having a certain characteristic.
;;; Telling a joke is an age old method of making someone like you.  To tell
;;; a joke, the dater must have a highly developed sense of humor, else he 
;;; flub and shouldnt even bother.  Whether she has a sense of humor, well...
;	Count of operators (8)

(TELL-A-JOKE
  (params (<dater> <victim>))
  (preconds (and 
		(human <dater>)
		(has <dater> senseofhumor)
		(human <victim>)
		(aretalking <dater> <victim>)))
  (effects (
	(add (joketold <dater>)))))


;;;  The sister operator to tellajoke, this operator will return the proper
;;;  response to the told joke.  If the victim has a sense of humor, then,
;;;  she will laugh, and if she demands a funny guy, it will be satisfied.
;	Count of operators (9)

(LAUGH
  (params (<victim>))
  (preconds (and 
	(human <victim>)
	(human <dater>)
	(joketold <dater>)
	(has <victim> senseofhumor)))
  (effects (
	(if (musthave <victim> personality senseofhumor)
		(del (musthave <victim> personality senseofhumor)))
	    (add (laughedatjoke <victim> <dater>)))))



	    
;;;  Now a common thing for the people in this domain is to want things from
;;;  prospective daters.  To do so they must be offered these things.  Assuming
;;;  it even exists, and they are at the same location, said thingy will be 
;;;  offered.  Offered things can be unique (physical objects), or duplicatable
;;;  (phone #s etc)
;	Count of operators (10)

(OFFER
  (params (<person1> <person2> <ob>))
  (preconds (and
	    	(human <person1>)
	   	(human <person2>)
		(object <ob>)
		(or
			(has <person1> <ob>)
			(dispenses <person1> <ob>))
		(and 
			(location <loc>)
			(at <person1> <loc>)
			(at <person2> <loc>))))
 (effects
	((add (proffer <person1> <person2> <ob>)))))


;;;  Because desparate people will offer things, one must accept.  Because
;;;  people just dont give people flowers, they should be talking.  If the 
;;;  item is expensive, and the recipient is not greedy, then the item will
;;;  not be accepted. If the recipient is allergic to gift, failure will also
;;;  occur.
;	Count of operators (11)

(ACCEPT
  (params (<person1> <person2> <ob>))
  (preconds ( and
	(object <ob>)
	(human <person1>)
	(human <person2>)
	(conversing <person1>)
	(conversing <person2>)
	(aretalking <person2> <person1>)
	(or 
		(~(expensive <ob>))
		(greedy <person1>))
	(~(allergicto <person1> <ob>))
	(proffer <person2> <person1> <ob>)))
  (effects (
  	(add (has <person1> <ob>))
	(if (musthave <person1> gift <ob>)
		(del (musthave <person1> gift <ob>))
		(add (shouldbegratified <person2> <person1>)))
	(if (has <person2> <ob>) 
		(del (has <person2> <ob>)))
	(del (proffer <person2> <person1> <ob>)))))
	
;;;  Of course if an item cannot be accepted, it must be refused.  But this
;;;  is not inherantly bad.  It may be the case (as with the motivation for
;;;  this operator) that the victim wanted to be offered the object merely 
;;;  of the obvious display of affection.  This should be enough to satisfy
;;;  any material requirements of the person.
;	Count of operators (12)

(REFUSE-POLITELY
  (params (<victim> <dater> <ob>))
  (preconds ( and
	(object <ob>)
	(human <victim>)
	(human <dater>)
	(and
		(location <loc>)
		(at <dater> <loc>)
		(at <victim> <loc>))
	(or
	  (and
		(expensive <ob>)
		(~(greedy <victim>)))
	  (allergicto <victim> <ob>))))
   (effects ( 
	(if (musthave <victim> gift <ob>)
		(del (musthave <victim> gift <ob>))
		(add (shouldbegratified <dater> <victim>)))
	(del (proffer <dater> <victim> <ob>)))))


;;;	New preen : this is how to drop a hint that you want
;;;	to be told you are sexy.  Essentially, in the midst of a deep
;;;     meaningful conversation, one person suddenly feels that the opposing
;;;     dater is not progressing rapidly and must be queued for a compliment.
;;;     Thus a sex compliment can be made desired.

;	Count of operators (13)

(PREEN
  (params (<victim> <dater>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(oppsex <dater> <victim>)
		(conversing <dater>)
		(conversing <victim>)
		(aretalking <dater> <victim>)
		(musthave <victim> compliment sexy)
			))

  (effects (
	(add (droppedhint <victim> compliment sexy)))))

;;;	New compliment.  Specifies an attribute.  If it's the desired
;;;	one, then that requirement is now satisfied.  Otherwise, it
;;;	just adds flattered to the state.  It may be that that
;;;	is all that was needed.

;	Count of operators (14)

(COMPLIMENT
  (params (<dater> <victim> <trait>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(object <trait>)
		(droppedhint <victim> compliment <trait>)
		(aretalking <dater> <victim>)))
  (effects (
	(if (musthave <victim> compliment <trait>)
		(del (musthave <victim> compliment <trait>))
		(add (shouldbegratified <dater> <victim>)))
	(add (flattered <dater> <victim>)))))
		
;;; A basic human operation.  If something was offered, they generate a 
;;; shouldbegratified predicate.  Thank you is generated and the person
;;; is gratified.
;	Count of operators (15)

(THANK-YOU
  (params (<victim> <dater>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(aretalking <dater> <victim>)
		(shouldbegratified <dater> <victim>)))
  (effects (
	(del (shouldbegratified <dater> <victim>))
	(add (gratified <dater> <victim>)))))


;;; We have a limited concept of location in our domain.  To converse face
;;; to face we must move to the same place.  Also, to call others, we must
;;; at least be at home
;	Count of operators (16)

(GOTO 
  (params (<dater> <loc>))
  (preconds (and
		(human <dater>)
		(location <loc2>)
		(~(onphone <dater>))
		(~(conversing <dater>))
		(at <dater> <loc2>)	; used to be at
		(location <loc>)))
  (effects (
	(del (at <dater> <loc2>))	; no longer there
	(add (at <dater> <loc>)))))

;;;  If the victim must have either a gift or a compliment (hey she is talking
;;;  to you (or he), and they are not shy), they will hint at needing something
;;;  that the desparate dater could potentially supply.  
;	Count of operators (17)


(HINT-AT
  (params (<person1> <person2>))	
  (preconds  (and 
		(human <person1>)
		(human <person2>)
		(aretalking <person2> <person1>)
		(object <ob>)
		(not-equal <ob> sexy)
		(not-equal <ob> virile)
		(or
			(musthave <person1> gift <ob>)
			(musthave <person1> compliment <ob>))))
  (effects (
	(if (musthave <person1> compliment <ob>)
		(add (droppedhint <person1> compliment <ob>)))
	(if (musthave <person1> gift <ob>)
		(add (droppedhint <person1> gift <ob>))))))

;;;  This operator can achieve a conversation without the people being in
;;;  the same location.  Of course, they must be at home for the phones
;;;  to be of any use.
;	Count of operators (18)

(TELEPHONE
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
	 	(human <person2>)
		(athome <person1>) 
		(athome <person2>) 
		(phnumber <person2> <num2>)
		(has <person1> <num2>)
		(has <person1> phone)
		(has <person2> phone)
		(~(conversing <person1>))
		(~(conversing <person2>))
		(~(onphone <person1>))
		(~(onphone <person2>))))
  (effects (
	(add (aretalking <person1> <person2>))
	(add (onphone <person1>))
	(add (onphone <person2>)))))

;;;  To score at all, you should talk with the precious person.  Conversing
;;;  is the start of all things good.  Here is where we ensure we are talking
;;;  to an opposite gender person.  Conversing should be at the same location.
;;;  They should have greeted before talking.  
;	Count of operators (19)

(CONVERSE
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
	 	(human <person2>)
		(oppsex <person1> <person2>)
		(~(conversing <person1>))
		(~(conversing <person2>))
;	(~(athome <person1>))
		(location <loc>)
		(at <person1> <loc>)
		(at <person2> <loc>)
		(hasgreeted <person1> <person2>))) 
  (effects (
	(add (conversing <person1>))
	(add (conversing <person2>))
	(del (hasgreeted <person1> <person2>))
	(add (aretalking <person1> <person2>)))))
		
;;;  To get off the phone to do other things, this is the operator.
;	Count of operators (20)

(HANG-UP
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
	 	(human <person2>)
		(onphone <person1>)
		(onphone <person2>)
		(aretalking <person1> <person2>)))
  (effects (
	(del (onphone <person1>))
	(del (onphone <person2>))
	(del (aretalking <person1> <person2>)))))

;;; Saying bye is for terminating a conversation (when people are face to 
;;; face.)  
;;; Hack alert:  this is because I can't get the sc-rules to do this yet.
;;;  it prevents people from walking away until the requirements of the
;;;  victim have been satisfied.  (that is, the not exists portion is
;;; a hack.

;	Count of operators (21)

(SAY-BYE
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
	 	(human <person2>)
		(conversing <person1>)
		(conversing <person2>)
		(aretalking <person1> <person2>)
		(~(exists (<ob>)
			(object <ob>)
			(or
			(musthave <person2> interest <ob>)
			(musthave <person2> compliment <ob>))))))
  (effects (
	(del (conversing <person1>))
	(del (conversing <person2>))
	(del (aretalking <person1> <person2>)))))


;;;  Before you can engage in a meaningful conversation, you should say 
;;;  HI.  You do not say HI TO OTHERS OF THE SAME SEX.  If the dater is 
;;;  friendly lookin, then the victim will respond, and the greeting process
;;;  is complete.
;	Count of operators (22)

(SAY-HI
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
		(human <person2>)
		(oppsex <person1> <person2>)
		(looksfriendly <person1>)))
  (effects (
	(add (hasgreeted <person1> <person2>)))))

;;;  How do we look friendly.  To other opposite sex humans in the immediate
;;;  vincinity, a smile will achieve this.
;	Count of operators (23)

(SMILE
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
		(human <person2>)
		(oppsex <person1> <person2>)
		(location <loc>)
		(at <person1> <loc>)
		(at <person2> <loc>)))
  (effects (
	(add (looksfriendly <person1>)))))

;;;  Wink at will wink to people (if necessary) when talking.
;;;  Not used currently.
;	Count of operators (24)

(WINK-AT
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
		(human <person2>)
		(aretalking <person1> <person2>)))
  (effects (
	(add (winkedat <person1> <person2>)))))


;;; Ask-for is used as a generic phone greeting, such as "Is Arther there?"
;;;  this initiates a conversation over the phone.
;	Count of operators (25)

(ASK-FOR 	
  (params (<person1> <person2>))
  (preconds (and (human <person1>)
		(human <person2>)
		(onphone <person1>)
		(onphone <person2>)))
  (effects (
	(add (aretalking <person1> <person2>)))))


;;;  Flexing is the male counterpart of preen.  The conversing male will
;;;  want to impress the babe and have her say "What big muscles you haz!"
;;;  Thus, feeling much better, the guy might be more inclined to accept date 
;;;  from manipulative woman.  
;	Count of operators (26)

(FLEX 
  (params (<victim>))
  (preconds  (and 
		(human <victim>)
		(human <dater>)
		(oppsex <dater> <victim>)
		(conversing <dater>)
		(conversing <victim>)
		(aretalking <dater> <victim>)
		(musthave <victim> compliment virile)))
  (effects (
	(add (droppedhint <victim> compliment virile)))))


;;; Often after getting a yes, the person will quietly gloat to himself.
;;; He should go inprivate.  The mens room is such a location.

(GOTO-MENS-ROOM
  (params (<dater>))
  (preconds  (and 
		(human <dater>)
		(male <dater>)))
  (effects (
	(add (inprivate <dater>)))))


;;; Similar privacy achiever for women.

(GOTO-LADIES-ROOM
  (params (<dater>))
  (preconds  (and 
		(human <dater>)
		(female <dater>)))
  (effects (
	(add (inprivate <dater>)))))


;;; Now back to the gift giving aspect of the domain.  To get some kool
;;; gifts, there potentially could be a retailer that sells a needed object. 
;;; We assume money is no object.  The buyer should get to the store on his
;;; own.
(BUY
  (params (<dater> <retailer> <ob>))
  (preconds (and 
	(human <dater>)
	(human <retailer>)
	(object <ob>)
	(sells <retailer> <ob>)
	(location <loc>)
	(at <retailer> <loc>)
	(at <dater> <loc>)))
  (effects (
	(add (has <dater> <ob>)))))
	



 ))

(setq *INFERENCE-RULES* '(

;;; we infer that two people are the opposite sex if one is male and other is
;;; female.

(INFER-GENDER
  (params (<dater> <victim>))
  (preconds
	(or
	(and
		(male <dater>)
		(female <victim>))
	(and
		(female <dater>)
		(male <victim>))))
   (effects ((add (oppsex <dater> <victim>)))))

;;; infer if the persons location is his/her home, then he is at home

(INFER-AT-HOME
  (params (<person1>))
  (preconds (and 
	(human <person1>)
	(location <loc>)
	(home <person1> <loc>)
	(at <person1> <loc>)))
  (effects (
	(add (athome <person1>)))))

;;; infer whether the demanding victim has all of the tools that he/she must
;;; have.  If so then the person is satisfied

(INFER-IS-ENOUGH
  (params (<victim>))
  (preconds  
		(~(exists (<ob>)  (object <ob>) 
			(or
			(musthave <victim> compliment <ob>)
			(musthave <victim> interest <ob>)
			(musthave <victim> personality <ob>)
			(musthave <victim> gift <ob>)))))
  (effects ((add (satisfied <victim>)))))
	
		       ))























