; Search-Control rules file for CleanWorld,  (c) Matt Weatherford, CSE473, Spring '91
;
;

(setq *SCR-NODE-SELECT-RULES* nil)
(setq *SCR-GOAL-SELECT-RULES* '(

    (SELECT-FIRST-GOAL
  	  (lhs (and (current-node <node>)
		    (not-top-level-node <node>)
                    (primary-candidate-goal <node> <goal>)))
           (rhs (select goal <goal>)))
       ))


(setq *SCR-OP-SELECT-RULES*  nil)
(setq *SCR-BINDINGS-SELECT-RULES* '(

; Why put something down if we have a free arm?


(select-pickup-with-empty-arm
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op   <node> PICK-UP)
     (current-goal <node> (HOLDING <ARM> <ITEM> ) )
     (known <node>  (arm-empty <ARM>) )
    ))
   (rhs (select bindings ( <ITEM> <ARM> ) ))
)

))  ; END Bind-select


(setq *SCR-BINDINGS-REJECT-RULES* nil )
(setq *SCR-NODE-REJECT-RULES* nil)
(setq *SCR-GOAL-REJECT-RULES*  nil)

; Allow meta-fn 
(add-meta-fn 'parent-op)
(add-meta-fn 'gtr-than )

(setq *SCR-OP-REJECT-RULES* '(

; Prodigy, if it wants to see "nothing" somewhere, it may try to pick up
; "nothing" and put it down at a location... this is not a good idea, nor does it
; work anyway - just saves backtracking
;
(Reject-pickup-nothing
(lhs
  (and
    (current-node <node> )
    (current-goal <node> (HOLDING <SOME-ARM> nothing) )
    (candidate-op <node> PICK-UP )
  )
)

(rhs (reject op PICK-UP) )
)

;
;  For reasons similar to those above, we dont want to PUT-DOWN nothing because
; there is no way to HOLD NOTHING and we want to save backtracking.
;  Nothing is a simple convienince to tell Prodigy that there is a free space in
; the grid.  IT is NOT an object.  it has no "IS-A" relation.


(Reject-put-down-nothing
   (lhs
    (and
     (current-node <node> )
     (current-goal <node> (IS-AT <X> <Y> nothing) )
     (candidate-op <node> PUT-DOWN  )
    ))
   (rhs (reject op PUT-DOWN))
)


)) ; end SCR-OP-REJECT-RULES


(setq *SCR-BINDINGS-REJECT-RULES* '(

;  
;  Dont set down an object on a surface that we would like to make clean
;  Otherwise, we'll have to pick it up again before cleaning it.
;

(Reject-set-down-on-thing-trying-to-get-clean
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PUT-DOWN)
     (candidate-bindings <node> ( <item> <arm> <surface> ))
     (known <node>
	      (and (on-goal-stack <node> (status <surface> CLEAN) )
		   (is-a <surface> surface )
	      ))))
   (rhs (reject bindings ( <item> <arm> <surface> ) ) )
)

;
;  Dont pickup an item with an ARM that we are trying to clear
;

; Prodigy will subgoal on IS-AT to try to move a surface - these rules prevent
; it from doing such things as picking up and putting down a surface


(Reject-put-down-surface
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PUT-DOWN )
     (candidate-bindings <node> ( <item> <arm> <surface> ) )
     (known <node> (is-a <item> surface))
     ))
   (rhs (reject bindings ( <item> <arm> <surface> )))
)

(Reject-pick-up-surface
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PICK-UP )
     (candidate-bindings <node> ( <item> <arm>  ) )
     (known <node> (is-a <item> surface))
     ))
   (rhs (reject bindings ( <item> <arm> )))
)

; If we are trying to clear an arm, dont PICK something up with it.

(Reject-pickup-with-arm-trying-to-clear
 (priority 1)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PICK-UP )
     (candidate-bindings <node> ( <item> <arm> ) )
     (known <node> (on-goal-stack <node> (ARM-EMPTY <arm>) ))
     ))
   (rhs (reject bindings ( <item> <arm> )))
)

)) ; end bind-reject-rules



(setq *SCR-NODE-PREFERENCE-RULES* nil)
(setq *SCR-GOAL-PREFERENCE-RULES* '(

; Cleaning things should be done before trying to satisfy object positions,
; since cleaning may require moving things around... i.e. picking up an obj
; in order to spray/wipe shelf underneath... this avoids a lot of goal clobbering


(Prefer-clean-to-on
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (candidate-op <node> PUT-DOWN)
     (candidate-goal <node> (ON <object1> <surface> ) )
     (candidate-goal <node> (IS-CLEAN <object2>) ) ))
    (rhs (prefer goal (IS-CLEAN <object2> ) (ON <object1> <surface> )))
)



; If we have the option of cleaning 2 objects, clean the higher one first.
; This is to avoid getting dusty an object underneath another whenever possible.



(Prefer-higher-objs
 (priority 2)
   (lhs
    (and
     (current-node <node> )
     (candidate-op <node> INFER-CLEANLINESS )
     (candidate-goal <node> (IS-CLEAN <object1>) )
     (candidate-goal <node> (IS-CLEAN <object2>) )
     (Known <node>
	    (and
                 (IS-AT <x1> <y1> <object1>  )
                 (IS-AT <x2> <y2> <object2>  )
		 (gtr-than <y1> <y2> ) 
		 ))
     ))
   (rhs (prefer goal (IS-CLEAN <object1>) (IS-CLEAN <object2> )))
)

)); end GOAL PREF


(setq *SCR-OP-PREFERENCE-RULES* nil )



(setq *SCR-BINDINGS-PREFERENCE-RULES* '(

; Prefering to put down a book to a tool is generally better because chances are
; we'll need the tool again.


(Prefer-put-down-book
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PUT-DOWN)
     (candidate-bindings <node> ( <ITEM1> <ARM1> <SURFACE1> ) )
     (candidate-bindings <node> ( <ITEM2> <ARM2> <SURFACE2> ) )
    (known <node>  (and 
		    (is-a <ITEM1> book ) 
		    (is-a <ITEM2> tool ) 
		   ))
    ))
   (rhs (prefer bindings
                ( <ITEM1> <ARM1> <SURFACE1> )
                ( <ITEM2> <ARM2> <SURFACE2> )
   ))
)

; If we just picked something up, we probably dont want to drop it again immediately-
; this trys dropping something other than what we just picked up first.


(Prefer-to-use-arm-other-than-last-used-to-pick-up
 (priority 0)
   (lhs
    (and
     (current-node <node> )
     (current-op <node> PICK-UP)
     (candidate-bindings <node> ( <ITEM> <ARM1> ) )
     (candidate-bindings <node> ( <ITEM> <ARM2> ) )
     (known <node>  (arm-last-used <ARM1>) )
    ))
   (rhs (prefer bindings 
		( <ITEM> <ARM2> )
		( <ITEM> <ARM1> )
   ))
)







)) ;end Bindings-preference








