;                                                                          Matt Weatherford
;                                                                          AI, Spring, 91

; Operators - CLEANER

(setq *OPERATORS* '(

(DUST
  (params ( <thing> <arm> ))
  (preconds (and 
	     (is-a <thing> book)
	     (is-at <x1> <y1> <thing>)
	     (status <thing> dusty )
	     (holding <arm> dust-cloth )


))

  (effects (
	    (del (status <thing> dusty) )
	    (add (status <thing> clean) )
	    (IF (and                                      ; This dirties anything
		 (or
		   (is-a <*obj-in-range> book)
		   (is-a <*obj-in-range> surface) )
		 (is-at <*x2> <*y2> <*obj-in-range> )     ; in range of obj being
		 (in-range-of-dust <*x2> <*y2> <x1> <y1>) ; dusted.
		 (status <*obj-in-range> <*obj-condition> )
		 (isnt-equal <*obj-condition> irrel ))    ; dont dustify something we
                                                          ; dont care about
		 (del (status <*obj-in-range> <*obj-condition> ) )
		 (add (status <*obj-in-range> dusty ) )
	    )
  ))
)

(SPRAY
 (params ( <surface> ))
 (preconds  (and
	     (is-a <surface> surface )
	     (is-at <x> <y> <surface> )
	     (is-clear <surface> )
	     (holding <arm> spray-bottle )

	    ))
 (effects  (
	    (del (status <surface> <*condition> ))   ; removes all conds from surface
	    (add (status <surface> sprayed))
	   ))
)

(WIPE
 (params ( <surface> <arm> ))
 (preconds  (and
	     (is-a <surface> surface )
	     (is-a <arm> appendage )
	     (is-clear <surface> )
	     (status  <surface> sprayed)
	     (holding <arm> wipe-cloth)
	     ))
 (effects  (
	    (del (status <surface> sprayed ))
	    (add (status <surface> clean ))
	   ))
)



(PICK-UP

  (params  ( <item> <arm> ))
  (preconds (and  
	     (is-a <arm> appendage)
	     (is-at <x> <y> <item> )
	     (arm-empty <arm>)
	     (holdable <item> )

	     ))
  (effects (
	    (del (is-at <x> <y> <item> ))
	    (add (is-at <x> <y> nothing ))
	    (del (on <item> <*any-surface> ))
	    (del (arm-last-used <*anything> )) ; To be used by a search-ctrl rule
	    (add (arm-last-used <arm> ))
	    (add (holding <arm> <item> ))
	    (del (arm-empty <arm> ))
	    ))
  
)

(PUT-DOWN
  (params  ( <item> <arm> <surface> ))
  (preconds (and
	     (is-a <arm> appendage )
	     (is-a <surface> surface)
	     (is-at <x> <y> nothing )
	     (is-at <x> <y2> <surface> )
	     (holding <arm> <item> )
	     (is-clear <surface> )
	     (is-under <y2> <y> )


	     ))
  (effects (
    (del (is-at <x> <y> nothing ))
    (add (is-at <x> <y> <item>  ))       
    (del (holding <arm> <item> ))   
    (add (arm-empty <arm> ))
    (add (on <item> <surface> ))         
  ))
)



)) ; End of operators



(setq *INFERENCE-RULES* '(


(INFER-CLEANLINESS                    ; This is simple and may be omitted later
  (params nil )
  (preconds
    (status <thing> clean ) )
  (effects ((add (is-clean <thing> )))   )
)



(INFER-IS-CLEAR
  (params (<surface> ) )
  (preconds (and
	      (is-a <surface> surface )
	      (~ (EXISTS (<object>)  (on <object> <surface> ) ) )
	    ))
  (effects ((add (is-clear <surface> ))))
)



(INFER-HOLDABLE
  (params ( <object> ) )
  (preconds  (and
	      (is-a <object> <identity> )
	      (or
	        (is-equal <identity> book )
		(is-equal <identity> tool )
	      )))
  (effects ((add (holdable <object> ))))
)


)) ; End of inference rules
