;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;-------------------------------------------------------------------

;;See the file shared-literals/shared-literals.doc for documentation
;; of the functions in this code.


(defun sharable-literals (exp)
 (unless (OR (null exp) (atom exp))
  (let ((keyword (predicate-name exp)))
   (cond
    ((atomic-formula? exp)
     (list exp))  ;;was atomic formula
    ((OR (eq keyword 'NOT) (eq keyword '~))
      nil)  ;;was negated exists
    ((OR (equal keyword 'AND) (equal keyword 'OR))
     (remove-duplicates 
      (apply #'append (mapcar #'sharable-literals (rest exp)))
      :test #'equal))
    ((equal keyword 'EXISTS)
      nil)   ;;was exists statement
    ((equal keyword 'FORALL)
     nil)     ;;was forall statement
    (t (print
		'error-unsuitable-exp-for-func-sharable-literals))))))


(defun find-bindings-for-all-ops 
           (each-slave-ops-literals      each-slave-ops-goal-vars
            each-slave-ops-wild-vars each-slave-ops-unbound-vars
      &aux (number-of-operators (length each-slave-ops-literals)))

 (unless (null each-slave-ops-literals)     ;;do nothing if there are no ops

        ;;---make globals
  (setq throw-out nil)   ;;set to T if tlist should be thrown out
  (setq shared-literals nil) ;;list of those literals that end up being shared
  (setq blists (mapcar #'(lambda (x) nil) each-slave-ops-wild-vars)) 
                         ;;makes a big list of nils the right length
  (setq control-shareable-literals nil)             ;;set in function set-up-op1
  (setq control-op-never-match-vars nil) ;;set in function set-up-control-op
  (set-up-control-op (first each-slave-ops-literals)      (first each-slave-ops-goal-vars)
                     (first each-slave-ops-wild-vars) (first each-slave-ops-unbound-vars))
        ;;---done making globals

  (unless (= 1 number-of-operators)  ;;nothing is shared if only one op
   (iter:iterate
   (iter:for shared-literal? iter:in control-shareable-literals)
    (setq throw-out nil)
    (let (
      (tlists (find-tlists shared-literal? each-slave-ops-literals each-slave-ops-unbound-vars
	 					blists)))
     (unless throw-out
      (setq shared-literals (cons shared-literal? shared-literals))
      (setq blists (n-mapcar #'equal-union blists tlists))))))

  (setq blists (n-mapcar #'make-partial-blist-complete 
                            each-slave-ops-unbound-vars each-slave-ops-wild-vars 
                            blists))
  `(,blists ,shared-literals)))  ;;return value


;; gives unused variables in normal-vars and wild-vars new variable
;; names in blist.  So blist includes all the variables in normal-var
;; and wild-vars

(defun make-partial-blist-complete (normal-vars wild-vars blist)
 (let* (
   (unused-normal-vars (find-unused-normal normal-vars blist))
   (unused-blist       (make-new-same-kind-blist unused-normal-vars))
   (wild-card-blist    (make-new-wild-blist wild-vars)))
  (append unused-blist wild-card-blist blist)))

;;returns those variables in unbound-normal-vars that haven't already
;; been paired in partial-blist.

(defun find-unused-normal (unbound-normal-vars partial-blist)
 (remove-if #'(lambda (x) 
               (member x partial-blist :test #'eq-first-of-pair))
  unbound-normal-vars))
    
(defun equal-union (x y)
 (union x y :test #'equal))

;;Note:  If a shared literal matches exactly, it will still get put
;; in the shared list.

;;Note:  Don't want to use normal matcher with exclusion of wildcards or goal

;;variables because this would exclude those possiblities.  We need to
;;know if using one of the goal variables or the wildcards could make
;;the expressions match.  If so, we need to throw this whole tlist out
;;to avoid ambiguity in matching.

;;sets up the information about operator1 as a distinct copy of the
;;first operator in the find-bindings-for-all-ops input.

;;gives its variables unique names
;;instantiates it's literals with those new names
;;figures out which variables should never be match (it's goal
;;variables and its wildcard variables)

(defun set-up-control-op (literals goal-vars wild-vars unbound-vars)
 (let* (
   (goal-vars        (mapcar #'second goal-vars))
   (blist-wild       (make-new-wild-blist wild-vars))
   (new-wild-vars    (instantiate wild-vars blist-wild))
   (never-match-vars (append new-wild-vars goal-vars))
   (blist-unbound    (make-new-blist unbound-vars))
   (blist            (append blist-wild blist-unbound))
   (new-literals         (instantiate literals blist)))
  (setq control-shareable-literals new-literals)
  (setq control-op-never-match-vars never-match-vars)))

;;Given a shared-literal? and everything else currently known, 
;;  tries to find a matching for shared-literal? in every operators preconds
;;
;; Return values are 1) a partial bindings list for each operator
;;                   2) increasing length of shared-literals
;;                   3) setting throw-out to T if no matching was possible
;;
;; (throw-out should be set to nil before calling)
;;
;;uses recursion, working only with first element of input lists

(defun find-tlists (shared-literal? each-slave-ops-literals each-slave-ops-unbound-vars blists
                 &aux (literals            (first each-slave-ops-literals))
                      (unbound-vars    (first each-slave-ops-unbound-vars))
                      (blist           (first blists)))
 (unless (null each-slave-ops-literals) ;;termination condition
  (let (
    (tlist 'Unfound))
   (iter:iterate
   (iter:for lit iter:in literals)
    (let (
      (matcher-result (match-var-to-var-only-return-blist lit shared-literal?)))
     (unless (eq matcher-result 'No-match) ;;no match, so ignore & try next lit
      (if (eq tlist 'Unfound)  ;;is this the first match?
       (setq tlist matcher-result)            ;;yes, record match
       (setq throw-out (not (equal tlist matcher-result))))))
                   ;;no, must be same as prev match or throw it all out
   (iter:until throw-out))  ;;try rest of literals

;;Now, we think we have the tlist for this operator, but is it a valid
;; tlist (ie does it rematch variables or use already bound vars?)
;;(format t "~%tlist: ~s" tlist)
;;(format t "~%throw-out: ~s" throw-out)

   (setq throw-out
    (OR
     throw-out            ;;stay true if already true
     (eq tlist 'Unfound)  ;;nothing was matchable
     (did-match-use-never-match-var-from-control-op tlist)
     (did-match-use-other-than-unbound-vars tlist unbound-vars)
     (did-match-rematch-previously-matched-var tlist blist)))
   (unless throw-out
     (cons tlist (find-tlists shared-literal? (rest each-slave-ops-literals)
                                          (rest each-slave-ops-unbound-vars)
                                          (rest blists)))))))


;;returns true if tlist conflicts with a matching in blists
;; (ie if a variable is assigned a different value in both lists)

(defun did-match-rematch-previously-matched-var (tlist blists)
 (if (find-if #'(lambda (tpair) 
                 (member tpair blists :test #'assignment-conflict))
      tlist)
  T
  nil))

;;Do the two matching pairs input conflict each other?
;;  (ie ((<x> <a>)) and ((<x> <b>)) would conflict)
(defun assignment-conflict (p1 p2)
 (let (
   (firsts-equal  (eq (first  p1) (first  p2)))
   (seconds-equal (eq (second p1) (second p2))))
  (xor firsts-equal seconds-equal)))

;;returns true if something in control-op-never-match-vars was matched with
;;in the blist.  (would be second entry in blist)
 
(defun did-match-use-never-match-var-from-control-op (blist)
 (if (find-if #'(lambda (var) 
                 (member var blist :test #'eq-second-of-pair))
      control-op-never-match-vars)
  T
  nil))

;;returns true if somethings other than an unbound vars was used to
;; match the operator with a shared-literal?

(defun did-match-use-other-than-unbound-vars (blist unbound-vars)
 (if (find-if #'(lambda (bpair)
                 (not (member (first bpair) unbound-vars)))
      blist)
  T
  nil))
;; sees if a variable in any tlist has already been instantiated
;; differently in blist.  THIS IS A BIG PROBLEM.  THERE COULD BE
;; ABIGIOUITY HERE
;; 
;;recursively check to make sure that none of the variables assigned
;; in each tlist have already have already been assigned in the
;; corresponding blist
;;
;; Note: it is okay if the variable has already been assigned in
;;       in blist to the same variable as in tlist.
;;

(defun double-assigned-variable? (tlists blists)
 (unless (null blists)
  (let (
   (tlist (first tlists))
   (blist (first blists)))
  (if 
   (find-if #'(lambda (x) (member x blist 
      :test #'(lambda (x b) (OR (AND (eq (first  x) (first  b))
                                (NOT (eq (second x) (second b))))
                                (AND (eq (second x) (second b))
                                (NOT (eq (first  x) (first  b))))))))

       tlist)
   T
   (double-assigned-variable? (rest tlists) (rest blists))))))


;;TESTER FUNCTION FOR find-bindings-for-all-ops
;;(defun try ()
;;(find-bindings-for-all-ops '(
;;((holding <x>)       ;;each ops literals
;; (clear <w>)
;; (object <w>)
;; (asdf <w>)   )
;;
;;((holding <y>)
;; (clear <v>)
;; (object <z>)  
;; (asdf <t>)   )
;; )
;;
;;'(                        ;;each ops goal vars
;; (<x>)
;; ()
;; )
;;
;;'(                ;;each-slave-ops wild vars
;; nil
;; (<v>)
;; )
;;
;;'(              ;;each ops unbound vars
;; (<w>)
;; (<y> <z> <t>)
;; )
;;
;; ))