;;----------------------------------------------
;; io routines for rules.  There are more of these in main.lisp
;;
;; Author: Oren Etzioni
;;----------------------------------------------


;;------------
;; write-rules
; could just glom them onto one big list and write
; it out whole. Might make reading it back better.
; notice that reading and writing each reverse order,
; so we get the result that rules are eventually in same order.
(defun write-rules (file-nm)
  (with-open-file (prt file-nm :direction :output :if-exists :append
                       :if-does-not-exist :create)
    (g-loop (init *SAVED-RULES* nil tmp-rules *LEARNED-RULES-IN-SYS* nm nil
                new-nm nil count 0)
          (before-starting
          (princ "(setq *SAVED-RULES* (quote " prt))
          (while (setq nm (pop tmp-rules)))
          (do (setq count (+ 1 count))
              (setq new-nm (intern (concatenate
                                    'string "sr" (prin1-to-string count))))
              (push `(,new-nm
                      (lhs ,(get nm 'lhs))
                      (rhs ,(get nm 'rhs))
                      (unique-sig ,(get nm 'unique-sig))
                      (problem ,(get nm 'problem))
                    (training-ex ,(nodes-to-names (get nm 'training-ex)))
                      (was-learned t)
                      (lhs-for-ebs ,(get nm 'lhs-for-ebs))
                      (est-cost ,(get nm 'est-cost))
                      (est-savings ,(get nm 'est-savings))
                      (cum-savings ,(get nm 'cum-savings))
                      (match-time ,(get nm 'match-time))
                      (priority 0))
                 *SAVED-RULES*))
          (before-returning
              (progn (pprint *SAVED-RULES* prt)
                     (princ "))" prt)))
       (result t))))


(defun nodes-to-names (exp)
  (cond ((null exp) nil)
        ((atom exp) (if (typep exp 'node) (node-name exp) exp))
        (t (mapcar #'nodes-to-names exp))))




(defun read-rules (file-nm)
  (if (not (load file-nm :if-does-not-exist nil))
      (format t "~%File ~a not found" file-nm)
    (cond ((intersectq *LEARNED-RULES* (mapcar #'car *SAVED-RULES*))
           (format t "~%No go, some stored rules already in *LEARNED-RULES*~%")
           nil)
          ((g-loop (init rule-body nil nm nil count 0)
                   (while (setq rule-body (pop *SAVED-RULES*)))
                   (do (setq nm (pop rule-body))
                       (g-map (at-val in rule-body)
                          (do (setf (get nm (car at-val))
                                        (cadr at-val))))
                       (push nm *LEARNED-RULES-IN-SYS*)
                       (push nm *LEARNED-RULES*)
                       (dynamically-add-scr nm)
                       (setq count (+ 1 count)))
                   (before-returning
                    (format t "~%Added ~a stored rules~%" count))
                   (result t))))))
