;; Author: Oren Etzioni
;
; This file contains Orens modifications to the Prodigy engine
; The following functions are redefined here:
;(defun not-equal (a b)
;(defun run ()
;(defun invoke-learning ()
;(defun normalize-scr-for-ebs (rule-nm)
;(defun inter-compress 
;(defun write-rules (file-nm)
;(defun make-rule (nm)
;(defun reorder-rule-plist (plist)

;****************************************************************
(defvar *nodes-expanded-before-ebl* nil)


;(push 'predicate *meta-functions*)
;(push 'is-top-level-node *meta-functions*)

;modified for the variable case to make ebl work.
;;removed: (error "NOT-EQUAL: both args must be constants"))
(defun not-equal (a b)
  (cond ((or (rob-is-var? a)
	     (rob-is-var? b))
	 nil)
	((not (equal a b)))))



; from domain-check.lisp. Added check for 'static.
(defun normalize-scr-for-ebs (rule-nm)
  (cond ((and (get rule-nm 'was-learned)
	      (not (get rule-nm 'static)))
	 (or (get rule-nm 'lhs-for-ebs)
	     (error "normalize-scr: learned rule incomplete"))
	 (setf (get rule-nm 'sig-for-ebs) (get rule-nm 'unique-sig)))
	((member (get rule-nm 'rule-type) '(node-reject node-select))
	 (normalize-node-filter-rule rule-nm))
	((member (get rule-nm 'rule-type) '(goal-reject goal-select))
	 (normalize-goal-filter-rule rule-nm))
	((member (get rule-nm 'rule-type) '(op-reject op-select))
	 (normalize-op-filter-rule rule-nm))
	((member (get rule-nm 'rule-type) '(bindings-reject bindings-select))
	 (normalize-bindings-filter-rule rule-nm))
	((member (get rule-nm 'rule-type) 
		 '(node-pref goal-pref op-pref bindings-pref))
	 nil)
	(t (break))))

; from inter.lisp.  Added check for 'static
(defun inter-compress (d1 d1-sig d1-bindings te match-time est-savings h)
  (g-loop (init rules (or (eval (rule-type-to-rule-lst 
				 (get (car d1-sig) 'rule-type)))
			  (return))
		rule nil d1-eqs (get-top-level-eqs d1) comb-match-time nil
		d2 nil d2-sig nil combined-exp nil stop nil)
	  (while (setq rule (car (pop rules))))
	  (do (setq d2 (get rule 'lhs-for-ebs))
	      (setq d2-sig (get rule 'unique-sig))
	      (if (not (get rule 'static)) ;should be a when.
		  (cond ((null (get rule 'was-learned)))
			((quick-inter-test d1-eqs d1 d2 d1-sig d2-sig)
			 (format t "~%Attempting inter-compress with ~a" rule)
			 (setq combined-exp 
			       (full-inter-compress d1 d2 d1-sig d2-sig))
			 (and combined-exp
			      (setq comb-match-time
				    (passes-inter-test combined-exp
						       d1-bindings (cadr te))))
			 (cond ((equal combined-exp d1)
				(format t "~%no change in exp"))
			       ((null combined-exp)
				(format t "~%Expression reduced to Nil -- hmmm"))			    
			       ((and (not (eq t combined-exp))
				     (eq (car combined-exp) 'or))
				(format t "~%Absolutely no reduction achieved"))
			       ((null comb-match-time)
				(format t "~%combined-exp does not match"))
			       ((and (< comb-match-time (1+ match-time))
				     (< (count-atomics combined-exp)
					(count-atomics d1)))
				(format t "~%PASSES inter-test! ~a ~a" comb-match-time match-time)
				(format t "~%D1: ")
				(pprint d1)
				(format t "~%Combined-exp: ")
				(pprint combined-exp)
				(make-learned-rule-from-inter combined-exp d1-sig te 
							      comb-match-time est-savings h rule)
				(setq stop nil)) 
			       (t (format t "~%FAILS inter-test! ~a ~a" comb-match-time match-time)))))))
	  (until stop)))


(defun write-rules (file-nm)
  (with-open-file (prt file-nm :direction :output :if-exists :supersede
		       :if-does-not-exist :create)
    (g-loop (init *SAVED-RULES* nil tmp-rules *LEARNED-RULES-IN-SYS* nm nil 
		new-nm nil count 0)
	  (before-starting
	   (princ "(setq *SAVED-RULES* (quote " prt))
	  (while (setq nm (pop tmp-rules)))
	  (do (setq count (+ 1 count))
  	      (setq new-nm (intern (concatenate
				    'string "sr"
				    (prin1-to-string count))))
	      (push (cons new-nm (make-rule nm)) *SAVED-RULES*))
	  ; missing priority 0, and training-eg call node-to-names to
	  ; see this look at the original.
	  (before-returning 
	      (progn (pprint *SAVED-RULES* prt)
		     (princ "))" prt)))
	  (result t))))

(defun make-rule (nm)
  (let ((plist (symbol-plist nm))
	prop val)
    (setq plist (reorder-rule-plist plist))
    (iter:iterate
     (iter:for x iter:in plist)
     (iter:for i from 1 to (length plist))
     (if (oddp i)
	 (setq prop x)
       (progn
       (setq val x)
       (iter:collect (list prop val)))))))


; Places the lhs followed by the rhs first in the plist.
; setting the rhs and lhs to T is a sleazy way of telling it what
; the next item it reads is. yuck.

; nodes-to-names function stolen from ebl-top-level gets rid of the #
; in the output!
(defun reorder-rule-plist (plist)
  (let* (
    (lhs-contents (list 'lhs (first (rest (member 'lhs plist)))))
    (rhs-contents (list 'rhs (first (rest (member 'rhs plist)))))
    (result       (remove-if #'(lambda (p) 
                                  (or (equal p 'lhs)
                                      (equal p 'rhs)
                                      (equal p lhs-contents)
                                      (equal p rhs-contents)))
                   plist)))
   `(,@lhs-contents ,@rhs-contents ,@result)))

;; BEFORE MODIFICATION BY ROB SPIGER@WOLF TO REMOVE THE FINALLY
;; FUNCTION.


;;(defun reorder-rule-plist (plist)
;;  (let (
;;	lhs rhs 
;;    lhs-contents rhs-contents)
;;    (iter:iterate
;;     (iter:for a iter:in plist)
;;     (cond 
;;      ((eq a 'lhs) 
;;       (setq lhs t))
;;      (lhs 
;;       (setq lhs nil) (setq lhs-contents (list 'lhs a)))
;;      ((eq a 'rhs) 
;;       (setq rhs t))
;;      (rhs 
;;       (setq rhs nil) (setq rhs-contents (list 'rhs a)))
;;      (t (iter:collect (nodes-to-names a) into result)))
;;     (iter:finally (return `(,@lhs-contents ,@rhs-contents ,@result))))))

   
	 
; Attempt to help ua in sched.
;(defvar my-est 10.0)

;(defun utility-est (h exp est-cost)
;  (if (and (not (get h 'dont-make-rule))
;	   (not (has-funny-preds exp)))
;      (let*  ((tc-nm (car (get h 'te)))
;	      (est-savings (apply (get tc-nm 'savings-estimator) (list h))))
;	(setf (get h 'est-savings) (+ est-savings my-est) )
;	(setf (get h 'est-cost) est-cost)
;	(> est-savings est-cost))))



(defun expand-all ()
  (g-loop (init ns *ALL-NODES*)
	  (while ns)
	  (do (cond ((node-alternatives (car ns))
		     (format t "~%Expanding: ~a~%" (car ns))
		     (cntrl (car ns) '(done))))
	      (cond ((null (node-alternatives (car ns)))
		     (setq ns (cdr ns)))
		    ;; In case alts still exist after rejection.
		    ((node-reject-node-hst (car ns))
		     (setq ns (cdr ns)))
		    )))
;; must re-mark success and failure, and reset candidate goals, since 
;; we've added nodes.
  (reset-candidate-goals (eval 'N1))
  (mark-success-in-tree (eval 'N1))
  (mark-failure-reasons-in-tree (eval 'N1)))


; Bug fixed here by Steve.
(defun dn-and-raise (exp path)
  (g-loop (init commons (find-common-atomics 'or (cdr exp) path)
		exps-with-common nil exps-without-common nil
		init-common nil)
	  (before-starting 
	   (cond ((null commons)(return exp))
		 (t (setq init-common (car commons)))))
	  (next exp (cdr exp))
	  (while exp)
	  (do (cond ((eql t (car exp))) ;  get rid of t's
		    ((member (car commons) (car exp))
		     (push (del-common init-common
				       (car commons) (car exp))
			   exps-with-common)
		     (setq commons (cdr commons)))
		    (t (push (car exp) exps-without-common))))
	  (before-returning (progn (setq exps-with-common
					 (nreverse exps-with-common))
				   (setq exps-without-common
					 (nreverse exps-without-common))))
	  (result (cond ((null exps-without-common) ; none
			 (list 'or init-common
			       (cons 'and exps-with-common)))
			((null (cdr exps-without-common)) ; one
			 (list 'and (car exps-without-common)
			       (list 'or init-common
				     (cons 'and exps-with-common))))
			(t (list 'and (cons 'and exps-without-common)
				 (list 'or init-common
				       (cons 'and
					     exps-with-common))))))))
 

;****************************************************************
; Modified Code for running problems and learning.

; Added (gc) before each problem!
(defun run-all ()
  (g-loop (while *TEST-PROBS*)
	  (do
	   (my-load-next)
	   (when (boundp '*PROB-NM*)
		 (format t "~%PROBLEM: ~a" *PROB-NM*))
	      (add-r-stats (run)))))



(defun my-load-next ()
  (or *TEST-PROBS* (error "no more probs"))
  (let* ((prob (car *test-probs*)))
    (run-problem prob)
    (pop *TEST-PROBS*)))


 
      

; I think (length *all-nodes*) is the same as *node-num*.  Both (when
; ebl is run) include the number of nodes EBL expanded.
(defun add-r-stats (final-node)
  (setq *RESULTS* 
	(cons (cond (final-node
		     (list
		       *prob-nm*
		       (round (/ (- *STOP-TIME* *START-TIME*) 
				 internal-time-units-per-second))
		       (length *ALL-NODES*) ;includes gi nodes!
		       (length (find-op-seq (node-parent final-node)))
;		       *nodes-expanded-before-ebl*
;		       (secondify *indiv-ltime*)
		       ))
		    (t 
		     (list 
		       *prob-nm*
		       (round (/ (- *STOP-TIME* *START-TIME*) 
				 internal-time-units-per-second))
		       (length *ALL-NODES*)
		       'not-solved
;		       0
		       )))
	      *RESULTS*)))

(defun run-test-problem (n)
  (let ((x *gc-before-run*))
    (run-problem (nth (1- n) *test-probs*))
    (setq *gc-before-run* nil)
    (run)
    (setq *gc-before-run* x)))


(defun run-problem (prob)
  (let* (
	 (goal (second prob))
	 (state (third prob))
	 )
    (setq *PROB-NM* (car prob))
    (load-goal goal)
    (load-start-state state)
    (when (assoc 'last-time *START-STATE*)
	  (setq *END-TIME* (cadr (assoc 'last-time *START-STATE*)))))
    )



;To call EBL only when the run is successful! Can't toggle the flag
;before and turn it on after, because the recording of time for
;control rules is only done if the flag is on!
; Below removed from preconds of invoke-learning because of Dan's
; protection macro.
;;	       (> *max-time* *time-counter*)) ;o.w. incomplete tree! 

(defun run ()
  (declare (special *ptime* *OP-TRACING* *SCR-TRACING* *VAR-COUNTER*
		    *GC-BEFORE-RUN*)
	   (fixnum *VAR-COUNTER*))
  (if (and (boundp '*ACTIVATE-EBL*) *ACTIVATE-EBL*)
      (if *EBL-FLAG*
	  (reset-obs)
	(error "ERROR: *EBL-FLAG* is NIL.  Reload EBL system")))
  (if (and *CURRENT-PROBLEM-SET* (boundp '*PROB-NM*)) 
      (format t "PROBLEM: ~a" *PROB-NM*))
  (reclaim *GC-BEFORE-RUN*)
  (print-initial-info)
  (setq *START-TIME* (get-internal-run-time))
  (setf *MAX-TIME* (+ (* internal-time-units-per-second
			 *PRODIGY-TIME-BOUND*)
		      *START-TIME*))
  (setq *EXPLAIN-MATCH-FAILURES* nil *MATCH-EXPLANATION* nil)
					; For explanation
  (setq *HALT-PROBLEM-SOLVER* nil)
  (setq *NODE-PREF-GRAPH* nil)
  (setq *ALL-NODES* nil)
  (setf *VAR-COUNTER* 0)
  (setq *NODE-NUM* 0)
  (setq *STATE-NUM* 0)
  (setq *SUB-STATE-NUM* 0)
  (setq *MATCHER-TRACE* nil)
  (setq *TRACING-TURNED-ON* (or *OP-TRACING* *SCR-TRACING*))
  (setq *INFERENCES-ONLY* nil) 
					; for search control rules, tested in matcher
  (let ((final-node (cntrl (initialize-start-node) '(done))))
    (cond (final-node (print-success))
	  (t (print-failure)))
    (setq *STOP-TIME* (get-internal-run-time))
    (setq *ptime* (+ *ptime* (- *stop-time* *start-time*)))
    (if (null *ABSTRACTION-LEVEL*)(print-final-stats final-node))
    (if (and (boundp '*ACTIVATE-EBL*) *ACTIVATE-EBL*)
	(protect-and-save-data (invoke-learning)
			       :filename "/usr/etzi/prodigy/ebl-errs"
			       :extra-data *prob-nm*
			       ))
    final-node))

(defun invoke-learning ()
  (let ((iua-time nil)
	)
    (setq *nodes-expanded-before-ebl* *node-num*) 
    (cond (*MACRO-LEARNING* 
	   (format t "Mac-sequence:")
	   (print-mac-sequence 10 (node-solution (eval 'N1)))))
    (setq iua-time (get-internal-run-time))
    (utility-validation)
    (setq *ua-time* (+ *ua-time* (- (get-internal-run-time)
				    iua-time)))
    (show-times)
    (if (not *MACRO-LEARNING*) (ex-aux-commands))
    (if *EXPAND-ALL* (expand-all))
    (cond (*MACRO-LEARNING*
	   (and (first-succ-node)	; there was a success
		(o2 n2)))
	  ;; Make sure there is an n2!
	  ((not (node-children n1)) nil)
	  (t
	     (o2 n2)
	     (when (node-lstart-time n1)
		   (setq *indiv-ltime* (- (node-lstop-time n1)
					  (node-lstart-time n1)))
		   (setq *ltime* (+ *ltime* *indiv-ltime*)))
	     (when (node-estart-time n1)	     
		   (setq *gi-time* (+ *gi-time*
				      (- (node-estop-time n1)
					 (node-estart-time n1)))))
	     ))
    (backup-times)			
    (cond (*MACRO-LEARNING* (load-new-macs))
	  (t (load-new-scrs)))
    (reset-obs)))

; Done to avoid crashing the experiments by accidental typing.
(defun check-for-interesting-input ()
  )
