;;****************************************************************
;;****************************************************************
;;
;; STATIC V2.0
;; by:   Oren Etzioni, Julie Roomy, Rob Spiger.
;; 
;; date: 16 Dec 1991
;;
;; SYSTEM BOOT FILE.
;;
;; MODS:
;; This load file is updated to work without package conflicts.
;; This load file may accept interactive input.
;; (currently hardwired)
;;
;;****************************************************************
;;****************************************************************

;;; SET PATHS - change the path names of system components here!
;;; Be careful with relative pathnames!  It is wise to use explicit
;;; pathnames here.

(setf PRODIGY-PATH "/projects/ai/prodigy/system/planner/")
(setf ITERATE-PATH "/projects/ai/static/rob/iterate/")
(setf LOCAL-PATH "/projects/ai/static/rob/")


;;; functions for compiling and loading (possibly updated) files

(defun newer-source? (path)
  (let* ((bin-name (make-pathname
                     :type 
                       (if (equal (machine-type) "SPARC")
                           "sfasl4"
                           "fasl4")
		    :defaults path))
	 (file (probe-file bin-name)))
    (or (not file) 
	(< (file-write-date file)
	   (file-write-date (make-pathname :type "lisp" :defaults
					   path))))))

(defun cload-helper (path)
  (let ((bin-name (make-pathname
		   :type (if (equal (machine-type) "SPARC")
					 "sfasl4"
					 "fasl4") 
		   :defaults path)))
    (if (newer-source? path)
	(progn (compile-file path :output-file bin-name)
	       (load bin-name))
      (load bin-name))))

(defun cload (path file)
  (cload-helper (concatenate 'string path file)))


;;; load iterate package (and avoid package conflicts)

(cload ITERATE-PATH "new-iterate") ;iterate

;;; load PRODIGY

(load (concatenate 'string PRODIGY-PATH "startup.lisp"))

;;; load local files
(cload LOCAL-PATH "main/data-structures.lisp") ;;;  general files
(cload LOCAL-PATH "main/globals.lisp")
(cload LOCAL-PATH "main/main.lisp")
(cload LOCAL-PATH "main/old-simplifier-stuff")
;; should be loaded after prodigy.
(cload LOCAL-PATH "main/mods.lisp")	      ;;; modifications to prodigy
(cload LOCAL-PATH "main/mods2.lisp")          ;;load fix to prodigy



(cload LOCAL-PATH "io/io.lisp")               ;;; io files
(cload LOCAL-PATH "io/psgraph.lisp")

(cload LOCAL-PATH "create/craig-match.lisp")  ;;; create the psgs
(cload LOCAL-PATH "create/bindings.lisp")
(cload LOCAL-PATH "create/random.lisp")
(cload LOCAL-PATH "create/create-PSG.lisp")
(cload LOCAL-PATH "create/domain.lisp")

(cload LOCAL-PATH "label/label-PSG.lisp")     ;;; label the psgs
(cload LOCAL-PATH "label/label-utils.lisp")   ;;; utility functions for labels

(cload LOCAL-PATH "rules/rules.lisp")         ;;; form rules based on failure
(cload LOCAL-PATH "rules/failure.lisp")       ;;; and success
(cload LOCAL-PATH "rules/suc.lisp")
(cload LOCAL-PATH "rules/io.lisp")
(cload LOCAL-PATH "rules/ebl-normalize.lisp")

(cload LOCAL-PATH "effects/effects.lisp")     ;;find the necessary effects
(cload LOCAL-PATH "general/general.lisp")     ;;general functions used lots
(cload LOCAL-PATH "general/rob-match.lisp")   ;;custom matching functions 

(cload LOCAL-PATH "shared-literals/shared-literals.lisp") ;;finds shareable-lits

(cload LOCAL-PATH "preprocess/preprocess.lisp")  ;;preprocesses domain

(cload LOCAL-PATH "effects/rob-rules.lisp") ;; Rule generation

(cload LOCAL-PATH "rob-simplify/rob-simplify.lisp") ;;The simplifier.
(cload LOCAL-PATH "rob-simplify/var-typing.lisp")   ;;typing information
(cload LOCAL-PATH "rob-simplify/rob-bindings.lisp") ;;typing information

(cload LOCAL-PATH "testing-code.lisp")

;;---------------------------
;;Do (gc t) automatically when free memory is low.
;;---------------------------

(defvar *gct-reset* 1200000 "reset value for gct-bytes")
(defvar *gct-bytes* *gct-reset* "when this goes to 0, it's time for a
 (gc t)")

; reestablish the default which was munged in my diskimage.
(setf (sys:gsgc-switch :auto-step) t)

(defun gc-after-check
  (global-p new-bytes tenured-bytes rate &rest more)
  (declare (ignore new-bytes rate more))
  (when global-p (return-from gc-after-check))
  (setq *gct-bytes* (- *gct-bytes* tenured-bytes))
  (when (<= *gct-bytes* 0)
        (setf (sys:gsgc-switch :next-gc-is-global) t)
        (setq *gct-bytes* *gct-reset*))
  nil)

(setf (sys:gsgc-switch :hook-after-gc) t)
(setf excl:*gc-after-hook* 'gc-after-check)

















