;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;-------------------------------------------------------------------

;;inverts an expression.  (even if its inverted)
;;
(defun negate-exp (exp)
 (cond
  ((eq exp t) 
   nil)
  ((null exp)
   t)
  ((eq (first exp) '~)
   (first (rest exp)))
  (t 
   `(~ ,exp))))
 
(defun childless-node? (node)
  (cond
    ((internalnode-p node)
      (if (null (internalnode-operands node))
       t
       nil))
    ((operator-p node)
      (if (null (operator-preconditions node))
       t
       nil))
    ((literal-p node)
      (if (null (literal-operators node))
       t
       nil))))


;; Instantiates an arbitrary expression with the bindings in Blist.
;;  Blist has form of variables paired together like:
;;    ((a b) (c d))
;;  Will replace every instance of a with b
;;           and every instance of c with d.
;;
(defun instantiate (exp Blist)
 (unless (null exp)
 (if (atom exp)
  (let ((bpair 
        (find-if #'(lambda (bpair) (equal (first bpair) exp)) Blist)))
   (if bpair
    (second bpair)
    exp))
  (mapcar #'(lambda (sub-exp) (instantiate sub-exp Blist)) exp))))

;;  Returns a list of the variables in any arbitray expression
;;  Output is like ((<x>) (<y>))
(defun find-variables (exp)
 (setq variables-found nil)
 (find-variables-with-duplicates exp)
 (remove-duplicates variables-found))

(defun find-variables-with-duplicates (exp)
 (if (atom exp)
  (if (rob-is-var? exp)
   (setq variables-found (cons exp variables-found)))
 (mapcar #'find-variables-with-duplicates exp)))

(defun find-existential-variables (exp)
 (let (
   (vars (find-variables exp)))
  (remove-if-not #'existential-var? vars)))

(defun find-variables-which-occur-once (exp)
 (setq variables-found nil)
 (find-variables-with-duplicates exp)
 (let* (
   (all-vars  variables-found)
   (vars      (remove-duplicates all-vars :test #'eq))
   (once-vars (remove-if #'(lambda (x)
                            (member-twice x all-vars))
               all-vars)))
  once-vars))

(defun member-twice (x some-list)
 (if (member x (rest (member x some-list)))
  T
  nil))

;; Returns the subgoalable possibly negated atomic formulas in an 
;;  arbitrary expression.  
;;
;; DOES NOT ASSUME STATIC GENERATORS FOR FORALL STATEMENTS
;; DOES NOT ASSUME STATIC GENERATORS FOR EXISTS STATEMENTS
;;
(defun subgoalable-literals (exp)
 (remove-duplicates 
  (sub-subgoalable-literals exp)
  :test #'equal))

(defun sub-subgoalable-literals (exp)
 (unless (OR (null exp) (atom exp))
  (let ((keyword (first exp)))
   (cond
    ((atomic-formula? exp)
     (list exp))
    ((OR (equal keyword 'NOT) (equal keyword '~))
     (if (AND (equal (length exp) '2) (atomic-formula? (second exp)))
      (list exp)
      (sub-subgoalable-literals (negate-sentence (second exp)))))
    ((OR (equal keyword 'AND) (equal keyword 'OR))
     (apply #'append (mapcar #'sub-subgoalable-literals (rest exp))))
    ((equal keyword 'EXISTS)
     (append (sub-subgoalable-literals (third exp))
             (when (= (length exp) 4) (sub-subgoalable-literals (fourth exp)))))
    ((equal keyword 'FORALL)
     (append (sub-subgoalable-literals (negate-sentence (third exp)))
             (sub-subgoalable-literals (fourth exp))))
    (t (print
		'error-unsuitable-exp-for-func-subgoalable-literals))))))

;;Will return true only if an expression is static.


(defun is-static-exp (exp)
 (let (
   (subgoals (subgoalable-literals exp)))
  (if (find-if #'is-not-static-pred subgoals)
   nil
   t)))

(defun is-not-static-pred (pred)
 (not (is-static-pred pred))) 

(defun is-static-pred (pred)
 (when (eq (first pred) '~) (setq pred (second pred)))
 (setq pred (first pred))
 (if (member pred *static-preds*)
  t
  nil))

(defun is-static-pred-and-not-meta-func (pred)
 (let (
   (pred (predicate-name pred)))
  (AND (member pred *static-preds*)
       (not (member pred *meta-functions*)))))
      
   
   

(defun is-open-world-pred (pred)
 (when (eq (first pred) '~) (setq pred (second pred)))
 (setq pred (first pred))
 (if (and
      (not (member pred *closed-preds*))
      (not (member pred *static-preds*)));;this line is an extra mod
  t
  nil))

(defun is-open-or-static (pred)
 (OR (is-static-pred pred)
     (is-open-world-pred pred)))

(defun negate-sentence (exp)
 (if (atom exp)
  (cond
   ((equal exp 'OR) 'AND)
   ((equal exp 'AND) 'OR)
   ((equal exp T) 'nil)
   ((equal exp 'nil) T)
   (t (print 'bad-sentence-error)))
  (let ((keyword (first exp)))
   (cond 
    ((atomic-formula? exp) 
     (negate-exp exp)) ;;mod
    ((equal keyword 'AND)
     (mapcar #'negate-sentence exp))
    ((equal keyword 'OR)
     (mapcar #'negate-sentence exp))
    ((equal keyword 'NOT)
     (second exp))
    ((equal keyword '~)
     (second exp))
    ((equal keyword 'EXISTS)
     (if (equal (length exp) 4)
     `(FORALL ,(second exp) ,(third exp) ,(negate-sentence (fourth
														   exp)))
     `(FORALL ,(second exp) ,(third exp) ,(negate-sentence
                                             (third exp)))))
    ((equal keyword 'FORALL)
     `(EXISTS ,(second exp) ,(third exp) ,(negate-sentence (fourth
														   exp))))
	(t (print 'unknown-sentence-for-negate-sentence))))))


(defun atomic-formula? (exp)
;; (unless (atom exp))
 (if (and (atom exp) (not (member exp '(AND OR EXISTS FORALL))))
  t
 (unless (atom exp)
  (let (
    (keyword (predicate-name exp)))
   (unless (member keyword 
           '(AND OR EXISTS FORALL))
    T)))))d

;;KILL BELOW
;;(defun find-ops-wildcards (op)
;; (let ((params-var  (find-variables (second op)))
;;       (effects-var (find-variables (fourth op))))
;;  (remove-if #'(lambda (var) (member var params-var)) effects-var)))
;;Output   : Returns a list of the variables which are wildcards in the
;;           operator.  More specifically, it returns any variable which is
;;           present anywhere in the effects clause of the operator and isn't
;;           present in the params list of the operator.
;;KILL ABOVE

;; takes in a blist and swaps the pair in it.
;;  ie (a b) becomes (b a)
(defun reverse-blist (blist)
 (if (eq blist 'No-match)
  'no-match
 (mapcar #'(lambda (x) `(,(second x) ,(first x))) blist)))


;; Takes in a list of variables like (<obj> <underobj>)
;;  and returns a unique binding for everything in the list
;;  like ((<obj> <v1>) (<underobj> <v2>))
;;
;; 
(defun make-new-blist (variables)
 (mapcar #'(lambda (variable) `(,variable ,(generate-random-var)))
		 variables))

(defun make-new-same-kind-blist (variables)
 (mapcar #'(lambda (variable) `(,variable 
                                ,(make-new-same-kind-variable variable)))
		 variables))

(defun make-new-same-kind-variable (x)
 (cond
  ((wild-var? x)   (generate-random-wild-card))
  ((normal-var? x) (generate-random-var))
  ((exists-var? x) (generate-random-exists))
  ((forall-var? x) (generate-random-forall))
  ((goal-var?   x) (constant-into-variable (generate-goal-const)))
  (t (format t "~%Error unknown variable type given to function")
     (format t "~% make-new-same-kind-variable!"))))


;; Takes in a list of variables like (<obj> <underobj>)
;;  and returns a unique binding for everything in the list
;;  like ((<*obj> <w1>) (<*underobj> <w2>))
;;
;; 
(defun make-new-wild-blist (variables)
 (mapcar #'(lambda (variable) `(,variable ,(generate-random-wild-card)))
		 variables))

;; Takes in a list of variables like (<obj> <underobj>)
;;  and returns a unique binding for everything in the list
;;  like ((<obj> <v1>) (<underobj> <v2>))
;;
;; This version is specifically for making variables for EXISTS and
;; FORALL params in operotors.  Exists variables start with E.
;;  Forall varaiables start with F.
;;
;; keyword = 'EXISTS or 'FORALL
(defun make-new-blist-fe (variables keyword)
 (cond
  ((eq keyword 'EXISTS)
   (mapcar #'(lambda (variable) `(,variable ,(generate-random-exists)))
  		   variables))
  ((eq keyword 'ACTIVE)
   (mapcar #'(lambda (variable) `(,variable
								  ,(generate-random-active)))
           variables))
  ((eq keyword 'FORALL)
   (mapcar #'(lambda (variable) `(,variable ,(generate-random-forall)))
  		   variables))))


;;
;; Remove those variables from the variables which are
;;  already present in the binding list blist.
;;
(defun remove-already-used-var (variables blist)
  (remove-if #'(lambda (v) (member v blist 
                     :test #'(lambda (v bpair) (OR
                      (eq v (first bpair))
                      (eq v (second bpair))))))
	  variables))

;;KILL BELOW
;;(defun nice-union-match-var-to-var-only (list-to-union)
;; (cond
;;  ((null list-to-union) nil)
;;  ((= 1 (length list-to-union)) (first list-to-union))
;;  (t (nice-union-match-var-to-var-only (cons 
;;       (union (first list-to-union)
;;              (second list-to-union) :test #'match-var-to-var-only)
;;       (rest (rest list-to-union)))))))      
;; KILL ABOVE

;; Returns the name of the predicate.
;; Takes in NEGATED and non-negated predicates.
;; Saves some hassle about getting the predicate name if it's
;;  a negated predicate.
;;
(defun predicate-name (pred)
 (unless (or (null pred) (atom pred))
  (if (eq '~ (first pred))
   (first (second pred))
   (first pred))))


(defun n-mapcar (n-input-function &rest inputs)
 (unless (null (first inputs))
  (cons (apply    n-input-function (mapcar #'first inputs)) 
        (apply #'n-mapcar `(,n-input-function ,@(mapcar #'rest
														inputs))))))

(defun equal-first-of-pair (x pair)
 (equal x (first pair)))

(defun eq-first-of-pair (x pair)
 (eq x (first pair)))

(defun eq-second-of-pair (y pair)
 (eq y (second pair)))



(defun xor (x y)
 (OR (AND x (not y))
     (AND (not x) y)))

(defun existential-var? (var)
 (OR (normal-var? var) (exists-var? var)))

(defun universal-var? (var)
 (OR (forall-var? var) (wild-var?   var)))

;;finds the static predicates which are ANDed in this node

(defun find-anded-static-preds-for-node (keyword operands)
 (unless (eq keyword 'EXISTS)
  (unless (eq keyword 'FORALL)
   (let* (
     (exp     `(,keyword ,@operands))

;;
;;     (exp      (rob-simplify exp 'No-sub))
;; Simplifier will sometimes simplify too well, making the entire
;; expression false.  This makes us loose the generators.  Simplifing
;; can be done if one stops the simplifier from putting nil in for
;; everything on the false list.   This was not implemented.

     (keyword  (first exp))
     (operands (rest exp)))
    (if (eq 'AND keyword)
     (remove-if-not #'is-static-pred operands)
     (unless (atom keyword)
      (when (is-static-pred keyword)
       (list keyword))))))))

;;Also returns them in order in which they occur in the expression.  This is
;; important for some function which call this routine.  Should not be changed.
;;
;; For example, (find-anded-static-preds-in-exp '(AND (is-key <key> <door>) (is-door <door2>)))
;; will return ((is-key <key> <door>) (is-door <door2>)) in that order.

;;
;;Does not analyze sub-expressions.

(defun find-anded-static-preds-in-exp (exp)
 (unless (eq exp t)
  (find-anded-static-preds-for-node (first exp) (rest exp))))
 
 
(defun get-pred (predicate)
 (if (eq '~ (first predicate))
  (first (second predicate))
  (first predicate)))


(defun has-duplicate (alist)
 (let (
   (blist (remove-duplicates alist)))
  (not (equal alist blist))))

(defun has-duplicate-with-test (alist test-function)
 (let (
   (blist (remove-duplicates alist :test test-function)))
  (not (equal alist blist))))

(defun make-all-goal-consts-into-vars (exp)
 (let* (
   (goal-consts (find-goal-consts exp))
   (blist       (mapcar #'(lambda (x) 
                  `(,x ,(constant-into-variable x)))
                 goal-consts)))
  (instantiate exp blist)))

;;  Returns a list of the goal variables in any arbitray expression
;;  Output is like ((<x>) (<y>))
(defun find-goal-consts (exp)
 (setq variables-found nil)
 (find-goal-consts-with-duplicates exp)
 (remove-duplicates variables-found))

(defun find-goal-consts-with-duplicates (exp)
 (if (atom exp)
  (if (goal-const? exp)
   (setq variables-found (cons exp variables-found)))
 (mapcar #'find-goal-consts-with-duplicates exp)))

   
;;returns true if set1 is a subset of set2
;;
(defun is-subset (set1 set2)
 (unless (find-if #'(lambda (e1) (not (member e1 set2 :test #'equal))) set1)
  T))

;;returns the number of atomic formulas in an expression.
;;counts duplicates twice.
;; Is used primarily for calculating complexity of
;;  control rules.

(defun number-of-atomic-formula-in-exp (exp)
 (cond
  ((atom exp) '0) ;;don't count keywords
  ((atomic-formula? exp) '1)
  (t (apply #'+ (mapcar #'number-of-atomic-formula-in-exp exp)))))

(defun rule-complexity (sc-rule) 
 (let* (
   (lhs             (second (second sc-rule)))
   (known-predicate (remove-if-not #'(lambda (atomic)
                                      (eq (predicate-name atomic)
                                          'known))
                     lhs))
   (exp             (when known-predicate (third (first known-predicate)))))
  (number-of-atomic-formula-in-exp exp)))

;;returns true if set1 equal set2 
;; true if set1 is a subset of set2 and set2 is a subset of set1
(defun set-equality (set1 set2)
  (AND (is-subset set1 set2)
       (is-subset set2 set1)))


;;returns true if the two sets are equal
;;(defun set-equality (set1 set2)
;; (if (and
;;      (null set1)
;;      (null set2))
;;  t
;;  (unless (OR 
;;           (null set1)
;;           (null set2))
;;   (set-equality 
;;    (rest set1) 
;;    (remove-if #'(lambda (x) (equal x (first set1))) set2)))))

(defun subsets (x)
 (sort 
  (remove-duplicates 
   (cons nil (sub-subsets x))
   :test #'equal)
  #'(lambda (x y) (< (length x) (length y)))))

(defun sub-subsets (x)
 (cond
  ((null x) 
   nil)
  ((listp x)
   (cons x (remove-if 
            #'(lambda (a)
               (not a))
            (mapcan #'(lambda (y) 
                      (sub-subsets 
                       (remove-if #'
                        (lambda (z)
                         (equal z y))
                        x)))
                  x))))))


(defvar *all-possible-pairings* nil)

(defun all-possible-pairings (lista listb)
 (setq *all-possible-pairings* nil)
 (union lista listb :test #'sub-all-possible-pairings)
 (reverse
  (remove-duplicates *all-possible-pairings* 
                     :test #'equal)))

(defun sub-all-possible-pairings (a b)
 (setq *all-possible-pairings*
  (cons `(,a ,b) *all-possible-pairings*))
 nil)


;;Returns T if a variable other than the type of 
;; goal variable is in the blist.
;;Returns nil if the blist only contains goal variables and
;; constants.  Also returns nil if the blist= 'no-match

(defun non-goal-or-wild-var-in-blist (blist)
 (unless (eq blist 'no-match)
  (find-if #'(lambda (var) (and (not (wild-var? var)) (not (goal-var? var))))
   (find-variables blist))))
