
;;-------------------------------------------------------------------
;;-  Author        :  Rob Spiger 
;;- Sponsoring Prof:  Oren Etzioni
;;-    Date        :  2/9/93
;;- See effects.doc for documentation
;;-------------------------------------------------------------------



;;Things to yet to do

;;Need check handling of operators with no preconditions.

;;For more documentation see effects.doc

;;----------------
;; find-ne-of-roots
(defun find-ne-of-roots (*roots*)
 (iter:iterate
 (iter:for root in *roots*)
  (find-ne-of-root root)
  (generally-simplify-ne-of-root root)))

(defun find-ne-of-root (root)
 (setf (literal-necessary-effects root)
  (remove-if-pred-is-open-or-static
   (if (childless-node? root)
    `((,(literal-name root) T nil))
    (let* (
      (each-ops-effects (mapcar #'find-ne-of-node(literal-operators root)))
      (arisal-cond      (if (literal-bad-bindings root) 
                            `(AND ,@(blist-to-noteqlist 
                                                  (literal-bad-bindings root)))
                            't))
;;bad-bindingsl list hold bindings that must not occur if operators used are
;; guaranteed to actually be used.  So these bad-binding are put into a list which 
;; is true only when none of the bad-bindings occur.  This conditional is added to the
;; conditional of each necessary effects which arise from subgoaling on the literal
;; when the subgoaling assumes that the bindings do not take place.

     (all-ops-effects  (apply #'effects-intersection each-ops-effects)))
    (and-cond-to-ne arisal-cond all-ops-effects))))))



(defun find-ne-of-node (node)

 (cond
  ((null node) nil)
  ((literal-p node) (find-ne-of-literal-node node))
  ((operator-p node) (find-ne-of-operator-node node))
  ((internalnode-p node) (find-ne-of-internal-node node))
  (t (format t "~%***Unknown node given to find-ne.***~%"))))


(defun find-ne-of-literal-node (node)
 (if (not (null (literal-necessary-effects node)))
  (literal-necessary-effects node)
  (progn
   (setf (literal-necessary-effects node)
   (remove-if-pred-is-open-or-static
   (if (childless-node? node)
    `((,(literal-name node) T nil))          ;;leaf on PSG
    (let* (                             ;;not leaf on PSG
      (each-ops-effects (mapcar #'find-ne-of-node(literal-operators node)))
      (negated-lit      (negate-exp (literal-name node)))
      (arisal-cond      (if (literal-bad-bindings node) 
                            `(AND ,negated-lit ,@(blist-to-noteqlist 
                                                  (literal-bad-bindings node)))
                            negated-lit))
;;bad-bindingsl list hold bindings that must no occur if operators used are
;; guaranteed to actually be used.  So these bad-binding are put into a list which 
;; is true only when none of the bad-bindings occur.  This conditional is added to the
;; conditional of each necessary effects which arise from subgoaling on the literal
;; when the subgoaling assumes that the bindings do not take place.

      (all-ops-effects  (apply #'effects-intersection each-ops-effects)))
     (and-cond-to-ne arisal-cond all-ops-effects)
	 )))))))


;;Note that gen in this function when the node is a forall node is the negation of the generator.
;; When the node is an exists node, gen is the generator (not negated).
(defun find-ne-of-internal-node (node &aux 
                                 (keyword  (internalnode-name node))
                                 (operands (internalnode-operands node))
                                 (params   (internalnode-params node))
                                 (gen      (internalnode-generator node))
                                 (f-exp    (internalnode-f-expression node)))
 (setf (internalnode-necessary-effects node)
 (remove-if-pred-is-open-or-static
 (cond
  ((eq keyword 'OR)
   (apply #'effects-intersection (mapcar #'find-ne-of-node operands)))
  ((eq keyword 'AND)
   (add-extra-existential-variable-info node 
    (apply #'effects-union (mapcar #'find-ne-of-node operands))))
  (t                                     ;;must be FORALL or EXISTS
   (let* (
     (static-gen   (is-static-exp gen))
     (g-inverse-f  (equal gen f-exp))
     (no-kids-ne   (AND (not static-gen) (not g-inverse-f)))
     (ne-of-gen    (when (eq keyword 'EXISTS) (find-ne-of-node(first operands))))
     (ne-of-f-exp  (unless no-kids-ne (find-ne-of-node(second operands)))))
    (cond
     ((eq keyword 'EXISTS)   ;;g-inverse-f of is not a valid value in case of exists because
                             ;; gen is not the generator negated.
      (effects-union (and-cond-to-ne gen   ne-of-gen)  
                     ne-of-f-exp))
     ((eq keyword 'FORALL)
      (if (OR static-gen g-inverse-f)
       (and-cond-to-ne (negate-sentence gen) ne-of-f-exp)
       (progn
;;        (format t "~%WARNING: non-static generator in forall or")
;;        (format t "~%negated exists statement of: ~s" gen)
        (apply #'effects-intersection (mapcar #'find-ne-of-node operands))  )))
                      ;;take the intersection of ~G and f-exp necessary effects.

     (t (format t "~%ERROR: unknown node type for node ~s" node)
        nil))))))))

;;
(defun add-extra-existential-variable-info (node nes &aux
            (anded-static-preds (internalnode-anded-static-preds node))
            (preds-vars         (mapcar #'(lambda (pred) 
                                   `(,pred 
                                     ,(find-existential-variables pred)))
                                 anded-static-preds)))
 (iter:iterate
 (iter:for ne in nes)
  (let* (
    (ne-vars          (find-existential-variables ne))
    (applicable-preds (iter:iterate     ;;those preds whose vars overlap the ne
                      (iter:for pred-vars iter:in preds-vars)
                       (when (intersection ne-vars (second pred-vars)
                                      :test #'eq)
                        (iter:collect (first pred-vars))))))
   (iter:collect 
    (if applicable-preds
	 `(,(first ne) ,(second ne) ,(union 
               (third ne) applicable-preds :test #'equal))
     ne)))))

;;del effects happen first, then add effects.


(defun find-ne-of-operator-node (node)
(if (not (null (operator-necessary-effects node)))
 (operator-necessary-effects node)
 (progn
 (setf (operator-necessary-effects node)
  (simplify-ne 
  (remove-if-pred-is-open-or-static
   (let* (
     (preconds-ne       (find-ne-of-node(operator-preconditions node)))
     (ops-effects       (operator-effects node))
     (ops-del-effects   (remove-if-not #'(lambda (x) 
                           (eq '~ (first (first x)))) ops-effects))
     (ops-add-effects   (remove-if     #'(lambda (x)
                           (eq '~ (first (first x)))) ops-effects))
     (ops-add-ne  (mapcar #'(lambda (x) 
                          `(,(first x) ,(second x) nil)) ops-add-effects))
     (ops-add-ne  (add-extra-existential-variable-info
                         (operator-preconditions node)
						 ops-add-ne))
     (ops-del-ne  (mapcar #'(lambda (x) 
                          `(,(first x) ,(second x) nil)) ops-del-effects))
     (ops-del-ne  (add-extra-existential-variable-info
                         (operator-preconditions node)
                         ops-del-ne)))
;;(format t "~%operator: ~s" (operator-name node))
;;(format t "~%ops-add-effect: ~s" ops-add-ne)  
    (add-extra-existential-variable-info 
              (operator-preconditions node) 
     (effects-union ops-add-ne
      (remove-effected-precond-ne ops-add-effects
       (effects-union ops-del-ne
        (remove-effected-precond-ne ops-del-effects preconds-ne))))))))))))



(defun remove-effected-precond-ne (ops-effects preconds-ne)
 (iter:iterate
 (iter:for precond-ne in preconds-ne)
  (let (
    (precond-pred (first  precond-ne))
    (precond-cond (second precond-ne))
    (precond-gen  (third  precond-ne)))
   (mapcar #'(lambda (op-effect)
;;(format t "~%precond-ne ~s" precond-ne)
;;(format t "~%op-effect: ~s" op-effect)
    (let* (
      (effect-pred (first  op-effect))
      (effect-cond (second op-effect))
      (effect-wild (third  op-effect))
      (blist       (rob-hard-negate-return-blist
                          precond-pred effect-pred))
      (eq-blist    (unless (eq blist 'No-match) (blist-to-eqlist blist)))
      (extra-cond  (unless (eq blist 'No-match) `(OR ,@(mapcar
					#'(lambda (bpair) 
                       (disjunction-for-extra-precond-cond 
                              bpair))
					blist)))))
;;(format t "~%extra-cond ~s" extra-cond)
		(unless (eq blist 'No-match)
         (setq precond-cond 
         `(AND ,precond-cond
               (OR ,extra-cond
                   (AND ,(negate-sentence effect-cond)
                        ,@eq-blist)))))
     (setq precond-cond (rob-simplify precond-cond 'no-sub))))
    ops-effects)
   (when precond-cond             ;;don't collect if false cond
    (iter:collect `(,precond-pred ,precond-cond ,precond-gen))))))



 
;;bpair should be from matching the precond-pred to ~effect-pred
;;  Returns a condition which if true will keep effect-pred from
;;   negating precond-pred

(defun disjunction-for-extra-precond-cond (bpair)
 (let* (
   (pvar          (first  bpair))
   (evar          (second bpair))
   (p-universal   (universal-var? pvar))
   (e-universal   (universal-var? evar))
   (p-constant    (NOT (rob-is-var? pvar)))
   (e-constant    (NOT (rob-is-var? evar)))
   (p-existential (existential-var? pvar))
   (e-existential (existential-var? evar)))
  (cond
   ((AND p-existential e-existential)
    `(not-equal ,pvar ,evar))               ;;case1 in docs
   ((AND p-existential e-universal  )
    nil)                                    ;;case2 in docs
   ((AND p-universal   e-existential) 
    `(not-equal ,pvar ,evar))               ;;case3 in docs
   ((AND p-universal   e-universal  ) 
    nil)                                    ;;case4 in docs
   ((AND p-constant    e-universal  )
    nil)                                    ;;case5 in docs
   ((AND p-constant    e-existential)
;;(    T)                                    ;;what was working before
    `(not-equal ,pvar ,evar))               ;;case6 in docs
   ((AND p-universal   e-constant)
    `(not-equal ,pvar ,evar))               ;;case7 in docs
   ((AND p-existential e-constant)
    `(not-equal ,pvar ,evar))               ;;case8 in docs
   (t (format t "~%Unknown matching disjunction-for-extra-precond-cond")
      t))))

;;effects-intersection takes in two lists of NE and takes their
;; intersection as described in the document NE.
;;
(defun effects-intersection (&rest effectsx)
 (remove-if #'(lambda (x) (null (second x))) 
  (apply #'sub-effects-intersection effectsx)))


(defun sub-effects-intersection (effects1 &rest effectsx)
;;(format t "~%effects1: ~s" effects1)
 (if (null effectsx) effects1          ;;only one list
  (let (
    (effects2 (first  effectsx))
    (ne       nil))
   (iter:iterate
   (iter:for effect1 in effects1) 
    (let (
      (pred1 (first  effect1))
      (cond1 (second effect1))
      (gen1  (third  effect1)))
     (iter:iterate
     (iter:for effect2 in effects2)
      (let* (
        (pred2     (first  effect2))
        (cond2     (second effect2))
        (gen2      (third  effect2))
        (blist     (rob-hard-match pred1 pred2))
        (simplify-result1 (rob-simplify (find-new-cond1 blist cond1
														cond2)))
        (simplify-result2 (rob-simplify (find-new-cond2 blist cond1
                                                        cond2)))
        (new-cond1 (first  simplify-result1))
        (new-cond2 (first  simplify-result2))
        (blist1    (second simplify-result1))
        (blist2    (second simplify-result2))
        (pred1     (instantiate pred1 blist1))
        (pred2     (instantiate pred2 blist2))
        (gen1      (instantiate gen1  blist1))
        (gen2      (instantiate gen2  blist2)))
       (when new-cond1
        (setq ne (cons `(,pred1 ,new-cond1 
                         ,(INTERSECTION gen1 gen2 :test #'equal)) ne)))
       (when new-cond2
        (setq ne (cons `(,pred2 ,new-cond2
                         ,(INTERSECTION gen1 gen2 :test #'equal)) ne)))))))
    (if (null (rest effectsx))
    ne
    (apply #'sub-effects-intersection (append (list ne) (rest effectsx)))))))


(defun find-new-cond1 (blist cond1 cond2)
 (unless (eq blist 'No-match)
  (if (null blist)
   `(AND ,cond1 ,cond2)
    (let* (
      (cond-from-bpairs `(AND ,@(mapcar #'keep-because-of-bpair1 blist)))
      (cond-from-bpairs (rob-simplify cond-from-bpairs 'no-sub)))
     (when cond-from-bpairs
      `(AND ,cond1 ,cond2 ,cond-from-bpairs))))))

(defun find-new-cond2 (blist cond1 cond2)
 (unless (eq blist 'No-match)
  (unless (null blist)
    (let* (
      (cond-from-bpairs `(AND ,@(mapcar #'keep-because-of-bpair2 
                                  (reverse-blist blist))))
                         ;;note ^^ reverse-blist
      (cond-from-bpairs (rob-simplify cond-from-bpairs 'no-sub)))
     (when cond-from-bpairs
      `(AND ,cond1 ,cond2 ,cond-from-bpairs))))))


(defun keep-because-of-bpair1 (bpair)
 (let* (
   (var1             (first  bpair))
   (var2             (second bpair))
   (var1-existential (existential-var? var1))
   (var2-existential (existential-var? var2))
   (var1-constant    (NOT (rob-is-var? var1)))
   (var2-constant    (NOT (rob-is-var? var2)))
   (var1-universal   (universal-var?   var1))
   (var2-universal   (universal-var?   var2)))
  (cond
   ((AND var1-existential var2-existential)
    nil)
   ((AND var1-existential var2-universal)
    `(is-equal ,var1 ,var2))
   ((AND var1-universal   var2-existential)
    nil)
   ((AND var1-universal   var2-universal)
    `(is-equal ,var1 ,var2))
   ((AND var1-constant    var2-existential)
    nil)
   ((AND var1-constant    var2-universal)
    `(is-equal ,var1 ,var2))
   ((AND var1-existential var2-constant)
    nil)
   ((AND var1-universal   var2-constant)
    nil)  ;;constant one will be kept with other way around
   (t (format t "~%Unknown variables to keep-because-of-bpair")))))

(defun keep-because-of-bpair2 (bpair)
 (let* (
   (var1             (first  bpair))
   (var2             (second bpair))
   (var1-existential (existential-var? var1))
   (var2-existential (existential-var? var2))
   (var1-constant    (NOT (rob-is-var? var1)))
   (var2-constant    (NOT (rob-is-var? var2)))
   (var1-universal   (universal-var?   var1))
   (var2-universal   (universal-var?   var2)))
  (cond
   ((AND var1-existential var2-existential)
    nil)
   ((AND var1-existential var2-universal)
    `(is-equal ,var1 ,var2))
   ((AND var1-universal   var2-existential)
    nil)
   ((AND var1-universal   var2-universal)
    nil)  ;;only difference between keep-because-of-bpair1
   ((AND var1-constant    var2-existential)
    nil)
   ((AND var1-constant    var2-universal)
    `(is-equal ,var1 ,var2))
   ((AND var1-existential var2-constant)
    nil)
   ((AND var1-universal   var2-constant)
    nil)  ;;constant one will be kept with other way around
   (t (format t "~%Unknown variables to keep-because-of-bpair")))))


(defun effects-union (effects1 &rest effectsx)
 (if (null effectsx) 
  effects1
  (let (
    (ne (union effects1 (first effectsx) :test #'equal)))
   (apply #'effects-union (cons ne (rest effectsx))))))


;;Takes in ((a b) (x y) ...)
;;Returns ((is-equal a b) (is-equal x y) (is-equal ...))

(defun Blist-to-eqlist (Blist)
 (unless (eq blist 'No-match)
  (mapcar #'(lambda (bpair) `(is-equal ,@bpair)) Blist)))

;;Takes in ((a b) (x y) ...)
;;Returns ((not-equal a b) (not-equal x y) (not-equal ...))

(defun Blist-to-noteqlist (Blist)
 (mapcar #'(lambda (bpair) `(not-equal ,@bpair)) Blist))



;;calls simplify on the conditional of the necessary effects

(defun simplify-ne (ne)
 (mapcar #'simplify-one-ne ne))

(defun simplify-one-ne (ne)
 (let* (

  (cond-blist (rob-simplify (second ne)))
  (cond       (first cond-blist))
  (blist      (second cond-blist))
  (pred (instantiate (first ne) blist))
  (gen  (instantiate (third ne) blist)))

 `(,pred ,cond ,gen)))

(defun remove-if-pred-is-open-or-static (ne)
 (remove-if #'(lambda (ne) (is-open-or-static (first ne))) ne))


;;MOD TO FIND STATIC PREDICATES
;;The following version will leave static predicates in, but remove open
;; predicates.
;;(defun remove-if-pred-is-open-or-static (ne)
;; (remove-if #'(lambda (ne) (is-open-world-pred (first ne))) ne))


(defun dribble-ne (file)
 (dribble file)
   (format t "~%NE for domain: ~s~%~%~%" *CURRENT-DOMAIN*)
   (iter:iterate
   (iter:for root iter:in *roots*)
     (format t "~%~%~%------------------------------------------------")
     (format t "~%NE for PSG ~s~%" (literal-name root))
     (format-list (literal-necessary-effects root)))
 (dribble))


(defun format-list (x)
 (mapcar #'(lambda (y) (format t "~%~s" y)) x))


;; Takes the cond and ands it with each conditional in effects
;; Output: effects-list

(defun and-cond-to-ne (cond effects)
 (mapcar #'(lambda (effect)
            (if (eq (second effect) T)
             `(,(first effect) ,cond ,(third effect))
             `(,(first effect) (AND ,cond ,(second effect))
                      ,(third effect))))
   effects))



;;find all the nes with the same predicate
;; as the first ne.
;; 
(defun compress-effects (nes)
 (unless (null nes)
  (if (eq (length nes) 1)
   nes
  (let* (
    (first-ne-pred        (first (first nes)))
    (same-as-first-ne     (remove-if-not #'(lambda (ne)
                            (equal (first ne)
                                   first-ne-pred))
                           nes))
    (not-same-as-first-ne (remove-if     #'(lambda (ne)
                            (equal (first ne)
                                    first-ne-pred))
                           nes)))
   (append (compress-effect same-as-first-ne)
           (compress-effects not-same-as-first-ne))))))

;;Input: nes with all the same predicate
;;Output: one nes with that predicate, but the 
;;  conditionals ORed and the Generators unioned
(defun compress-effect (nes)
 (unless (null nes)
  (if (eq 1 (length nes))
   nes
   (let* (
     (ne1    (first  nes))
     (ne2    (second nes))
     (pred   (first  ne1))
     (cond1  (second ne1))
     (cond2  (second ne2))
     (gen1   (third  ne1))
     (gen2   (third  ne2))
     (ne12   `(,pred ,(first (rob-simplify `(OR ,cond1 ,cond2)))
               ,(INTERSECTION gen1 gen2 :test #'equal))))
    (compress-effects (cons ne12 (rest (rest nes))))))))

  

(defun generally-simplify-ne (nes)
 (mapcar #'make-all-goal-consts-into-vars
  (remove-useless-is-equals-from-nes
   (remove-useless-not-equals-from-nes
    (compress-effects 
     (remove-if-pred-is-open-or-static
      nes))))))

(defun generally-simplify-ne-of-node (node)
 (when node
  (cond
   ((literal-p node) 
    (setf (literal-necessary-effects node) 
     (generally-simplify-ne (literal-necessary-effects node))))
   ((operator-p node)
    (setf (operator-necessary-effects node)
     (generally-simplify-ne (operator-necessary-effects node))))
   (T (format t "~%ERROR in function generally-simplify-ne-of-node")))))

(defun generally-simplify-ne-of-root (root)
 (generally-simplify-ne-of-node root)
 (iter:iterate
 (iter:for operator iter:in (literal-operators root))
  (generally-simplify-ne-of-node operator)))


;;--detail functions below used to clean up results.
;; should set to work down two levels into operators


;;For the variables in var it replaces every
;; occurance of (not-equal var <x>) or 
;;              (not-equal <x> var) with T
;;

(defun sub-replace-not-equal-with-t (exp vars)
 (if (atom exp)
  exp
  (if (eq 'not-equal (first exp))
   (let (
     (neq-vars (find-variables exp)))
    (if (intersection vars neq-vars :test #'eq)
     T
     exp))
   (mapcar #'(lambda (exp) 
       (sub-replace-not-equal-with-t exp vars)) exp))))

(defun replace-not-equal-with-t (exp vars)
 (first (rob-simplify (sub-replace-not-equal-with-t exp vars))))

;;For the variables in var it replaces every
;; occurance of (is-equal var <x>) or 
;;              (is-equal <x> var) with T
;;

(defun sub-replace-is-equal-with-t (exp vars)
 (if (atom exp)
  exp
  (if (eq 'is-equal (first exp))
   (let (
     (neq-vars (find-variables exp)))
    (if (intersection vars neq-vars :test #'eq)
     T
     exp))
   (mapcar #'(lambda (exp) 
       (sub-replace-is-equal-with-t exp vars)) exp))))

(defun replace-is-equal-with-t (exp vars)
 (first (rob-simplify (sub-replace-is-equal-with-t exp vars))))


;;need to rewrite to handle case where 
;;  (not-equal <x> <y>) appears twice.
;;  For example in different ORs
(defun remove-useless-not-equals-from-nes (nes)
 (iter:iterate
 (iter:for ne iter:in nes)
  (iter:collect
   (let* (
     (pred      (first ne))
     (pred-cond (butlast ne 1))
     (cond      (second ne))
     (gen       (third ne))
     (once-vars (find-variables-which-occur-once pred-cond))
     (once-vars (remove-if #'goal-var? once-vars))
     (new-cond  (replace-not-equal-with-t cond once-vars)))
    `(,pred ,new-cond ,gen)))))


;;need to rewrite to handle case where 
;;  (is-equal <x> <y>) appears twice.
;;  For example in different ORs
(defun remove-useless-is-equals-from-nes (nes)
 (iter:iterate
 (iter:for ne iter:in nes)
  (iter:collect
   (let* (
     (pred      (first ne))
     (pred-cond (butlast ne 1))
     (cond      (second ne))
     (gen       (third ne))
     (once-vars (find-variables-which-occur-once pred-cond))
     (once-vars (remove-if-not #'universal-var? once-vars))
     (once-vars (remove-if #'goal-var? once-vars))
     (new-cond  (replace-is-equal-with-t cond once-vars)))
    `(,pred ,new-cond ,gen)))))


