;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Functions for generating and recognizing names
;;
;; Author: Oren Etzioni
;; Modified:  Julie Roomy, Rob Spiger
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Generates a new variable name.
(defun generate-random-var ()
  (setq *var-name-counter* (1+ *var-name-counter*))
  (intern (concatenate 'string "<V"
		       (princ-to-string *var-name-counter*)
		       ">")))

(defun generate-random-wild-card ()
  (setq *wc-name-counter* (1+ *wc-name-counter*))
  (intern (concatenate 'string "<W"
		       (princ-to-string *wc-name-counter*)
		       ">")))

(defun generate-random-forall ()
  (setq *forall-name-counter* (1+ *forall-name-counter*))
  (intern (concatenate 'string "<F"
		       (princ-to-string *forall-name-counter*)
		       ">")))

(defun generate-random-active ()
  (setq *forall-name-counter* (1+ *forall-name-counter*))
  (intern (concatenate 'string "<A"
		       (princ-to-string *forall-name-counter*)
		       ">")))

(defun generate-random-exists ()
  (setq *exists-name-counter* (1+ *exists-name-counter*))
  (intern (concatenate 'string "<E"
		       (princ-to-string *exists-name-counter*)
		       ">")))


; Generate a new constant.
(defun generate-random-const ()
  (setq *const-name-counter* (1+ *const-name-counter*))
  (intern (concatenate 'string "B-"
		       (princ-to-string *const-name-counter*))))

; Generate a new goal constant.
(defun generate-goal-const ()
  (setq *const-name-counter* (1+ *const-name-counter*))
  (intern (concatenate 'string "G-"
		       (princ-to-string *const-name-counter*))))

;;make goal constant into a variable
;; G-x becomes <G-x>
;;
(defun constant-into-variable (constant)
 (intern (concatenate 'string "<" (string constant) ">"))) 

(defun make-lit-name ()
  (setq *nod-name-counter* (1+ *nod-name-counter*))
  (intern (concatenate 'string "<N"
		       (princ-to-string *nod-name-counter*)
		       ">")))





; This HACK loses if a user-defined constant starts with "B-".
(defun random-const? (x)
 (OR
  (goal-const? x)
  (and (not (numberp x))
       (and (eq (schar (symbol-name x) 0) #\B)
	    (eq (schar (symbol-name x) 1) #\-)))))



; This HACK loses if a user-defined constant starts with "G-".
(defun goal-const? (x)
  (and (not (numberp x))
       (and (eq (schar (symbol-name x) 0) #\G)
	    (eq (schar (symbol-name x) 1) #\-))))

(defun wild? (x) (wild-var? x))

(defun wild-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\W))))

(defun normal-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\V))))

(defun exists-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\E))))

(defun forall-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\F))))

(defun goal-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\G))))

(defun active-var? (x)
 (when (rob-is-var? x)
  (and (not (numberp x))
       (eq (schar (symbol-name x) 1) #\A))))

(defun my-var? (x)
 (when (rob-is-var? x)
  (if (numberp x)
      NIL
    (let ((name (symbol-name x)))
      (and (> (length name) 1)
	   (eq (schar name 1) #\V))))))

(defun is-constant (arg)
  (not (rob-is-var? arg)))

(defun rob-is-var? (x)
 (is-variable x))