;;;---------------------------------------------------------------
;;;
;;;   schedule.lisp
;;;   Leonard Dickens
;;;   7/92
;;;
;;;   This is a strips implementation of blocksworld augmented with
;;;   some scheduling deadlines.
;;;---------------------------------------------------------------

(reset-stripsops)

(strips-op move-block-to-table
	   :filter         ( (clear ?x) 
			     (on ?x ?y) )
	   :add-list       ( (on ?x table) 
			     (clear ?y) )
	   :delete-list    ( (on ?x ?y) ) 
	   :command-string "move ?x from ?y to the table"
	   :variables      (?x ?y)
	   :duration       2
	   )

(strips-op move-block-to-block
	   :filter         ( (clear ?x) 
			     (clear ?z) 
			     (on ?x ?y) )
	   :add-list       ( (on ?x ?z) 
			     (clear ?y) )
	   :delete-list    ( (on ?x ?y) 
			     (clear ?z) )
	   :command-string "move ?x from ?y to ?z"
	   :variables      (?x ?y ?z)
	   :duration       1
	   )

;;
;; +---+    +---+
;; | a |    | c |
;; +---+    +---+
;; | b |    | d |
;;-+---+----+---+-  <-- table
;;    
(setq ab-cd
  '((clear a)
    (on a b)
    (on b table)
    (clear c)
    (on c d)
    (on d table)))


(defun test0 ()
  (strips 
   ab-cd
   ab-cd))


(defun test1 ()
  (strips 
   ab-cd
   '((on a c) 
     (on b d))))


(defun test2 ()
  (strips 
   ab-cd
   '((on a b) 
     (on b d))))


(defun test3 ()
  (strips 
   ab-cd
   '((on b c) 
     (on c d))))


(defun test4 ()
  (strips 
   ab-cd
   '((on a c) 
     (on c d))))


(defun test5 ()
  (strips 
   ab-cd
   '((on c d)
     (on a c))))


     



