;;;---------------------------------------------------------------
;;;
;;;   register.lisp
;;;   Leonard Dickens
;;;   7/92
;;;
;;;   This is a strips implementation of the classic register-swapping
;;;   problem.  Strips fails to solve this problem.
;;;---------------------------------------------------------------

(reset-stripsops)

(strips-op copy-register
	   :filter         ( (has-value ?r2 ?y)
			     (has-value ?r1 ?x) )
	   :add-list       ( (has-value ?r2 ?x) )
	   :delete-list    ( (has-value ?r2 ?y) ) 
	   :command-string "copy ?x from register ?r1 to ?r2"
	   :variables      (?x ?y ?r1 ?r2)
	   )

(defun test ()
  (strips 
   '((has-value a 1)
     (has-value b 2)
     (has-value c 0))
   '((has-value a 2)
     (has-value b 1))))

